package com.biz.crm.tpm.business.audit.fee.local.service.internal.ledger;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.NumberUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.audit.fee.local.entity.ledger.AuditFeeDiffLedger;
import com.biz.crm.tpm.business.audit.fee.local.entity.ledger.AuditFeeDiffLedgerDeduction;
import com.biz.crm.tpm.business.audit.fee.local.helper.AuditFeeDiffLedgerHelper;
import com.biz.crm.tpm.business.audit.fee.local.repository.ledger.AuditFeeDiffLedgerDeductionRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.ledger.AuditFeeDiffLedgerRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerConfirmDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffLedgerOperationTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditStateEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.event.ledger.AuditFeeDiffLedgerEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.ledger.AuditFeeDiffLedgerVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;

import java.math.BigDecimal;
import java.util.*;

import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

import static com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants.AUDIT_FEE_CHECK_DIFF_TRACK_LEDGER_USE_AMOUNT;

/**
 * 核销差异费用台账(AuditFeeDiffLedger)表服务实现类
 *
 * @author makejava
 * @date 2022-12-19 11:07:55
 */
@Slf4j
@Service("auditFeeDiffLedgerVoService")
public class AuditFeeDiffLedgerVoServiceImpl implements AuditFeeDiffLedgerVoService {

    @Autowired(required = false)
    private AuditFeeDiffLedgerRepository auditFeeDiffLedgerRepository;

    @Autowired(required = false)
    private List<AuditFeeDiffLedgerEventListener> eventListeners;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Resource
    private AuditFeeDiffLedgerHelper auditFeeDiffLedgerHelper;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private AuditFeeDiffLedgerDeductionRepository auditFeeDiffLedgerDeductionRepository;

    @Override
    public Page<AuditFeeDiffLedgerVo> findByConditions(Pageable pageable, AuditFeeDiffLedgerDto dto) {
        return this.auditFeeDiffLedgerRepository.findByConditions(pageable, dto);
    }

    /**
     * 选择台帐列表
     * @param pageable
     * @param dto
     * @return {@link Page}<{@link AuditFeeDiffLedgerVo}>
     */
    @Override
    public Page<AuditFeeDiffLedgerVo> selectByConditions(Pageable pageable, AuditFeeDiffLedgerDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffLedgerDto());
        Page<AuditFeeDiffLedgerVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditFeeDiffLedgerRepository.selectByConditions(page, dto);
    }

    @Override
    public AuditFeeDiffLedgerVo findDetailById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }

        AuditFeeDiffLedger auditFeeDiffLedger = this.auditFeeDiffLedgerRepository.findById(id);
        if (auditFeeDiffLedger == null) {
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(auditFeeDiffLedger, AuditFeeDiffLedgerVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AuditFeeDiffLedgerVo create(AuditFeeDiffLedgerDto dto) {
        this.auditFeeDiffLedgerHelper.verifyEmpty(dto);
//        String ruleCode = StringUtils.join(AuditFeeConstants.AUDIT_FEE_DIFF_LEDGER_CODE, DateFormatUtils.format(new Date(), "yyyyMMdd"));
        dto.setFeeDiffLedgerCode(generateCodeService.generateCode(AuditFeeConstants.AUDIT_FEE_DIFF_LEDGER_CODE, 1).get(0));
        dto.setStatus(AuditStateEnum.WAIT_CONFIRM.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setRecoveredAmount(BigDecimal.ZERO);
        dto.setBeRecoveredAmount(BigDecimal.ZERO);
        dto.setFollowUpPerson(loginUserService.getLoginAccountName());
        AuditFeeDiffLedger auditFeeDiffLedger = nebulaToolkitService.copyObjectByWhiteList(dto, AuditFeeDiffLedger.class, HashSet.class, ArrayList.class);
        this.auditFeeDiffLedgerRepository.saveOrUpdate(auditFeeDiffLedger);

        //auditFeeDiffLedgerVo.setId(auditFeeDiffLedger.getId());

        /*//crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditFeeDiffLedgerEventListener auditFeeDiffLedgerEventListener : eventListeners) {
                auditFeeDiffLedgerEventListener.onCreate(auditFeeDiffLedgerVo);
            }
        }

        // 发送通知
        AuditFeeDiffLedgerLogEventDto logEventDto = new AuditFeeDiffLedgerLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditFeeDiffLedgerVo);
        SerializableBiConsumer<AuditFeeDiffLedgerLogEventListener, AuditFeeDiffLedgerLogEventDto> onCreate = AuditFeeDiffLedgerLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, AuditFeeDiffLedgerLogEventListener.class, onCreate);*/
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AuditFeeDiffLedgerVo update(AuditFeeDiffLedgerDto dto) {
        /*this.updateValidation(auditFeeDiffLedgerVo);
        String currentId = auditFeeDiffLedgerVo.getId();
        AuditFeeDiffLedger current = auditFeeDiffLedgerRepository.findById(currentId);
        current = Validate.notNull(current, "修改信息不存在");
        AuditFeeDiffLedgerVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(current, AuditFeeDiffLedgerVo.class, HashSet.class, ArrayList.class);


        this.auditFeeDiffLedgerRepository.saveOrUpdate(current);*/
        //crud监听事件
        /*if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditFeeDiffLedgerEventListener auditFeeDiffLedgerEventListener : eventListeners) {
                auditFeeDiffLedgerEventListener.onUpdate(oldVo, auditFeeDiffLedgerVo);
            }
        }*/

        // 发送修改通知
        /*AuditFeeDiffLedgerLogEventDto logEventDto = new AuditFeeDiffLedgerLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditFeeDiffLedgerVo);
        SerializableBiConsumer<AuditFeeDiffLedgerLogEventListener, AuditFeeDiffLedgerLogEventDto> onUpdate = AuditFeeDiffLedgerLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, AuditFeeDiffLedgerLogEventListener.class, onUpdate);*/
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffLedgerRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffLedgerRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditFeeDiffLedgerRepository.updateDelFlagByIds(ids);
    }

    @Override
    public void confirm(AuditFeeDiffLedgerConfirmDto dto) {
        Validate.notNull(dto.getId(), "主键id列表不能为空");
        Validate.notNull(dto.getConfirmDiffAmount(),"确认差异金额不能为空！");
        AuditFeeDiffLedger ledger = this.auditFeeDiffLedgerRepository.getById(dto.getId());
        Validate.notNull(ledger, "对象实例不存在");
        Validate.isTrue(!AuditStateEnum.CONFIRMED.getCode().equals(ledger.getStatus()),"数据已确认过！");
        ledger.setStatus(AuditStateEnum.CONFIRMED.getCode());
        ledger.setConfirmDiffAmount(dto.getConfirmDiffAmount());
        ledger.setBeRecoveredAmount(dto.getConfirmDiffAmount());
        ledger.setRecoveredAmount(BigDecimal.ZERO);
        this.auditFeeDiffLedgerRepository.updateById(ledger);

        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            List<AuditFeeDiffLedgerVo> list = Lists.newArrayList();
            AuditFeeDiffLedgerVo auditFeeDiffLedgerVo = nebulaToolkitService.copyObjectByWhiteList(ledger,AuditFeeDiffLedgerVo.class, HashSet.class, ArrayList.class);
            list.add(auditFeeDiffLedgerVo);
            for (AuditFeeDiffLedgerEventListener auditFeeDiffLedgerEventListener : eventListeners) {
                auditFeeDiffLedgerEventListener.onConfirm(list);
            }
        }
    }

    @Override
    public List<AuditFeeDiffLedgerVo> findDetailByCodes(List<String> ledgerCodes) {
        if (CollectionUtils.isEmpty(ledgerCodes)) {
            return Collections.emptyList();
        }
        List<AuditFeeDiffLedger> auditFeeDiffLedgers = this.auditFeeDiffLedgerRepository.findDetailByCodes(ledgerCodes);
        if (CollectionUtils.isEmpty(auditFeeDiffLedgers)) {
            return Collections.emptyList();
        }

        return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(auditFeeDiffLedgers, AuditFeeDiffLedger.class, AuditFeeDiffLedgerVo.class, HashSet.class, ArrayList.class));
    }

    /**
     * 回滚金额
     *
     * @param ledgerAmountMap key 台帐编码  value 回滚金额
     */
    @Override
    public void rollBackAmount(Map<String, BigDecimal> ledgerAmountMap) {
        //todo 加锁
        if (MapUtil.isEmpty(ledgerAmountMap)){
            return;
        }
        ledgerAmountMap.forEach((k,v)->{
            AuditFeeDiffLedgerVo auditFeeDiffLedgerVo = this.findDetailByCode(k);
            if (Objects.nonNull(auditFeeDiffLedgerVo)){
                auditFeeDiffLedgerVo.setDiffAmount(NumberUtil.add(auditFeeDiffLedgerVo.getDiffAmount(),v));
            }
        });
    }


    /**
     * 根据编码获取差异费用台帐
     *
     * @param k 差异费用台帐编码
     * @return {@link AuditFeeDiffLedgerVo}
     */
    @Override
    public AuditFeeDiffLedgerVo findDetailByCode(String k) {
        Validate.notNull(k,"编码不能为空");
        AuditFeeDiffLedger auditFeeDiffLedger = this.auditFeeDiffLedgerRepository.findDetailByCode(k);
        if (auditFeeDiffLedger == null) {
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(auditFeeDiffLedger,AuditFeeDiffLedgerVo.class,HashSet.class,ArrayList.class);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void useAmount(AuditFeeDiffLedgerDeductionDto dto) {
        log.info("差异费用台账操作扣减明细");
        Validate.notNull(dto,"参数不能为空！");
        Validate.notBlank(dto.getFeeDiffLedgerCode(),"差异费用编码不能为空！");
        Validate.notBlank(dto.getOperationType(),"操作类型不能为空！");
        AuditFeeDiffLedgerOperationTypeEnum operationTypeEnum = AuditFeeDiffLedgerOperationTypeEnum.codeToEnum(dto.getOperationType());
        Validate.notNull(operationTypeEnum,"未知的操作类型！");
        Validate.notNull(dto.getRecoveredAmount(),"金额不能为空！");
        if (dto.getRecoveredAmount().compareTo(BigDecimal.ZERO) < 0) {
            return;
        }
        if (!redisLockService.isLock(AUDIT_FEE_CHECK_DIFF_TRACK_LEDGER_USE_AMOUNT + dto.getFeeDiffLedgerCode()) ) {
            throw new RuntimeException("差异费用台账【"+dto.getFeeDiffLedgerCode()+"】操作金额时，未加锁！");
        }
        AuditFeeDiffLedger diffLedger = this.auditFeeDiffLedgerRepository.findDetailByCode(dto.getFeeDiffLedgerCode());
        Validate.notNull(diffLedger,"未找到差异费用台账【"+dto.getFeeDiffLedgerCode()+"】");
        Validate.isTrue(AuditStateEnum.CONFIRMED.getCode().equals(diffLedger.getStatus()),"差异费用台账【"+dto.getFeeDiffLedgerCode()+"】,状态为'未确认',不可用！");

        //待追回金额
        BigDecimal beRecoveredAmount = Optional.ofNullable(diffLedger.getBeRecoveredAmount()).orElse(BigDecimal.ZERO);
        //已追回金额
        BigDecimal recoveredAmount = Optional.ofNullable(diffLedger.getRecoveredAmount()).orElse(BigDecimal.ZERO);

        if (AuditFeeDiffLedgerOperationTypeEnum.DEDUCTION_AMOUNT.getCode().equals(dto.getOperationType())
                || AuditFeeDiffLedgerOperationTypeEnum.RECOVER_AMOUNT.getCode().equals(dto.getOperationType())) {

            Validate.isTrue(diffLedger.getBeRecoveredAmount().compareTo(dto.getRecoveredAmount()) >= 0 , "抵扣或追回时，操作金额不能大于台账的待追回金额！");
        }

        //扣减明细
        AuditFeeDiffLedgerDeduction deduction = nebulaToolkitService.copyObjectByWhiteList(dto,AuditFeeDiffLedgerDeduction.class,HashSet.class,ArrayList.class);
        deduction.setOperationType(dto.getOperationType());
        deduction.setFeeDiffLedgerCode(diffLedger.getFeeDiffLedgerCode());
        deduction.setRecoveredAmount(dto.getRecoveredAmount());
        deduction.setRecoveredTime(new Date());
        deduction.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        deduction.setTenantCode(TenantUtils.getTenantCode());

        if (AuditFeeDiffLedgerOperationTypeEnum.DEDUCTION_AMOUNT.getCode().equals(dto.getOperationType())
                || AuditFeeDiffLedgerOperationTypeEnum.RECOVER_AMOUNT.getCode().equals(dto.getOperationType())) {
            //主表
            diffLedger.setBeRecoveredAmount(beRecoveredAmount.subtract(dto.getRecoveredAmount()));
            diffLedger.setRecoveredAmount(recoveredAmount.add(dto.getRecoveredAmount()));
        }
        if (AuditFeeDiffLedgerOperationTypeEnum.RETURN_AMOUNT.getCode().equals(dto.getOperationType())) {
            //主表
            diffLedger.setBeRecoveredAmount(beRecoveredAmount.add(dto.getRecoveredAmount()));
            diffLedger.setRecoveredAmount(recoveredAmount.subtract(dto.getRecoveredAmount()));
        }

        this.auditFeeDiffLedgerDeductionRepository.save(deduction);
        this.auditFeeDiffLedgerRepository.updateById(diffLedger);

    }

}
