package com.biz.crm.tpm.business.audit.fee.local.service.internal.track;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ObjectConvertStringUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.audit.fee.local.repository.track.AuditFeeDiffTrackDetailRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.gateway.websocket.client.sdk.service.ChannelMsgService;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

/**
 * 活动方案分页缓存处理类
 * @author wanghaojia
 * @date 2022/12/16 11:22
 */
@Slf4j
@Component
public class AuditFeeDiffTrackDetailPageCacheHelper extends MnPageCacheHelper<AuditFeeDiffTrackDetailVo, AuditFeeDiffTrackDetailDto> {

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    private AuditFeeDiffTrackDetailRepository auditFeeDiffTrackDetailRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ChannelMsgService channelMsgService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Value("${spring.application.name:}")
    private String applicationName;

    @Override
    public String getCacheKeyPrefix() {
        return AuditFeeConstants.AUDIT_FEE_DIFF_TRACK_DETAIL;
    }

    @Override
    public Class<AuditFeeDiffTrackDetailDto> getDtoClass() {
        return AuditFeeDiffTrackDetailDto.class;
    }

    @Override
    public Class<AuditFeeDiffTrackDetailVo> getVoClass() {
        return AuditFeeDiffTrackDetailVo.class;
    }

    @Override
    public List<AuditFeeDiffTrackDetailDto> findDtoListFromRepository(AuditFeeDiffTrackDetailDto dto, String cacheKey) {
        //有模板编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String planCode = split[0];//业务数据编码，结构 业务数据编码+前端随机码+模板编码
        String templateCode = split[2];//模板编码，结构 业务数据编码+前端随机码+模板编码

        String redisCacheIdKey = getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = getRedisCacheDataKey(cacheKey);

        //有策略编码，从数据库里面查出来放到缓存里面
        List<AuditFeeDiffTrackDetailVo> detailVoList = auditFeeDiffTrackDetailRepository.findByPlanCodeList(Lists.newArrayList(planCode));
        List<AuditFeeDiffTrackDetailDto> allDtoList = (List<AuditFeeDiffTrackDetailDto>) nebulaToolkitService.copyCollectionByBlankList(detailVoList, AuditFeeDiffTrackDetailVo.class, AuditFeeDiffTrackDetailDto.class, HashSet.class, ArrayList.class);
        allDtoList.sort(Comparator.comparing(AuditFeeDiffTrackDetailDto::getPlanCode));
        ObjectConvertStringUtil.fillObjectListStrProperties(allDtoList,AuditFeeDiffTrackDetailDto.class);
        allDtoList.forEach(e -> {
            e.setActivityTypeCode(e.getActivityTypeCode());
            e.setDetailCode(e.getDetailCode());
            /*if(Objects.nonNull(e.getActivityBeginDate())) {
                e.setActivityBeginDateStr(DateUtil.dateStrYYYYMMDD(e.getActivityBeginDate()));
            }
            if(Objects.nonNull(e.getActivityEndDate())) {
                e.setActivityEndDateStr(DateUtil.dateStrYYYYMMDD(e.getActivityEndDate()));
            }
            if(Objects.nonNull(e.getScheduleBeginDate())) {
                e.setScheduleBeginDateStr(DateUtil.dateStrYYYYMMDD(e.getScheduleBeginDate()));
            }
            if(Objects.nonNull(e.getScheduleEndDate())) {
                e.setScheduleEndDateStr(DateUtil.dateStrYYYYMMDD(e.getScheduleEndDate()));
            }*/
        });

        Map<String, List<AuditFeeDiffTrackDetailDto>> allMap = allDtoList.stream().collect(Collectors.groupingBy(AuditFeeDiffTrackDetailDto::getTemplateConfigCode));
        for (Map.Entry<String, List<AuditFeeDiffTrackDetailDto>> entry : allMap.entrySet()) {
            String thisRedisIdCacheKey = redisCacheIdKey.replace(templateCode,entry.getKey());

            String thisRedisDataCacheKey = redisCacheDataKey.replace(templateCode,entry.getKey());
            Map<Object, AuditFeeDiffTrackDetailDto> newItemMap = entry.getValue().stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
            redisService.lPushAll(thisRedisIdCacheKey, this.getExpireTime(), entry.getValue().stream().map(this::getDtoKey).toArray());
            redisTemplate.opsForHash().putAll(thisRedisDataCacheKey, newItemMap);
            redisService.expire(thisRedisDataCacheKey, this.getExpireTime());
        }

        return allMap.get(templateCode);
    }

    @Override
    public void fillVoListProperties(List<AuditFeeDiffTrackDetailVo> records) {
        super.fillVoListProperties(records);
    }

    @Override
    public boolean initToCacheFromRepository() {
        return false;
    }

    @Override
    public List<AuditFeeDiffTrackDetailDto> newItem(String cacheKey, List<AuditFeeDiffTrackDetailDto> itemList) {
        String[] split = cacheKey.split(":");
        String templateCode = split[2];//模板编码
        //页面新增
        AuditFeeDiffTrackDetailDto newItem = new AuditFeeDiffTrackDetailDto();
        newItem.setId(UUID.randomUUID().toString().replace("-", ""));
        newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return Lists.newArrayList(newItem);
    }

    /**
     * 导入新增数据，放入缓存
     * @param cacheKey
     * @param itemList
     * @return
     */
    public void importNewItem(String cacheKey, List<AuditFeeDiffTrackDetailDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);

        String[] split = cacheKey.split(":");
        String planCode = split[0];// 差异费用处理编码编码
        String templateCode = split[2];// 模板编码

        //导入新增数据
        for (AuditFeeDiffTrackDetailDto newItem : itemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setPlanCode(null);
            newItem.setTemplateConfigCode(templateCode);
        }

        Object[] newIdArr = itemList.stream().map(this::getDtoKey).toArray();
        redisService.lPushAll(redisCacheIdKey, this.getExpireTime(),newIdArr );

        Map<Object, AuditFeeDiffTrackDetailDto> updateMap = itemList.stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
        redisTemplate.opsForHash().putAll(redisCacheDataKey, updateMap);
        redisService.expire(redisCacheDataKey, this.getExpireTime());
    }

    @Override
    public List<AuditFeeDiffTrackDetailDto> copyItem(String cacheKey, List<AuditFeeDiffTrackDetailDto> itemList) {
        List<AuditFeeDiffTrackDetailDto> newItemList = (List<AuditFeeDiffTrackDetailDto>) nebulaToolkitService.copyCollectionByBlankList(itemList, AuditFeeDiffTrackDetailDto.class, AuditFeeDiffTrackDetailDto.class, HashSet.class, ArrayList.class);
        for (AuditFeeDiffTrackDetailDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setPlanCode(null);
            newItem.setDetailCode(null);
            if (!CollectionUtils.isEmpty(newItem.getAuditFeeDiffTrackDetailLedgerList())) {
                for (AuditFeeDiffTrackDetailLedgerDto detailLedgerDto : newItem.getAuditFeeDiffTrackDetailLedgerList()) {
                    detailLedgerDto.setId(UUID.randomUUID().toString().replace("-", ""));
                    detailLedgerDto.setPlanCode(null);
                    detailLedgerDto.setDetailCode(null);
                }
            }
        }
        return newItemList;
    }

    @Override
    public void updateItem(String cacheKey, List<AuditFeeDiffTrackDetailDto> itemList) {
        String[] split = cacheKey.split(":");
        String lockKey = ActivityPlanConstant.LOCK_ACTIVITY_PLAN_SAVE+split[0];
        if (redisLockService.isLock(lockKey)){
            throw new RuntimeException("数据已提交，请勿重复操作！");
        }

        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
    }

    @Override
    public List<AuditFeeDiffTrackDetailVo> dtoListToVoList(List<AuditFeeDiffTrackDetailDto> itemDtoList) {
        return super.dtoListToVoList(itemDtoList);
    }

    @Override
    public String getRedisCacheInitKey(String cacheKey) {
        String redisCacheInitKey = super.getRedisCacheInitKey(cacheKey);
        //有策略编码，从数据库里面查出来放到缓存里面
        String[] split = cacheKey.split(":");
        String templateCode = split[2];//模板编码

        return redisCacheInitKey.replace(templateCode,"");//要去掉模板编码，不然会重复初始化
    }

    @Override
    public Object getDtoKey(AuditFeeDiffTrackDetailDto AuditFeeDiffTrackDetailDto) {
        return AuditFeeDiffTrackDetailDto.getId();
    }

    @Override
    public String getCheckedStatus(AuditFeeDiffTrackDetailDto auditFeeDiffTrackDetailDto) {
        return auditFeeDiffTrackDetailDto.getChecked();
    }

    /**
     * 发送进度消息
     */
    public void sendMsg(String remark) {
        sendMsg(remark, ExecStatusEnum.RUNNING.getKey());
    }

    /**
     * 发送进度消息
     */
    public void sendMsg(String remark,String execStatus) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("remark",remark);
        String time = DateUtil.getDateStrByFormat(new Date(), DateUtil.DEFAULT_DATE_ALL_PATTERN);
        jsonObject.put("time",time);
        jsonObject.put("applicationName",applicationName);
        jsonObject.put("execStatus",execStatus);
        byte[] jsonBytes = JSONObject.toJSONBytes(jsonObject);
        String tenantCode = TenantUtils.getTenantCode();
        //所有业务所属通道标识
        String modelCode = ActivityPlanConstant.WEBSOCKET_MODEL_CODE_SAVE;
        log.info(" activity_plan model send msg2: tenantCode = {} , applicationName = {} , modelCode = {} ", tenantCode, applicationName, modelCode);
        UserIdentity loginUser = loginUserService.getLoginUser();
        //公共导入通道
        this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, applicationName, modelCode, loginUser.getAccount(), jsonBytes);
    }

}
