package com.biz.crm.tpm.business.audit.fee.local.service.internal.track;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.InterfacePushStateEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrack;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrackDetail;
import com.biz.crm.tpm.business.audit.fee.local.entity.track.AuditFeeDiffTrackDetailLedger;
import com.biz.crm.tpm.business.audit.fee.local.repository.track.AuditFeeDiffTrackDetailLedgerRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.track.AuditFeeDiffTrackDetailRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.track.AuditFeeDiffTrackRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.third.DiffTrackPushCowManager;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeDiffTrackConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffLedgerOperationTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffLedgerDataSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailLedgerVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackDetailVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.service.AuditFeeValidationVoService;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liquibase.util.Validate;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/**
 * 差异费用追踪细案接口实现
 * @author liyang
 * @date 2023/09/28
 */
@Slf4j
@Service
public class AuditFeeDiffTrackDetailVoServiceImpl extends MnPageCacheServiceImpl<AuditFeeDiffTrackDetailVo, AuditFeeDiffTrackDetailDto> implements AuditFeeDiffTrackDetailVoService {

  @Autowired
  private AuditFeeDiffTrackDetailRepository auditFeeDiffTrackDetailRepository;

  @Autowired
  private AuditFeeDiffTrackRepository auditFeeDiffTrackRepository;

  @Autowired
  private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;

  /**
   * 核销差异费用台账(AuditFeeDiffLedgerLock)表服务加锁接口
   */
  @Autowired(required = false)
  private AuditFeeDiffLedgerLockService auditFeeDiffLedgerLockService;

  @Autowired(required = false)
  private RedisService redisService;

  @Autowired(required = false)
  private RedisTemplate<String, Object> redisTemplate;

  @Autowired(required = false)
  private AuditFeeDiffTrackDetailLedgerRepository auditFeeDiffTrackDetailLedgerRepository;

  @Autowired(required = false)
  private AuditFeeValidationVoService auditFeeValidationVoService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired(required = false)
  private DiffTrackPushCowManager diffTrackPushCowManager;

  @Autowired(required = false)
  private RedisLockService redisLockService;

  @Override
  public Page<AuditFeeDiffTrackDetailVo> findCachePageList(Pageable pageable, AuditFeeDiffTrackDetailDto dto, String cacheKey) {
    String redisCacheIdKey = helper.getRedisCacheIdKey(cacheKey);
    String redisCacheDataKey = helper.getRedisCacheDataKey(cacheKey);
    String redisCacheInitKey = helper.getRedisCacheInitKey(cacheKey);
    Page<AuditFeeDiffTrackDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    page.setTotal(0);
    page.setRecords(Lists.newArrayList());

    a:if (redisService.hasKey(redisCacheIdKey)) {
      //redis里面有的话直接从redis里面取
      Long total = redisService.lSize(redisCacheIdKey);
      page.setTotal(total);
      List<Object> idList = redisService.lRange(redisCacheIdKey, page.offset(), page.offset() + page.getSize() - 1);
      if (CollectionUtils.isNotEmpty(idList)) {
        List<Object> dataList = redisTemplate.opsForHash().multiGet(redisCacheDataKey, idList);
        List<AuditFeeDiffTrackDetailDto> dtoList = (List<AuditFeeDiffTrackDetailDto>)(List) dataList;
        List<AuditFeeDiffTrackDetailVo> voList = helper.dtoListToVoList(dtoList);
        page.setRecords(voList);
      }
    } else if (!redisService.hasKey(redisCacheInitKey)) {
      //标记为已初始化，不重复初始化
      redisService.set(redisCacheInitKey, BooleanEnum.TRUE, helper.getExpireTime());
      //redis里面没有
      List<AuditFeeDiffTrackDetailDto> dtoList = helper.findDtoListFromRepository(dto, cacheKey);

      if (CollectionUtils.isEmpty(dtoList)) {
        break a;
      }

      if (helper.initToCacheFromRepository()) {
        helper.putCache(cacheKey,dtoList);
      }

      //放到缓存里面
      page.setTotal(dtoList.size());
      long start = page.offset();
      if (page.getTotal() > start) {
        long end = page.offset() + page.getSize();
        if (page.getTotal() < end) {
          end = page.getTotal();
        }
        List<AuditFeeDiffTrackDetailDto> recordDtoList = dtoList.subList((int) page.offset(), (int) end);
        List<AuditFeeDiffTrackDetailVo> voList = helper.dtoListToVoList(recordDtoList);
        page.setRecords(voList);
      }
    }
    //更新下VO里面的字段值
    helper.fillVoListProperties(page.getRecords());
    return page;
  }

  @Override
  public Page<AuditFeeDiffTrackDetailVo> findByConditions(Pageable pageable, AuditFeeDiffTrackDetailDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
    dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffTrackDetailDto());
    // 默认查未关闭的
    if (dto.getIsClose() == null) dto.setIsClose(BooleanEnum.FALSE.getCapital());
    Page<AuditFeeDiffTrackDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return this.auditFeeDiffTrackDetailRepository.findByConditions(page, dto);
  }

  @Override
  public AuditFeeDiffTrackDetailVo findDetailById(String id) {
    AuditFeeDiffTrackDetail byId = auditFeeDiffTrackDetailRepository.findById(id);
    if (byId == null) return null;
    AuditFeeDiffTrackDetailVo vo = new AuditFeeDiffTrackDetailVo();
    BeanUtils.copyProperties(byId, vo);
    return vo;
  }

  @Override
  public List<AuditFeeDiffTrackDetailVo> findDetailByPlanCodeList(List<String> planCodeList) {
    if (CollectionUtils.isEmpty(planCodeList)) return new ArrayList<>();
    return auditFeeDiffTrackDetailRepository.findByPlanCodeList(planCodeList);
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void createBatch(List<AuditFeeDiffTrackDetailDto> detailDtoList) {
    if (CollectionUtils.isEmpty(detailDtoList)) return;
    auditFeeDiffTrackDetailRepository.createBatch(detailDtoList);
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void removeBatchByPlanCodeList(List<String> planCodeList) {
    if (CollectionUtils.isEmpty(planCodeList)) return;
    auditFeeDiffTrackDetailRepository.removeBatchByPlanCodeList(planCodeList);
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void useMonthBudgetByPlanCodeList(List<String> planCodeList,String operateId) {
    List<AuditFeeDiffTrackDetailVo> detailVoList = auditFeeDiffTrackDetailRepository.findByPlanCodeList(planCodeList);
    if (CollectionUtils.isEmpty(detailVoList)) return;
    List<AuditFeeDiffTrackDetailLedgerVo> diffList = new ArrayList<>();
    for (AuditFeeDiffTrackDetailVo vo : detailVoList) {
      if (CollectionUtils.isNotEmpty(vo.getAuditFeeDiffTrackDetailLedgerList())) diffList.addAll(vo.getAuditFeeDiffTrackDetailLedgerList());
    }
    if (CollectionUtils.isEmpty(diffList)) return;

    AbstractCrmUserIdentity crmUserIdentity = this.loginUserService.getAbstractLoginUser();
    Map<String,AuditFeeDiffTrackDetailVo> detailVoMap = detailVoList.stream().collect(Collectors.toMap(AuditFeeDiffTrackDetailVo::getDetailCode, Function.identity(),(v1,v2) -> v1));
    // 扣减 多个明细可能选同一个差异台账，相同台账使用金额归集到一起进行扣减
    ArrayList<AuditFeeDiffLedgerDeductionDto> ledgerDeductionDtoList = new ArrayList<>();
    for (AuditFeeDiffTrackDetailLedgerVo diff : diffList) {
      AuditFeeDiffTrackDetailVo detailVo = detailVoMap.get(diff.getDetailCode());

      /*AuditFeeDiffLedgerDeductionDto ledgerDto = ledgerDeductionDtoList.stream().filter(e -> e.getFeeDiffLedgerCode().equals(diff.getFeeDiffLedgerCode())).findAny().orElse(null);
      if (ledgerDto == null) {
        ledgerDto = new AuditFeeDiffLedgerDeductionDto();
        ledgerDto.setRecoveredAmount(BigDecimal.ZERO);
      }*/
      AuditFeeDiffLedgerDeductionDto ledgerDto = new AuditFeeDiffLedgerDeductionDto();
      Validate.isTrue(Objects.nonNull(diff.getUsedAmount()),"差异费用使用金额不能为空");
      ledgerDto.setBusinessCode(diff.getDetailCode());
      ledgerDto.setActivityFormCode(detailVo.getActivityFormCode());
      ledgerDto.setActivityFormName(detailVo.getActivityFormName());
      ledgerDto.setActivityTypeCode(detailVo.getActivityTypeCode());
      ledgerDto.setActivityTypeName(detailVo.getActivityTypeName());
      ledgerDto.setResaleCommercialCode(detailVo.getSystemCode());
      ledgerDto.setResaleCommercialName(detailVo.getSystemName());
      ledgerDto.setTerminalCode(detailVo.getTerminalCode());
      ledgerDto.setTerminalName(detailVo.getTerminalName());
      ledgerDto.setOperatorName(crmUserIdentity.getRealName());
      ledgerDto.setOperatorAccount(crmUserIdentity.getAccount());
      ledgerDto.setFeeDiffLedgerCode(diff.getFeeDiffLedgerCode());
      ledgerDto.setRecoveredAmount(diff.getUsedAmount());
      ledgerDto.setFeeDiffLedgerDisposeCode(diff.getPlanCode());
      ledgerDeductionDtoList.add(ledgerDto);
    }
    // 调用差异抵扣接口写入差异台账
    List<String> codeList = ledgerDeductionDtoList.stream().map(AuditFeeDiffLedgerDeductionDto::getFeeDiffLedgerCode).filter(Objects::nonNull).collect(Collectors.toList());
    boolean lock = auditFeeDiffLedgerLockService.lock(codeList, TimeUnit.MINUTES, 1);
    Validate.isTrue(lock,"操作差异费用加锁失败,请稍后再试");
    //解锁要放在controller
    String key = String.format(AuditFeeDiffTrackConstants.AUDIT_FEE_DIFF_TRACK_OPERATE, operateId);
    this.redisService.set(key,codeList);

    for (AuditFeeDiffLedgerDeductionDto ledgerDeductionDto : ledgerDeductionDtoList) {
      ledgerDeductionDto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.DEDUCTION_AMOUNT.getCode());
      ledgerDeductionDto.setDataSource(DiffLedgerDataSourceEnum.DIFF_TRACK.getCode());
      auditFeeDiffLedgerVoService.useAmount(ledgerDeductionDto);
    }
    //auditFeeDiffLedgerLockService.unlock(codeList);
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void returnMonthBudgetByPlanCodeList(List<String> planCodeList,String operateId) {
    List<AuditFeeDiffTrackDetailVo> detailVoList = auditFeeDiffTrackDetailRepository.findByPlanCodeList(planCodeList);
    if (CollectionUtils.isEmpty(detailVoList)) return;

    List<AuditFeeDiffTrackDetailLedgerVo> diffList = new ArrayList<>();
    for (AuditFeeDiffTrackDetailVo vo : detailVoList) {
      if (CollectionUtils.isNotEmpty(vo.getAuditFeeDiffTrackDetailLedgerList())) diffList.addAll(vo.getAuditFeeDiffTrackDetailLedgerList());
    }
    if (CollectionUtils.isEmpty(diffList)) return;

    AbstractCrmUserIdentity crmUserIdentity = this.loginUserService.getAbstractLoginUser();
    Map<String,AuditFeeDiffTrackDetailVo> detailVoMap = detailVoList.stream().collect(Collectors.toMap(AuditFeeDiffTrackDetailVo::getDetailCode, Function.identity(),(v1,v2) -> v1));
    // 扣减 多个明细可能选同一个差异台账，相同台账使用金额归集到一起进行扣减
    ArrayList<AuditFeeDiffLedgerDeductionDto> ledgerDeductionDtoList = new ArrayList<>();
    for (AuditFeeDiffTrackDetailLedgerVo diff : diffList) {
      AuditFeeDiffTrackDetailVo detailVo = detailVoMap.get(diff.getDetailCode());
      /*AuditFeeDiffLedgerDeductionDto ledgerDto = ledgerDeductionDtoList.stream().filter(e -> e.getFeeDiffLedgerCode().equals(diff.getFeeDiffLedgerCode())).findAny().orElse(null);
      if (ledgerDto == null) {
        ledgerDto = new AuditFeeDiffLedgerDeductionDto();
        ledgerDto.setRecoveredAmount(BigDecimal.ZERO);
      }*/
      AuditFeeDiffLedgerDeductionDto ledgerDto = new AuditFeeDiffLedgerDeductionDto();
      Validate.isTrue(Objects.nonNull(diff.getUsedAmount()),"差异费用使用金额不能为空");
      ledgerDto.setBusinessCode(diff.getDetailCode());
      ledgerDto.setActivityFormCode(detailVo.getActivityFormCode());
      ledgerDto.setActivityFormName(detailVo.getActivityFormName());
      ledgerDto.setActivityTypeCode(detailVo.getActivityTypeCode());
      ledgerDto.setActivityTypeName(detailVo.getActivityTypeName());
      ledgerDto.setResaleCommercialCode(detailVo.getSystemCode());
      ledgerDto.setResaleCommercialName(detailVo.getSystemName());
      ledgerDto.setTerminalCode(detailVo.getTerminalCode());
      ledgerDto.setTerminalName(detailVo.getTerminalName());
      ledgerDto.setOperatorName(crmUserIdentity.getRealName());
      ledgerDto.setFeeDiffLedgerCode(diff.getFeeDiffLedgerCode());
      ledgerDto.setFeeDiffLedgerDisposeCode(diff.getPlanCode());
      ledgerDto.setOperatorAccount(crmUserIdentity.getAccount());
      // 回退调用同一个接口，金额参数传负数，将金额加上去
      ledgerDto.setRecoveredAmount(diff.getUsedAmount());
      ledgerDeductionDtoList.add(ledgerDto);
    }
    // 调用差异抵扣接口写入差异台账
    List<String> codeList = ledgerDeductionDtoList.stream().map(AuditFeeDiffLedgerDeductionDto::getFeeDiffLedgerCode).filter(Objects::nonNull).collect(Collectors.toList());
    boolean lock = auditFeeDiffLedgerLockService.lock(codeList, TimeUnit.MINUTES, 1);
    Validate.isTrue(lock,"操作差异费用加锁失败,请稍后再试");
    //解锁要放在controller
    String key = String.format(AuditFeeDiffTrackConstants.AUDIT_FEE_DIFF_TRACK_OPERATE, operateId);
    this.redisService.set(key,codeList);

    for (AuditFeeDiffLedgerDeductionDto ledgerDeductionDto : ledgerDeductionDtoList) {
      ledgerDeductionDto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.RETURN_AMOUNT.getCode());
      ledgerDeductionDto.setDataSource(DiffLedgerDataSourceEnum.DIFF_TRACK.getCode());
      auditFeeDiffLedgerVoService.useAmount(ledgerDeductionDto);
    }
    //auditFeeDiffLedgerLockService.unlock(codeList);
  }

  @Override
  public List<String> findTemplateCodeByPlanCode(String planCode) {
    if (StringUtils.isBlank(planCode)) return new ArrayList<>(0);
    LambdaQueryWrapper<AuditFeeDiffTrackDetail> query = new LambdaQueryWrapper<>();
    query.select(AuditFeeDiffTrackDetail::getTemplateConfigCode);
    query.eq(AuditFeeDiffTrackDetail::getPlanCode, planCode);
    query.eq(AuditFeeDiffTrackDetail::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
    query.groupBy(AuditFeeDiffTrackDetail::getTemplateConfigCode);
    List<AuditFeeDiffTrackDetail> list = auditFeeDiffTrackDetailRepository.list(query);
    List<String> templateCodeList = new ArrayList<>();
    if (CollectionUtils.isNotEmpty(list)) templateCodeList.addAll(list.stream().map(AuditFeeDiffTrackDetail::getTemplateConfigCode).filter(Objects::nonNull).collect(Collectors.toList()));
    return templateCodeList;
  }

  @Override
  public Page<AuditFeeDiffTrackDetailVo> auditFindByConditions(Pageable pageable, AuditFeeDiffTrackDetailDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
    dto = Optional.ofNullable(dto).orElse(new AuditFeeDiffTrackDetailDto());
    Page<AuditFeeDiffTrackDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    if (AuditFeeConstants.NATIONWIDE.equals(dto.getRegion())) {
        //全国就是所有
        dto.setRegion(null);
    }
    return this.auditFeeDiffTrackDetailRepository.auditFindByConditions(page, dto);
  }

  /**
   * 查询差异费用追踪详情差异费用台账
   *
   *  注意：待追回金额 和 已追回金额 取自差异费用台账
   *
   * @param detailCodes
   * @return
   */
  @Override
  public List<AuditFeeDiffTrackDetailLedgerVo> findLedgerByDetailCodes(List<String> detailCodes) {
    if(CollectionUtils.isEmpty(detailCodes)) return Lists.newArrayListWithCapacity(0);

    List<AuditFeeDiffTrackDetailLedger> list = this.auditFeeDiffTrackDetailLedgerRepository.findByDetailCodeList(detailCodes);

    if(CollectionUtils.isEmpty(list)) return Lists.newArrayListWithCapacity(0);
    return (List<AuditFeeDiffTrackDetailLedgerVo>)
            this.nebulaToolkitService.copyCollectionByWhiteList(list,
                                                                AuditFeeDiffTrackDetailLedger.class,
                                                                AuditFeeDiffTrackDetailLedgerVo.class,
                                                                HashSet.class,
                                                                ArrayList.class);
  }

  public List<AuditFeeDiffTrackDetailVo> findByDetailCodes(List<String> detailCodes){
    if(CollectionUtils.isEmpty(detailCodes)) return Lists.newArrayListWithCapacity(0);
    return auditFeeDiffTrackDetailRepository.findByDetailCodes(detailCodes);
  }

  @Override
  public void updateDetailPlanCowManagerState(List<String> successCodes, InterfacePushStateEnum cowManagerState) {
    if(CollectionUtils.isEmpty(successCodes) || cowManagerState == null) {
      return;
    }
    LambdaUpdateWrapper<AuditFeeDiffTrackDetail> updateWrapper = new UpdateWrapper<AuditFeeDiffTrackDetail>().lambda();
    updateWrapper.set(AuditFeeDiffTrackDetail::getCowManagerState, cowManagerState.getCode());
    updateWrapper.eq(AuditFeeDiffTrackDetail::getTenantCode, TenantUtils.getTenantCode());
    updateWrapper.eq(AuditFeeDiffTrackDetail::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
    updateWrapper.in(AuditFeeDiffTrackDetail::getDetailCode, successCodes);
    auditFeeDiffTrackDetailRepository.update(updateWrapper);
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void updateAlreadyAuditAmountByValidationPass(List<AuditFeeDiffTrackDetailDto> updateList) {
    if (CollectionUtils.isEmpty(updateList)) {
      return;
    }
    this.auditFeeDiffTrackDetailRepository.updateAlreadyAuditAmountByValidationPass(updateList);

  }

  @Override
  public List<String> findEndCastFormByDetailCodes(List<String> detailCodes) {
    if (CollectionUtils.isEmpty(detailCodes)) {
      return Lists.newArrayList();
    }
    List<String> list = this.auditFeeDiffTrackDetailRepository.findEndCastFormByDetailCodes(detailCodes);
    if (CollectionUtils.isEmpty(list)) {
      return Lists.newArrayList();
    }
    return list;
  }

  @Transactional(rollbackFor = Exception.class)
  @Override
  public void closeBatch(List<String> ids) {
    Assert.notEmpty(ids, "请勾选数据进行关闭");
    Collections.sort(ids);
    String redisLockKey = AuditFeeConstants.AUDIT_FEE_DIFF_TRACK_DETAIL_BATCH_CLOSE + String.join("", ids).hashCode();
    boolean hasLock = false;
    try {
      hasLock = redisLockService.tryLock(redisLockKey, TimeUnit.MINUTES, 3);
      if (!hasLock) {
        throw new RuntimeException("正在关闭差异追踪明细，请勿频繁操作");
      }

      List<AuditFeeDiffTrackDetail> entities = auditFeeDiffTrackDetailRepository.findByIds(ids);
      Assert.notEmpty(entities, "勾选数据不存在");

      AuditFeeDiffTrack diffTrack = auditFeeDiffTrackRepository.findByPlanCode(entities.get(0).getPlanCode());
      Assert.notNull(diffTrack, "明细对应的追踪数据不存在");
      Assert.isTrue(ProcessStatusEnum.PASS.getDictCode().equals(diffTrack.getProcessStatus()),
          "明细对应的追踪数据审批状态不是通过");

      List<String> wholeAuditDetailCodeList = entities.stream().filter(e -> BooleanEnum.TRUE.getCapital().equals(e.getWholeAudit())).map(AuditFeeDiffTrackDetail::getDetailCode).collect(Collectors.toList());
      Assert.isTrue(CollectionUtils.isEmpty(wholeAuditDetailCodeList), "追踪明细" +
          String.join(",", wholeAuditDetailCodeList) + "已完全结案，不允许关闭！");

      // 结案核销存在数据，状态必须为审批通过
      List<String> detailCodeList = entities.stream().map(AuditFeeDiffTrackDetail::getDetailCode).filter(Objects::nonNull).collect(Collectors.toList());
      List<String> notPassDetailCodeList = auditFeeValidationVoService.findProcessStatusNotPass(detailCodeList);
      Assert.isTrue(CollectionUtils.isEmpty(notPassDetailCodeList), "追踪明细" +
          String.join(",", notPassDetailCodeList) + "在结案核销中，不允许关闭！");

      List<String> closedCodeList = entities.stream()
          .filter(e -> BooleanEnum.TRUE.getCapital().equals(e.getIsClose()))
          .map(AuditFeeDiffTrackDetail::getDetailCode).collect(Collectors.toList());
      Assert.isTrue(CollectionUtils.isEmpty(closedCodeList),
          String.join(",", closedCodeList) + "数据已被关闭");

      // 差异台账数据
      List<AuditFeeDiffTrackDetailLedger> diffList = auditFeeDiffTrackDetailLedgerRepository.findByDetailCodeList(detailCodeList);
      Map<String, List<AuditFeeDiffTrackDetailLedger>> detailCodeDiffMap = diffList.stream()
          .collect(Collectors.groupingBy(AuditFeeDiffTrackDetailLedger::getDetailCode));

      List<AuditFeeDiffLedgerDeductionDto> returnList = new ArrayList<>();
      // 回退台账
      for (AuditFeeDiffTrackDetail entity : entities) {
        entity.setIsClose(BooleanEnum.TRUE.getCapital());
        BigDecimal alreadyAuditAmount = Optional.ofNullable(entity.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO);
        BigDecimal feeAmount = Optional.ofNullable(entity.getFeeAmount()).orElse(BigDecimal.ZERO);
        // 申请金额(我方承担金额)-已结案金额=待回退金额
        BigDecimal remain = feeAmount.subtract(alreadyAuditAmount);
        log.info("追踪明细:{},待回退金额:{}", entity.getDetailCode(), remain);

        List<AuditFeeDiffTrackDetailLedger> ledgers = detailCodeDiffMap.get(entity.getDetailCode());
        // 按时间排序，编码越大越近
        ledgers = ledgers.stream()
            .sorted(Comparator.comparing(AuditFeeDiffTrackDetailLedger::getFeeDiffLedgerCode, Comparator.reverseOrder()))
            .collect(Collectors.toList());
        for (AuditFeeDiffTrackDetailLedger ledger : ledgers) {
          if (remain.compareTo(BigDecimal.ZERO) <= 0) break;
          // 取小的作为操作金额
          BigDecimal recoveredAmount = remain.min(ledger.getUsedAmount());
          log.info("追踪明细:{},台账编码:{},操作金额:{}", entity.getDetailCode(), ledger.getFeeDiffLedgerCode(), recoveredAmount);
          remain = remain.subtract(ledger.getUsedAmount());

          AuditFeeDiffLedgerDeductionDto ledgerDto = new AuditFeeDiffLedgerDeductionDto();
          ledgerDto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.RETURN_AMOUNT.getCode());
          ledgerDto.setFeeDiffLedgerCode(ledger.getFeeDiffLedgerCode());
          ledgerDto.setFeeDiffLedgerDisposeCode(entity.getPlanCode());
          ledgerDto.setBusinessCode(entity.getDetailCode());
          ledgerDto.setRecoveredAmount(recoveredAmount);
          AbstractCrmUserIdentity loginUser = loginUserService.getAbstractLoginUser();
          ledgerDto.setOperatorAccount(loginUser.getAccount());
          ledgerDto.setOperatorName(loginUser.getRealName());
          ledgerDto.setRemark(entity.getRemark());
          ledgerDto.setResaleCommercialCode(entity.getSystemCode());
          ledgerDto.setResaleCommercialName(entity.getSystemName());
          ledgerDto.setTerminalCode(entity.getTerminalCode());
          ledgerDto.setTerminalName(entity.getTerminalName());
          ledgerDto.setActivityFormCode(entity.getActivityFormCode());
          ledgerDto.setActivityFormName(entity.getActivityFormName());
          ledgerDto.setActivityTypeCode(entity.getActivityTypeCode());
          ledgerDto.setActivityTypeName(entity.getActivityTypeName());
          ledgerDto.setDataSource(DiffLedgerDataSourceEnum.DIFF_TRACK.getCode());
          returnList.add(ledgerDto);
        }
      }
      List<String> feeDiffLedgerCodeList = returnList.stream()
          .map(AuditFeeDiffLedgerDeductionDto::getFeeDiffLedgerCode).collect(Collectors.toList());
      Assert.isTrue(auditFeeDiffLedgerLockService.lock(feeDiffLedgerCodeList, TimeUnit.MINUTES, 1),
          "关闭时回退差异费用台账失败，请重试");
      for (AuditFeeDiffLedgerDeductionDto dto : returnList) {
        auditFeeDiffLedgerVoService.useAmount(dto);
      }
      auditFeeDiffLedgerLockService.unlock(feeDiffLedgerCodeList);
      // 更新追踪明细数据为已关闭
      auditFeeDiffTrackDetailRepository.updateBatchById(entities);

      // 推送牛人管家
      List<AuditFeeDiffTrackDetailVo> detailPlanItemVoList = (List<AuditFeeDiffTrackDetailVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
          entities,
          AuditFeeDiffTrackDetail.class,
          AuditFeeDiffTrackDetailVo.class,
          HashSet.class,
          ArrayList.class);
      diffTrackPushCowManager.closeItemPush(detailPlanItemVoList);

    } catch (Exception e) {
      log.info("差异追踪明细批量关闭出现异常：{}", e.getMessage());
      throw e;
    } finally {
      if (hasLock) {
        log.info("差异追踪明细批量关闭已解锁");
        redisLockService.unlock(redisLockKey);
      }
    }
  }
}
