package com.biz.crm.tpm.business.audit.fee.local.service.observer;

import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.event.dispose.AuditFeeDiffDisposeEventListener;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeVoService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @describe: 差异费用处理审批回调
 * @author: xiaoyoujun
 * @date: 2022.11.30
 */
@Slf4j
@Component
public class AuditFeeDiffDisposeCallbackServiceImpl implements ProcessCompleteListener {

    @Autowired
    private AuditFeeDiffDisposeVoService auditFeeDiffDisposeVoService;

    @Autowired(required = false)
    private List<AuditFeeDiffDisposeEventListener> eventListeners;

    @Override
    public String getBusinessCode() {
        return AuditFeeConstants.AUDIT_FEE_DIFF_DISPOSE_PROCESS_CODE;
    }

    @Override
    public void onProcessComplete(ProcessStatusDto dto) {
        Validate.notEmpty(dto.getProcessNo(), "流程编码不能为空！");

        String processStatus = dto.getProcessStatus();
        //审批状态变更时触发监听事件
        if (CollectionUtils.isNotEmpty(eventListeners)){
            eventListeners.forEach(eventListeners->{
                eventListeners.onUpdateProcessStatus(processStatus,dto.getProcessNo());
            });
        }
    }
}
