package com.biz.crm.tpm.business.audit.fee.local.service.perdiction;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.prediction.AuditFeePredictionVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import org.springframework.data.domain.Pageable;

import java.util.List;

public interface AuditFeePredictionService {

    /**
     * 垂直批量创建(活动细案)
     * @param dtos
     */
    void createBatch(List<AuditFeePredictionDto> dtos);

    /**
     * 根据ids更新数据
     * @param ids
     */
    void autoUpdateByIds(List<String> ids);

    /**
     * 根据ids删除数据
     * @param ids
     */
    void deleteByIds(List<String> ids);

    /**
     * 自动更新数据
     */
    void autoJobUpdate();

    /**
     * 根据活动细案编码集合查询
     * @param activityDetailPlanItemCodes
     * @return
     */
    List<AuditFeePredictionVo> findByActivityDetailPlanItemCodes(List<String> activityDetailPlanItemCodes);

    /**
     * 分页查询
     * @param pageable
     * @param dto
     * @return
     */
    Page<AuditFeePredictionVo> findByConditions(Pageable pageable, AuditFeePredictionDto dto);

    /**
     * 同步数据
     */
    void autoJobAsync(AuditFeePredictionDto dto, UserIdentity userIdentity);

    /**
     * 自动同步数据
     */
    void autoJobSync(AuditFeePredictionDto dto);




}
