package com.biz.crm.tpm.business.audit.fee.local.service.perdiction.internal;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.audit.fee.local.entity.prediction.AuditFeePrediction;
import com.biz.crm.tpm.business.audit.fee.local.entity.prediction.AuditFeePredictionFormula;
import com.biz.crm.tpm.business.audit.fee.local.repository.prediction.AuditFeePredictionFormulaRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.prediction.AuditFeePredictionRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.perdiction.AuditFeePredictionService;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.service.TpmDeductionMatchingTemplateService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateRulesVo;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.prediction.AuditFeePredictionVo;
import com.biz.crm.tpm.business.audit.sdk.enumeration.DataSourceEnum;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.TpmDeductionDetailMappingDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.service.TpmDeductionDetailMappingService;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.concurrent.TimeUnit;

import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author: zhouyang
 * @Date: 2023/9/23
 */
@Slf4j
@Service
public class AuditFeePredictionServiceImpl implements AuditFeePredictionService {

    @Autowired
    private VariableService variableService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private DetailedForecastService detailedForecastService;
    @Autowired
    private AuditFeePredictionRepository auditFeePredictionRepository;
    @Autowired
    private TpmDeductionDetailMappingService tpmDeductionDetailMappingService;
    @Autowired
    private TpmDeductionMatchingTemplateService tpmDeductionMatchingTemplateService;
    @Autowired
    private AuditFeePredictionFormulaRepository auditFeePredictionFormulaRepository;
    @Autowired(required = false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required = false)
    private ActivityFormService activityFormService;
    @Autowired(required = false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;
    @Autowired(required = false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    @Autowired
    private TerminalVoService terminalVoService;
    @Autowired
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private RedisLockService redisLockService;

    /**
     * 垂直批量创建
     *
     * @param dtos
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void createBatch(List<AuditFeePredictionDto> dtos) {
        log.info("批量创建扣费预测入参：{}", JSONObject.toJSONString(dtos));
        this.validateCreate(dtos);
        List<AuditFeePrediction> entityList = (List<AuditFeePrediction>) this.nebulaToolkitService.copyCollectionByWhiteList(dtos, AuditFeePredictionDto.class, AuditFeePrediction.class, HashSet.class, ArrayList.class);
        this.auditFeePredictionRepository.saveBatch(entityList);

        /**
         * 1.根据活动形式，到商超扣费映射取“映射”-理论上只能找到唯一
         * 2.再根据 映射+业态+业务单元 到扣费模板配置查询计算公式
         */
        String tenantCode = TenantUtils.getTenantCode();
        List<AuditFeePredictionFormula> predictionFormulaList = Lists.newArrayList();
        List<AuditFeePrediction> updateEntityList = Lists.newArrayList();
        entityList.forEach(entity -> {
            // 1.
            //List<String> activityFormCodes = dtos.stream().map(AuditFeePredictionDto::getActivityFormCode).collect(Collectors.toList());
            TpmDeductionDetailMappingDto mappingDto = new TpmDeductionDetailMappingDto();
            mappingDto.setBusinessFormatCode(entity.getBusinessFormatCode());
            mappingDto.setBusinessUnitCode(entity.getBusinessUnitCode());
            mappingDto.setSalesInstitutionErpCode(entity.getSalesInstitutionCode());
            mappingDto.setResaleCommercialCode(entity.getSystemCode());
            mappingDto.setFirstChannelCode(entity.getFirstChannelCode());
            mappingDto.setSecondChannelCode(entity.getSecondChannelCode());
            if (StringUtils.isNotEmpty(entity.getCustomerCode())) {
                List<String> customerCodes = Lists.newArrayList();
                customerCodes.add(entity.getCustomerCode());
                mappingDto.setCustomerCodeList(customerCodes);
            }
            mappingDto.setBuyWay(entity.getBuyWay());
            mappingDto.setActivityFormCode(entity.getActivityFormCode());
            mappingDto.setTenantCode(tenantCode);
            List<TpmDeductionDetailMappingVo> mappingVos = tpmDeductionDetailMappingService.findByDto(mappingDto);
            log.info("批量创建扣费预测映射：{}", JSONObject.toJSONString(mappingVos));
            if (!CollectionUtils.isEmpty(mappingVos)) {
                if (mappingVos.size() == 1) {
                    //Map<String,TpmDeductionDetailMappingVo> mappingVoMap = mappingVos.stream().collect(Collectors.toMap(TpmDeductionDetailMappingVo::getCode, Function.identity()));
                    // 2.
                    TpmDeductionMatchingTemplateDto templateDto = new TpmDeductionMatchingTemplateDto();
                    templateDto.setBusinessFormatCode(entity.getBusinessFormatCode());
                    templateDto.setBusinessUnitCode(entity.getBusinessUnitCode());
                    templateDto.setApplyMappingCode(mappingVos.get(0).getCode());
                    templateDto.setTenantCode(tenantCode);
                    List<TpmDeductionMatchingTemplateVo> templateVoList = tpmDeductionMatchingTemplateService.findByDto(templateDto);
                    log.info("批量创建扣费预测模板：{}", JSONObject.toJSONString(templateVoList));
                    if (!CollectionUtils.isEmpty(templateVoList)) {
                        if (templateVoList.size() == 1) {
                            TpmDeductionMatchingTemplateVo templateVo = templateVoList.get(0);
                            entity.setMatchTemplateCode(templateVo.getCode());
                            List<TpmDeductionMatchingTemplateRulesVo> templateRulesVoList = templateVo.getRulesList();
                            if (!CollectionUtils.isEmpty(templateRulesVoList)) {
                                templateRulesVoList.forEach(rule -> {
                                    // 公式信息
                                    AuditFeePredictionFormula predictionFormula = this.nebulaToolkitService.copyObjectByWhiteList(rule, AuditFeePredictionFormula.class, HashSet.class, ArrayList.class);
                                    predictionFormula.setId(null);
                                    predictionFormula.setDetailPlanItemCode(entity.getDetailPlanItemCode());
                                    predictionFormulaList.add(predictionFormula);
                                });
                                try {
                                    this.templateRuleComputation(entity, templateRulesVoList);
                                    updateEntityList.add(entity);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                    log.info("批量创建扣费预测模板,公式计算异常：{}", e.getMessage());
                                }
                            }
                        }
                    }
                }
            }
        });
        if (!CollectionUtils.isEmpty(updateEntityList)) {
            this.auditFeePredictionRepository.updateBatchById(updateEntityList);
        }
        if (!CollectionUtils.isEmpty(predictionFormulaList)) {
            this.auditFeePredictionFormulaRepository.saveBatch(predictionFormulaList);
        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void autoUpdateByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<AuditFeePrediction> list = this.auditFeePredictionRepository.listByIds(ids);
        Validate.notEmpty(list, "未找到扣费预测信息");
        this.syncUpdateData(list);
        this.auditFeePredictionRepository.updateBatchById(list);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.auditFeePredictionRepository.removeByIds(ids);
    }

    /**
     * 自动同步数据
     *
     * @param list
     */
    private void syncUpdateData(List<AuditFeePrediction> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        // 查询细案预测
        Set<String> activityDetailItemCodes = list.stream().map(AuditFeePrediction::getDetailPlanItemCode).collect(Collectors.toSet());
        List<DetailedForecastVo> detailedForecastVoList = this.detailedForecastService.findByActivityDetailItemCode(activityDetailItemCodes);
        log.info("细案信息：{}", JSONObject.toJSONString(detailedForecastVoList));
        Map<String, DetailedForecastVo> detailedForecastVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(detailedForecastVoList)) {
            detailedForecastVoMap.putAll(detailedForecastVoList.stream().collect(Collectors.toMap(DetailedForecastVo::getActivityDetailItemCode, Function.identity(), ((a, b) -> a))));
        }
        // 查询模板信息
        List<String> matchTemplateCodes = list.stream().map(AuditFeePrediction::getMatchTemplateCode).collect(Collectors.toList());
        List<TpmDeductionMatchingTemplateVo> templateVoList = this.tpmDeductionMatchingTemplateService.findByCodes(matchTemplateCodes);
        log.info("模板信息：{}", JSONObject.toJSONString(templateVoList));
        Map<String, TpmDeductionMatchingTemplateVo> templateVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(templateVoList)) {
            templateVoMap.putAll(templateVoList.stream().collect(Collectors.toMap(TpmDeductionMatchingTemplateVo::getCode, Function.identity(), ((a, b) -> a))));
        }
        List<AuditFeePredictionFormula> totalFormulaList = Lists.newArrayList();
        List<String> needUpdateFormula = Lists.newArrayList();
        list.forEach(entity -> {
            if (templateVoMap.containsKey(entity.getMatchTemplateCode())) {
                TpmDeductionMatchingTemplateVo templateVo = templateVoMap.get(entity.getMatchTemplateCode());
                List<TpmDeductionMatchingTemplateRulesVo> templateRulesVoList = templateVo.getRulesList();
                if (!CollectionUtils.isEmpty(templateRulesVoList)) {
                    List<AuditFeePredictionFormula> formulaList = this.templateRuleComputation(entity, templateRulesVoList);
                    totalFormulaList.addAll(formulaList);
                    needUpdateFormula.add(entity.getDetailPlanItemCode());
                }
            }
            if (detailedForecastVoMap.containsKey(entity.getDetailPlanItemCode())) {
                DetailedForecastVo detailedForecastVo = detailedForecastVoMap.get(entity.getDetailPlanItemCode());
                entity.setPredictionAccountsAmount(detailedForecastVo.getEstimatedWriteOffAmount());
            }
        });
        // 删除旧的公式信息
        if (!CollectionUtils.isEmpty(needUpdateFormula)) {
            this.auditFeePredictionFormulaRepository.removeByDetailItemCodes(needUpdateFormula);
        }
        if (!CollectionUtils.isEmpty(totalFormulaList)) {
            this.auditFeePredictionFormulaRepository.saveBatch(totalFormulaList);
        }
    }

    /**
     * 定时任务
     */
    @Override
    public void autoJobUpdate() {
        List<AuditFeePrediction> list = this.auditFeePredictionRepository.findAll(BooleanEnum.TRUE.getCapital());
        if (!CollectionUtils.isEmpty(list)) {
            this.syncUpdateData(list);
            this.auditFeePredictionRepository.updateBatchById(list);
        }
    }

    /**
     * 根据活动细案编码集合查询
     *
     * @param activityDetailPlanItemCodes
     * @return
     */
    @Override
    public List<AuditFeePredictionVo> findByActivityDetailPlanItemCodes(List<String> activityDetailPlanItemCodes) {
        if (CollectionUtils.isEmpty(activityDetailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeePrediction> list = this.auditFeePredictionRepository.findByActivityDetailPlanItemCodes(activityDetailPlanItemCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List<AuditFeePredictionVo>) this.nebulaToolkitService.copyCollectionByWhiteList(list, AuditFeePrediction.class, AuditFeePredictionVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    public Page<AuditFeePredictionVo> findByConditions(Pageable pageable, AuditFeePredictionDto dto) {
        return this.auditFeePredictionRepository.findByConditions(pageable, dto);
    }

    @Async
    @Override
    public void autoJobAsync(AuditFeePredictionDto dto, UserIdentity userIdentity) {
        loginUserService.refreshAuthentication(userIdentity);
        this.autoJobSync(dto);
    }

    /**
     * 自动同步数据
     * 对比扣费预测表与活动细案表数据（垂直/分子，审批通过的活动细案）
     * 过去7天的数据
     * 初始化时候，会在此插入大批量数据。后续运行这里的检查量大，插入量少
     */
    @Override
    public void autoJobSync(AuditFeePredictionDto dto) {
        boolean hasLock = false;
        String redisLockKey = AuditFeeConstants.AUDIT_FEE_PREDICTION_GENERATE_LOCK;
        try {
            hasLock = redisLockService.tryLock(redisLockKey, TimeUnit.MINUTES, 5);
            if (!hasLock) {
                throw new RuntimeException("正在同步扣费预测数据");
            }
            log.info("扣费预测-自动同步数据-开始");
            Date now = new Date();
            Date beforeWeek = this.getDate(now, -7);
            // 额外条件：活动形式上的“是否参与商超扣费核对”=“是”，且核销方式=事后。均放在sql中实现

            // 垂直
            ActivityDetailPlanDto detailPlanDto = new ActivityDetailPlanDto();
            if (dto.getActivityBeginDate() != null) {
                detailPlanDto.setActivityBeginDate(DateUtil.beginOfDay(dto.getActivityBeginDate()));
            } else {
                detailPlanDto.setActivityBeginDate(beforeWeek);
            }
            if (dto.getActivityEndDate() != null) {
                detailPlanDto.setActivityEndDate(DateUtil.endOfDay(dto.getActivityEndDate()));
            } else {
                detailPlanDto.setActivityEndDate(now);
            }
            detailPlanDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            Page<String> detailPlanItemCodePage = null;
            List<String> detailPlanItemCodes = null;
            Pageable pageable = PageRequest.of(0, 2000);
            do {
                pageable = pageable.next();
                // 为了避免无效数据占用内存，先查询编码，筛选出需要的 再查询对象

                detailPlanItemCodePage = activityDetailPlanSdkService.findByDtoForPrediction(pageable, detailPlanDto);
                if (detailPlanItemCodePage == null || CollectionUtils.isEmpty(detailPlanItemCodePage.getRecords())) break;

                detailPlanItemCodes = detailPlanItemCodePage.getRecords();
                log.info("页码：{}，垂直活动细案信息：{}", pageable.getPageNumber(), JSONObject.toJSONString(detailPlanItemCodes));
                List<String> existItemCodes = auditFeePredictionRepository.findExistItemCode(detailPlanItemCodes);
                List<String> notExistItemCodes = detailPlanItemCodes.stream().filter(e -> !existItemCodes.contains(e)).filter(Objects::nonNull).distinct().collect(Collectors.toList());

                if (!CollectionUtils.isEmpty(notExistItemCodes)) {
                    // 查询对象
                    List<ActivityDetailPlanItemVo> itemVos = activityDetailPlanItemSdkService.findDetailAndExtendByItemCodes(notExistItemCodes);
                    // 转化
                    // 保存
                    List<AuditFeePredictionDto> dtos = this.verticalDetailPlanConvertToPrediction(itemVos);
                    auditFeePredictionFormulaRepository.removeByDetailItemCodes(dtos.stream().map(AuditFeePredictionDto::getDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toList()));
                    this.createBatch(dtos);
                    notExistItemCodes.clear();
                }
                detailPlanItemCodes.clear();
            } while (detailPlanItemCodePage.hasNext());

            // 分子
            SubComActivityDetailPlanDto subComDetailPlanDto = new SubComActivityDetailPlanDto();
            if (dto.getActivityBeginDate() != null) {
                subComDetailPlanDto.setActivityBeginTime(DateUtil.beginOfDay(dto.getActivityBeginDate()));
            } else {
                subComDetailPlanDto.setActivityBeginTime(beforeWeek);
            }
            if (dto.getActivityEndDate() != null) {
                subComDetailPlanDto.setActivityEndTime(DateUtil.endOfDay(dto.getActivityEndDate()));
            } else {
                subComDetailPlanDto.setActivityEndTime(now);
            }
            subComDetailPlanDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
            Page<String> subDetailPlanItemCodePage = null;
            List<String> subDetailPlanItemCodes = null;
            Pageable subPageable = PageRequest.of(0, 2000);
            do {
                subPageable = subPageable.next();
                // 为了避免无效数据占用内存，先查询编码，筛选出需要的 再查询对象

                subDetailPlanItemCodePage = subComActivityDetailPlanVoService.findByDtoForPrediction(subPageable, subComDetailPlanDto);
                if (subDetailPlanItemCodePage == null || CollectionUtils.isEmpty(subDetailPlanItemCodePage.getRecords())) break;

                subDetailPlanItemCodes = subDetailPlanItemCodePage.getRecords();
                log.info("页码：{}，分子活动细案信息：{}", subPageable.getPageNumber(), JSONObject.toJSONString(subDetailPlanItemCodes));
                List<String> existItemCodes = auditFeePredictionRepository.findExistItemCode(subDetailPlanItemCodes);
                List<String> notExistItemCodes = subDetailPlanItemCodes.stream().filter(e -> !existItemCodes.contains(e)).filter(Objects::nonNull).distinct().collect(Collectors.toList());

                if (!CollectionUtils.isEmpty(notExistItemCodes)) {
                    // 查询对象
                    List<SubComActivityDetailPlanItemVo> subItemVos = subComActivityDetailPlanItemVoService.findItemsByPlanItemCodes(notExistItemCodes);
                    // 转化
                    // 保存
                    List<AuditFeePredictionDto> dtos = this.subDetailPlanConvertToPrediction(subItemVos);
                    auditFeePredictionFormulaRepository.removeByDetailItemCodes(dtos.stream().map(AuditFeePredictionDto::getDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toList()));
                    this.createBatch(dtos);
                    notExistItemCodes.clear();
                }
                subDetailPlanItemCodes.clear();
            } while (subDetailPlanItemCodePage.hasNext());
            log.info("扣费预测-自动同步数据-结束");
        } catch (Exception e) {
            log.info("扣费预测-自动同步数据-错误:{}", e.getMessage());
            e.printStackTrace();
        } finally {
            if (hasLock) {
                log.info("同步扣费预测数据已解锁");
                redisLockService.unlock(redisLockKey);
            }
        }
    }

    /**
     * 往前的日期
     *
     * @param date
     * @param day
     * @return
     */
    private Date getDate(Date date, int day) {
        if (Objects.isNull(date)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_MONTH, day);
        return calendar.getTime();
    }

    /**
     * 垂直活动数据转换为扣费预测
     * @param itemList
     * @return
     */
    private List<AuditFeePredictionDto> verticalDetailPlanConvertToPrediction(List<ActivityDetailPlanItemVo> itemList) {
        List<AuditFeePredictionDto> predictionDtoList = Lists.newArrayList();

        if (CollectionUtils.isEmpty(itemList)) {
            return predictionDtoList;
        }
        Set<String> terminalCodes = new HashSet<>();
        Set<String> salesInstitutionCodes = new HashSet<>();
        for (ActivityDetailPlanItemVo itemVo : itemList) {
            if (itemVo.getTerminalCode() != null) terminalCodes.add(itemVo.getTerminalCode());
            if (itemVo.getSalesInstitutionErpCode() != null) salesInstitutionCodes.add(itemVo.getSalesInstitutionErpCode());
        }
        
        // 门店信息
        List<TerminalVo> terminalVos = terminalVoService.findByTerminalCodes(Lists.newArrayList(terminalCodes));
        Map<String, TerminalVo> terminalVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(terminalVos)) {
            terminalVoMap.putAll(terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity())));
        }

        // 销售机构信息
        List<SalesOrgVo> salesOrgVoList = salesOrgVoService.findBySalesOrgCodesPost(Lists.newArrayList(salesInstitutionCodes));
        Map<String, SalesOrgVo> salesOrgVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(salesOrgVoList)){
            // 这里短码查询/使用
            salesOrgVoMap.putAll(salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getErpCode, Function.identity(), (v1, v2) -> v2)));
        }

        itemList.forEach(item -> {
            AuditFeePredictionDto dto = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditFeePredictionDto.class, HashSet.class, ArrayList.class);
            dto.setId(null);
            dto.setCreateTime(null);
            dto.setModifyTime(null);
            dto.setCreateAccount(null);
            dto.setCreateName(null);
            dto.setModifyAccount(null);
            dto.setModifyName(null);
            if (terminalVoMap.containsKey(item.getTerminalCode())) {
                dto.setProvinceCode(terminalVoMap.get(item.getTerminalCode()).getProvinceCode());
                dto.setProvinceName(terminalVoMap.get(item.getTerminalCode()).getProvinceName());
            }
            dto.setActivityFormDesc(item.getRemark());
            dto.setCustomerErpCode(item.getCustomerErpCode());
            dto.setCustomerCode(item.getCustomerCode());
            dto.setApplyAmount(item.getFeeAmount());
            if (item.getSalesInstitutionErpCode() == null && item.getSalesInstitutionCode() != null) {
                dto.setSalesInstitutionCode(item.getSalesInstitutionCode().substring(4));
                dto.setSalesInstitutionName(item.getSalesInstitutionName());
            } else {
                dto.setSalesInstitutionCode(item.getSalesInstitutionErpCode());
                SalesOrgVo salesOrgVo = salesOrgVoMap.get(item.getSalesInstitutionErpCode());
                if (salesOrgVo != null) {
                    dto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
                }
            }
            dto.setActivityYearMonth(item.getActivityBeginDate());
            dto.setDataSource(DataSourceEnum.ACTIVITY_DETAIL.getCode());
            predictionDtoList.add(dto);
        });
        return predictionDtoList;
    }

    /**
     * 分子活动数据转换为扣费预测
     * @param itemList
     * @return
     */
    private List<AuditFeePredictionDto> subDetailPlanConvertToPrediction(List<SubComActivityDetailPlanItemVo> itemList) {
        List<AuditFeePredictionDto> predictionDtoList = Lists.newArrayList();

        if (CollectionUtils.isEmpty(itemList)) {
            return predictionDtoList;
        }

        List<String> salesInstitutionCodes = new ArrayList<>();
        for (SubComActivityDetailPlanItemVo itemVo : itemList) {
            if (itemVo.getSalesInstitutionCode() != null) salesInstitutionCodes.add(itemVo.getSalesInstitutionCode());
        }
        // 销售机构信息
        List<SalesOrgVo> salesOrgVoList = salesOrgVoService.findBySalesOrgCodesPost(Lists.newArrayList(salesInstitutionCodes));
        Map<String, SalesOrgVo> salesOrgVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(salesOrgVoList)){
            // 这里长码查询/使用
            salesOrgVoMap.putAll(salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(), (v1, v2) -> v2)));
        }

        itemList.forEach(item -> {
            AuditFeePredictionDto dto = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditFeePredictionDto.class, HashSet.class, ArrayList.class);
            dto.setId(null);
            dto.setCreateTime(null);
            dto.setModifyTime(null);
            dto.setCreateAccount(null);
            dto.setCreateName(null);
            dto.setModifyAccount(null);
            dto.setModifyName(null);
            dto.setDataSource(DataSourceEnum.SON_ACTIVITY_DETAIL.getCode());
            dto.setActivityYearMonth(item.getFeeYearMonth());
            dto.setSystemCode(item.getResaleCommercialCode());
            dto.setSystemName(item.getResaleCommercialName());
            dto.setActivityBeginDate(item.getActivityBeginTime());
            dto.setActivityEndDate(item.getActivityEndTime());
            dto.setOrderBeginDate(item.getOrderStartDate());
            dto.setDetailPlanItemCode(item.getConstituentDetailPlanItemCode());
            dto.setDetailPlanCode(item.getConstituentDetailPlanCode());
            dto.setDetailPlanName(item.getConstituentDetailPlanName());
            dto.setApplyAmount(item.getTotalCost());
            dto.setCustomerCode(item.getCustomerCode());
            SalesOrgVo salesOrgVo = salesOrgVoMap.get(item.getSalesInstitutionErpCode());
            if (salesOrgVo != null) {
                dto.setSalesInstitutionCode(salesOrgVo.getErpCode());
                dto.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
            }
            predictionDtoList.add(dto);
        });
        return predictionDtoList;
    }

    /**
     * 模板计算
     *
     * @param entity
     * @param templateRulesVoList
     */
    private List<AuditFeePredictionFormula> templateRuleComputation(AuditFeePrediction entity, List<TpmDeductionMatchingTemplateRulesVo> templateRulesVoList) {
        List<AuditFeePredictionFormula> feePredictionFormulaList = Lists.newArrayList();
        List<CalculateVo> calculateVoList = this.variableInfo(entity, templateRulesVoList, feePredictionFormulaList);
        log.info("扣费预测计算公式返回：{}", calculateVoList);
        Validate.notEmpty(calculateVoList, "公式计算错误");
        if (!CollectionUtils.isEmpty(calculateVoList)) {
            AtomicReference<BigDecimal> totalPredictionAuditAmount = new AtomicReference<>(BigDecimal.ZERO);
            calculateVoList.forEach(dto -> {
                totalPredictionAuditAmount.getAndSet(dto.getFormulaValue());
            });
            entity.setPredictionAuditAmount(totalPredictionAuditAmount.get());
            entity.setCanAuditAmount(totalPredictionAuditAmount.get().subtract(Optional.ofNullable(entity.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO)));
        }
        return feePredictionFormulaList;
    }

    private List<CalculateVo> variableInfo(AuditFeePrediction entity, List<TpmDeductionMatchingTemplateRulesVo> templateRulesVoList, List<AuditFeePredictionFormula> feePredictionFormulaList) {
        // 组装计算参数
        List<CalculateDto> calculateDtoList = Lists.newArrayList();
        CalculateDto calculateDto = new CalculateDto();
        calculateDto.setCode(entity.getDetailPlanItemCode());
        calculateDto.setName(entity.getDetailPlanName());
        calculateDto.setBusinessFormatCode(entity.getBusinessFormatCode());
        calculateDto.setBusinessUnitCode(entity.getBusinessUnitCode());
        calculateDto.setDeliveryPartyCode(entity.getTerminalCode());
        calculateDto.setProductCode(entity.getProductCode());
        calculateDto.setActivityTypeCode(entity.getActivityTypeCode());
        calculateDto.setActivityFormCode(entity.getActivityFormCode());
        calculateDto.setStartTimeOrDate(entity.getActivityBeginDate());
        if (StringUtils.equals(YesOrNoEnum.YES.getCode(), entity.getIsClose())) {
            calculateDto.setEndTimeOrDate(entity.getCloseDate());
        } else {
            calculateDto.setEndTimeOrDate(entity.getActivityEndDate());
        }
        calculateDto.setActivityDetailItemCode(entity.getDetailPlanItemCode());
        List<String> productCodes = Lists.newArrayList();
        productCodes.add(entity.getProductCode());
        calculateDto.setProductList(productCodes);
        List<String> terminalCodes = Lists.newArrayList();
        terminalCodes.add(entity.getTerminalCode());
        calculateDto.setStoreList(terminalCodes);
        List<FormulaInfoDto> formulaInfoDtoList = new ArrayList<>();
        templateRulesVoList.forEach(rule -> {
            FormulaInfoDto formulaInfoDto = new FormulaInfoDto();
            formulaInfoDto.setFormula(rule.getFormulaCode());
            formulaInfoDto.setFormulaCode(rule.getFormulaCode());
            formulaInfoDto.setFormulaName(rule.getFormulaName());
            formulaInfoDtoList.add(formulaInfoDto);
            // 公式信息
            AuditFeePredictionFormula predictionFormula = this.nebulaToolkitService.copyObjectByWhiteList(rule, AuditFeePredictionFormula.class, HashSet.class, ArrayList.class);
            predictionFormula.setId(null);
            predictionFormula.setDetailPlanItemCode(entity.getDetailPlanItemCode());
            feePredictionFormulaList.add(predictionFormula);
            this.buildDto(calculateDto, rule.getFormulaCode(), entity);
        });
        calculateDto.setFormulaInfoDtoList(formulaInfoDtoList);
        calculateDtoList.add(calculateDto);
        log.info("扣费预测计算公式输入：{}", JSONObject.toJSONString(calculateDtoList));
        return variableService.orCalculateConditionAndExpression(calculateDtoList);
    }

    private void buildDto(CalculateDto dto, String formulaCode, AuditFeePrediction entity) {
        if (formulaCode == null) return;
        if (formulaCode.contains("AUDITFEEP0001")) {
            dto.setActivityDetailItemCode(entity.getDetailPlanItemCode());
            dto.setActivityDetailItemCodeList(com.google.common.collect.Lists.newArrayList(entity.getDetailPlanItemCode()));
        }
        if (formulaCode.contains("AUDITFEEP0002") || formulaCode.contains("AUDITFEEP0003") || formulaCode.contains("AUDITFEEP0004") || formulaCode.contains("AUDITFEEP0005")) {
            dto.setProductList(com.google.common.collect.Lists.newArrayList(entity.getProductCode()));
            dto.setStoreList(com.google.common.collect.Lists.newArrayList(entity.getTerminalCode()));
            dto.setStartTimeOrDate(entity.getActivityBeginDate());
            if (StringUtils.equals(YesOrNoEnum.YES.getCode(), entity.getIsClose())) {
                dto.setEndTimeOrDate(entity.getCloseDate());
            } else {
                dto.setEndTimeOrDate(entity.getActivityEndDate());
            }
        }
        if (formulaCode.contains("AUDITFEEP0006") || formulaCode.contains("AUDITFEEP0007")) {
            dto.setProductCode(entity.getProductCode());
            dto.setDeliveryPartyCode(entity.getTerminalCode());
            dto.setStartTimeOrDate(entity.getActivityBeginDate());
            if (StringUtils.equals(YesOrNoEnum.YES.getCode(), entity.getIsClose())) {
                dto.setEndTimeOrDate(entity.getCloseDate());
            } else {
                dto.setEndTimeOrDate(entity.getActivityEndDate());
            }
        }
        if (formulaCode.contains("AUDITFEEP0008") || formulaCode.contains("AUDITFEEP0009")) {
            dto.setStoreList(Lists.newArrayList(entity.getTerminalCode()));
            dto.setProductList(Lists.newArrayList(entity.getProductCode()));
            dto.setStartTimeOrDate(entity.getActivityBeginDate());
            if (StringUtils.equals(YesOrNoEnum.YES.getCode(), entity.getIsClose())) {
                dto.setEndTimeOrDate(entity.getCloseDate());
            } else {
                dto.setEndTimeOrDate(entity.getActivityEndDate());
            }
        }
        if (formulaCode.contains("AUDITFEEP00010") || formulaCode.contains("AUDITFEEP0011")) {
            dto.setStoreList(Lists.newArrayList(entity.getTerminalCode()));
            dto.setStartTimeOrDate(entity.getActivityBeginDate());
            if (StringUtils.equals(YesOrNoEnum.YES.getCode(), entity.getIsClose())) {
                dto.setEndTimeOrDate(entity.getCloseDate());
            } else {
                dto.setEndTimeOrDate(entity.getActivityEndDate());
            }
        }
        if (formulaCode.contains("AUDITFEEP0012")) {
            dto.setProductCode(entity.getProductCode());
            dto.setExcludeProductCodeList(Lists.newArrayList(entity.getProductCode()));
        }
        if (formulaCode.contains("AUDITFEEP0013") || formulaCode.contains("AUDITFEEP0014")) {
            dto.setDataSource(entity.getDataSource());
        }
        if (formulaCode.contains("AUDITFEEP0015")) {

        }
        if (formulaCode.contains("AUDITFEEP0016")) {
            dto.setActivityDetailItemCode(entity.getDetailPlanItemCode());
        }
        if (formulaCode.contains("AUDITFEEP0017")) {
            dto.setBusinessFormatCode(entity.getBusinessFormatCode());
            dto.setBusinessUnitCode(entity.getBusinessUnitCode());
            dto.setRetailBusinessmanCode(entity.getSystemCode());
            dto.setDeliveryPartyCode(entity.getTerminalCode());
            dto.setProductCode(entity.getProductCode());
            dto.setYearMonthLy(DateUtil.format(entity.getActivityYearMonth(), "yyyy-MM"));
        }
    }



    /**
     * 创建验证
     *
     * @param dtos
     */
    private void validateCreate(List<AuditFeePredictionDto> dtos) {
        Validate.notEmpty(dtos, "创建时，对象不能为空");
        dtos.forEach(dto -> {
            Validate.notEmpty(dto.getDetailPlanCode(), "细案编码不能为空");
            Validate.notEmpty(dto.getBusinessFormatCode(), "业态不能为空");
            Validate.notEmpty(dto.getBusinessFormatCode(), "业务单元不能为空");
            Validate.notEmpty(dto.getActivityFormCode(), "活动形式不能为空");
            Validate.notNull(dto.getActivityBeginDate(), "活动开始时间不能为空");
            Validate.notNull(dto.getActivityEndDate(), "活动结束时间不能为空");
        });
    }
}
