package com.biz.crm.tpm.business.audit.fee.local.service.perdiction.internal;

import com.biz.crm.tpm.business.audit.fee.local.entity.prediction.AuditFeePrediction;
import com.biz.crm.tpm.business.audit.fee.local.repository.prediction.AuditFeePredictionRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.prediction.AuditFeePredictionVoService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author: zhouyang
 * @Date: 2023/9/23
 */
@Service
public class AuditFeePredictionVoServiceImpl implements AuditFeePredictionVoService{

    @Autowired
    private AuditFeePredictionRepository auditFeePredictionRepository;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateRollbackBudgetTag(List<AuditFeePredictionDto> dtos) {
        if (CollectionUtils.isEmpty(dtos) ){
            return;
        }
        List<String> detailPlanItemCodes = dtos.stream()
                .filter(a -> StringUtils.isNotEmpty(a.getDetailPlanItemCode()))
                .filter(a -> StringUtils.isNotEmpty(a.getRollbackBudgetTag()))
                .map(AuditFeePredictionDto::getDetailPlanItemCode)
                .collect(Collectors.toList());
        List<AuditFeePrediction> list = this.auditFeePredictionRepository.findByActivityDetailPlanItemCodes(detailPlanItemCodes);
        if (!CollectionUtils.isEmpty(list)) {
            Map<String,AuditFeePredictionDto> dtoMap = dtos.stream().collect(Collectors.toMap(AuditFeePredictionDto::getDetailPlanItemCode, Function.identity(),((a, b) ->a)));
            list.forEach(e -> {
                if (dtoMap.containsKey(e.getDetailPlanItemCode())) {
                    AuditFeePredictionDto dto = dtoMap.get(e.getDetailPlanItemCode());
                    e.setRollbackBudgetTag(dto.getRollbackBudgetTag());
                }
            });
            this.auditFeePredictionRepository.updateBatchById(list);
        }
    }

    @Override
    public void updateWholeAudit(List<AuditFeePredictionDto> dtos) {
        if (CollectionUtils.isEmpty(dtos) ){
            return;
        }
        List<String> detailPlanItemCodes = dtos.stream()
                .filter(a -> StringUtils.isNotEmpty(a.getDetailPlanItemCode()))
                .filter(a -> StringUtils.isNotEmpty(a.getWholeAudit()))
                .filter(a -> Objects.nonNull(a.getAlreadyAuditAmount()))
                .map(AuditFeePredictionDto::getDetailPlanItemCode)
                .collect(Collectors.toList());
        List<AuditFeePrediction> list = this.auditFeePredictionRepository.findByActivityDetailPlanItemCodes(detailPlanItemCodes);
        if (!CollectionUtils.isEmpty(list)) {
            Map<String,AuditFeePredictionDto> dtoMap = dtos.stream().collect(Collectors.toMap(AuditFeePredictionDto::getDetailPlanItemCode, Function.identity(),((a, b) ->a)));
            list.forEach(e -> {
                if (dtoMap.containsKey(e.getDetailPlanItemCode())) {
                    AuditFeePredictionDto dto = dtoMap.get(e.getDetailPlanItemCode());
                    e.setWholeAudit(dto.getWholeAudit());
                    e.setAlreadyAuditAmount(dto.getAlreadyAuditAmount());
                    e.setCanAuditAmount(Optional.ofNullable(e.getPredictionAuditAmount()).orElse(BigDecimal.ZERO).subtract(e.getAlreadyAuditAmount()));
                }
            });
            this.auditFeePredictionRepository.updateBatchById(list);
        }
    }

    @Override
    public void updateCloseDate(List<AuditFeePredictionDto> dtos) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        List<String> detailPlanItemCodes = dtos.stream()
                .filter(a -> StringUtils.isNotEmpty(a.getDetailPlanItemCode()))
                .filter(a -> StringUtils.isNotEmpty(a.getIsClose()))
                .filter(a -> Objects.nonNull(a.getCloseDate()))
                .map(AuditFeePredictionDto::getDetailPlanItemCode)
                .collect(Collectors.toList());
        List<AuditFeePrediction> list = this.auditFeePredictionRepository.findByActivityDetailPlanItemCodes(detailPlanItemCodes);
        if (!CollectionUtils.isEmpty(list)) {
            Map<String,AuditFeePredictionDto> dtoMap = dtos.stream().collect(Collectors.toMap(AuditFeePredictionDto::getDetailPlanItemCode, Function.identity(),((a, b) ->a)));
            list.forEach(e -> {
                if (dtoMap.containsKey(e.getDetailPlanItemCode())) {
                    AuditFeePredictionDto dto = dtoMap.get(e.getDetailPlanItemCode());
                    e.setIsClose(dto.getIsClose());
                    e.setCloseDate(dto.getCloseDate());
                }
            });
            this.auditFeePredictionRepository.updateBatchById(list);
        }
    }
}
