package com.biz.crm.tpm.business.audit.fee.local.service.settlement.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckDetailPlanVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

public interface AuditFeeSettlementCheckDetailPlanService extends MnPageCacheService<AuditFeeSettlementCheckDetailPlanVo,AuditFeeSettlementCheckDetailPlanDto> {

    /**
     * 分页查询
     * @param pageable
     * @param dto
     * @return
     */
    Page<AuditFeeSettlementCheckDetailPlanVo> findByConditions(Pageable pageable, AuditFeeSettlementCheckDetailPlanDto dto);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    AuditFeeSettlementCheckDetailPlanVo findById(String id);


    /**
     * 批量删除
     * @param ids
     */
    void deleteBatch(List<String> ids);

    Integer getTotal(String cacheKey);

    /**
     * 条件分页查询
     *
     * @param pageable      可分页
     * @param paginationDto 分页dto
     * @return {@link Page}<{@link AuditFeeSettlementCheckDetailPlanVo}>
     */
    Page<AuditFeeSettlementCheckDetailPlanVo> findDetailPlanByConditions(Pageable pageable, AuditFeeSettlementCheckDetailPlanDto paginationDto);
}
