package com.biz.crm.tpm.business.audit.fee.local.service.settlement.check;

import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckFindFeeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckVo;

import java.util.List;

public interface AuditFeeSettlementCheckService {

    /**
     * 定时任务更新数据
     */
    void autoJobUpdate();

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    AuditFeeSettlementCheckVo findById(String id);

    /**
     * 取消匹配结果
     * @param id
     */
    void cancelMatch(String id);

    /**
     * 手工调整匹配结果
     * @param ids
     */
    void handleChangeMatch(List<String> ids);

    /**
     * 重新匹配结果
     * @param id
     */
    void matchAgain(String id);

    /**
     * 提交保存
     * @param dto
     */
    void update(AuditFeeSettlementCheckDto dto);

    /**
     * 差异保存
     * @param dto
     */
    void diffSave(AuditFeeSettlementCheckDto dto);

    /**
     * 手动计算
     * @param dto
     */
    AuditFeeSettlementCheckDto compute(AuditFeeSettlementCheckDto dto);

    /**
     * 抽取费用数据
     * @param dto
     */
    void findFeeInfo(AuditFeeSettlementCheckFindFeeDto dto);

    /**
     * 删除
     * @param ids
     */
    void deleteByIds(String ids);

    /**
     * 更新分摊金额
     * @param dto
     */
    void updateApportionAmount(AuditFeeSettlementCheckDto dto);

    /**
     * 批量保存(结算单)
     * @param list
     */
    void saveBatchForSettlementAndFee(List<AuditFeeSettlementCheckVo> list);

    /**
     * 批量保存(费用单)
     * @param list
     */
    void saveBatchForFee(List<AuditFeeSettlementCheckVo> list);
}
