package com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.internal;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDetailPlan;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckDetailPlan;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckDetailPlanShare;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckDetailPlanRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckDetailPlanShareRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.perdiction.AuditFeePredictionService;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckDetailPlanService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.prediction.AuditFeePredictionVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.sdk.enumeration.DataSourceEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

@Slf4j
@Service
public class AuditFeeSettlementCheckDetailPlanServiceImpl extends MnPageCacheServiceImpl<AuditFeeSettlementCheckDetailPlanVo, AuditFeeSettlementCheckDetailPlanDto> implements AuditFeeSettlementCheckDetailPlanService {

    @Autowired
    private RedisService redisService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AuditFeeSettlementCheckDetailPlanRepository auditFeeSettlementCheckDetailPlanRepository;
    @Autowired
    private AuditFeeSettlementCheckDetailPlanShareRepository auditFeeSettlementCheckDetailPlanShareRepository;

    /**
     * 扣费预测
     */
    @Autowired(required = false)
    private AuditFeePredictionService auditFeePredictionService;

    @Override
    public Page<AuditFeeSettlementCheckDetailPlanVo> findByConditions(Pageable pageable, AuditFeeSettlementCheckDetailPlanDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        Page<AuditFeeSettlementCheckDetailPlanVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto = Optional.ofNullable(dto).orElse(new AuditFeeSettlementCheckDetailPlanDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.auditFeeSettlementCheckDetailPlanRepository.findByConditions(page, dto);
    }

    @Override
    public AuditFeeSettlementCheckDetailPlanVo findById(String id) {
        Validate.notEmpty(id, "参数错误");
        List<AuditFeeSettlementCheckDetailPlanVo> byIds = this.auditFeeSettlementCheckDetailPlanRepository.findByIds(Lists.newArrayList(id));
        Validate.notEmpty(byIds, "未找到细案信息");
        return byIds.get(0);
    }

    /**
     * 批量删除
     * @param ids
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        Validate.notEmpty(ids, "参数错误");
        List<AuditFeeSettlementCheckDetailPlan> list = this.auditFeeSettlementCheckDetailPlanRepository.listByIds(ids);
        Validate.notEmpty(list, "未找到细案信息");
        this.auditFeeSettlementCheckDetailPlanRepository.removeByIds(ids);
        // 删除关联的分摊数据
        for (AuditFeeSettlementCheckDetailPlan detailPlan : list) {
            LambdaQueryWrapper<AuditFeeSettlementCheckDetailPlanShare> deleteShareWrapper = new LambdaQueryWrapper<>();
            deleteShareWrapper.eq(AuditFeeSettlementCheckDetailPlanShare::getCode, detailPlan.getCode());
            deleteShareWrapper.eq(AuditFeeSettlementCheckDetailPlanShare::getDetailPlanItemCode, detailPlan.getDetailPlanItemCode());
            auditFeeSettlementCheckDetailPlanShareRepository.remove(deleteShareWrapper);
        }
    }

    @Override
    public Integer getTotal(String cacheKey) {
        return redisService.lSize(this.helper.getRedisCacheIdKey(cacheKey)).intValue();
    }


    @Override
    public Page<AuditFeeSettlementCheckDetailPlanVo> findDetailPlanByConditions(Pageable pageable, AuditFeeSettlementCheckDetailPlanDto paginationDto) {
        Validate.notNull(paginationDto, "参数对象不能为空");
        Validate.notNull(paginationDto.getBusinessFormatCode(), "请传入业态");
        Validate.notNull(paginationDto.getBusinessUnitCode(), "请传入业务单元");
        Validate.notNull(paginationDto.getSystemCode(), "请传入零售商编码");

        //分页获取扣费预测
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        AuditFeePredictionDto dto = new AuditFeePredictionDto();
        this.convertToAuditFeePredictionDto(paginationDto, dto);

        if (StringUtils.equals(BusinessUnitEnum.SON_COMPANY.getCode(), paginationDto.getBusinessUnitCode())) {
            // 分子
            dto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
            dto.setDataSource(DataSourceEnum.SON_ACTIVITY_DETAIL.getCode());
        } else {
            // 垂直
            dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
            dto.setDataSource(DataSourceEnum.ACTIVITY_DETAIL.getCode());
        }
        // 设置排除的活动编码集合
        List<String> noConfirmByDetailPlanItemCodeList = auditFeeSettlementCheckDetailPlanRepository.findNoConfirmByDetailPlanItemCodeList(null);
        if (CollectionUtils.isNotEmpty(noConfirmByDetailPlanItemCodeList)) {
            dto.setNotInDetailPlanItemCodes(noConfirmByDetailPlanItemCodeList);
        }

        Page<AuditFeePredictionVo> auditFeePredictionVoPage = auditFeePredictionService.findByConditions(pageable, dto);

        return (Page<AuditFeeSettlementCheckDetailPlanVo>) auditFeePredictionVoPage.convert(e -> {
            AuditFeeSettlementCheckDetailPlanVo detailPlanVo = this.predictionConversionPlanItem(e);
            detailPlanVo.setId(null);
            return detailPlanVo;
        });
    }

    public void convertToAuditFeePredictionDto(AuditFeeSettlementCheckDetailPlanDto paginationDto, AuditFeePredictionDto dto) {
        dto.setDetailPlanItemCode(paginationDto.getDetailPlanItemCode());
        dto.setDetailPlanCode(paginationDto.getDetailPlanCode());
        dto.setDetailPlanName(paginationDto.getDetailPlanName());
        dto.setActivityTypeCode(paginationDto.getActivityTypeCode());
        dto.setActivityTypeName(paginationDto.getActivityTypeName());
        dto.setActivityFormCode(paginationDto.getActivityFormCode());
        dto.setActivityFormName(paginationDto.getActivityFormName());
        dto.setSalesInstitutionCode(paginationDto.getSalesInstitutionCode());
        dto.setSalesInstitutionName(paginationDto.getSalesInstitutionName());
        dto.setSystemCode(paginationDto.getSystemCode());
        dto.setSystemName(paginationDto.getSystemName());
        dto.setTerminalCode(paginationDto.getTerminalCode());
        dto.setTerminalName(paginationDto.getTerminalName());
        dto.setProductCode(paginationDto.getProductCode());
        dto.setAuditForm(paginationDto.getAuditForm());
        dto.setBusinessFormatCode(paginationDto.getBusinessFormatCode());
        dto.setTerminalCode(paginationDto.getTerminalCode());
        dto.setTerminalName(paginationDto.getTerminalName());
        dto.setProductCode(paginationDto.getProductCode());
        dto.setProductName(paginationDto.getProductName());
        // 取未完全结案细案数据
        dto.setWholeAudit(BooleanEnum.FALSE.getCapital());
        // 取未完全退回预算细案数据
        dto.setNoRollbackBudgetTagFlag(true);
        // 取可核销金额有值的
        dto.setCanAuditAmountNotNull(true);
    }

    private AuditFeeSettlementCheckDetailPlanVo predictionConversionPlanItem(AuditFeePredictionVo itemVo) {
        AuditFeeCheckDetailPlan detailPlan = new AuditFeeCheckDetailPlan();
        AuditFeeSettlementCheckDetailPlanVo feeCheckDetailPlanVo = nebulaToolkitService.copyObjectByWhiteList(detailPlan, AuditFeeSettlementCheckDetailPlanVo.class, HashSet.class, ArrayList.class);
        feeCheckDetailPlanVo.setDetailPlanItemCode(itemVo.getDetailPlanItemCode());
        feeCheckDetailPlanVo.setDetailPlanCode(itemVo.getDetailPlanCode());
        feeCheckDetailPlanVo.setDetailPlanName(itemVo.getDetailPlanName());
        feeCheckDetailPlanVo.setActivityBeginDate(itemVo.getActivityBeginDate());
        feeCheckDetailPlanVo.setActivityEndDate(itemVo.getActivityEndDate());
        feeCheckDetailPlanVo.setActivityYearMonth(itemVo.getActivityYearMonth());
        feeCheckDetailPlanVo.setSystemCode(itemVo.getSystemCode());
        feeCheckDetailPlanVo.setSystemName(itemVo.getSystemName());
        feeCheckDetailPlanVo.setRegion(itemVo.getRegion());
        feeCheckDetailPlanVo.setProvinceCode(itemVo.getProvinceCode());
        feeCheckDetailPlanVo.setProvinceName(itemVo.getProvinceName());
        feeCheckDetailPlanVo.setActivityTypeCode(itemVo.getActivityTypeCode());
        feeCheckDetailPlanVo.setActivityTypeName(itemVo.getActivityTypeName());
        feeCheckDetailPlanVo.setActivityFormCode(itemVo.getActivityFormCode());
        feeCheckDetailPlanVo.setActivityFormName(itemVo.getActivityFormName());
        feeCheckDetailPlanVo.setAuditForm(itemVo.getAuditForm());
        feeCheckDetailPlanVo.setBuyWay(itemVo.getBuyWay());
        feeCheckDetailPlanVo.setCustomerCode(itemVo.getCustomerCode());
        feeCheckDetailPlanVo.setCustomerName(itemVo.getCustomerName());
        feeCheckDetailPlanVo.setTerminalCode(itemVo.getTerminalCode());
        feeCheckDetailPlanVo.setTerminalName(itemVo.getTerminalName());
        feeCheckDetailPlanVo.setProductCode(itemVo.getProductCode());
        feeCheckDetailPlanVo.setProductName(itemVo.getProductName());
        feeCheckDetailPlanVo.setScheduleName(itemVo.getScheduleName());
        feeCheckDetailPlanVo.setApplyAmount(itemVo.getApplyAmount());
        feeCheckDetailPlanVo.setPredictionAuditAmount(itemVo.getPredictionAuditAmount());
        feeCheckDetailPlanVo.setAlreadyAuditAmount(itemVo.getAlreadyAuditAmount());
        feeCheckDetailPlanVo.setCanAuditAmount(itemVo.getCanAuditAmount());
        feeCheckDetailPlanVo.setSalesInstitutionCode(itemVo.getSalesInstitutionCode());
        feeCheckDetailPlanVo.setSalesInstitutionName(itemVo.getSalesInstitutionName());
        feeCheckDetailPlanVo.setSingleApplicationFee(itemVo.getSingleApplicationFee());
        feeCheckDetailPlanVo.setRemark(itemVo.getRemark());
        return feeCheckDetailPlanVo;
    }
}
