package com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckFee;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckDetailPlanRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckFeeRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckFeeService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckFeeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckFeeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Slf4j
@Service
public class AuditFeeSettlementCheckFeeServiceImpl extends MnPageCacheServiceImpl<AuditFeeSettlementCheckFeeVo,AuditFeeSettlementCheckFeeDto> implements AuditFeeSettlementCheckFeeService {

    @Autowired
    private RedisService redisService;
    @Autowired
    private AuditFeeSettlementCheckFeeRepository auditFeeSettlementCheckFeeRepository;
    @Autowired
    private AuditFeeSettlementCheckDetailPlanRepository auditFeeSettlementCheckDetailPlanRepository;


    @Override
    public Page<AuditFeeSettlementCheckFeeVo> findByConditions(Pageable pageable, AuditFeeSettlementCheckFeeDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        Page<AuditFeeSettlementCheckFeeVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto = Optional.ofNullable(dto).orElse(new AuditFeeSettlementCheckFeeDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.auditFeeSettlementCheckFeeRepository.findByConditions(page,dto);
    }

    @Override
    public AuditFeeSettlementCheckFeeVo findById(String id) {
        Validate.notEmpty(id,"参数错误");
        AuditFeeSettlementCheckFee entity = this.auditFeeSettlementCheckFeeRepository.getById(id);
        Validate.notNull(entity,"未找到费用单信息");
        // TODO: 2023/9/27 应根据编码去kms取值
        AuditFeeSettlementCheckFeeVo vo = this.findInfoFromKms(entity.getFeeDetailCode());
        Validate.notNull(vo,"未从kms找到费用单信息");
        return vo;
    }


    /**
     * 批量删除
     * @param ids
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        Validate.notEmpty(ids,"参数错误");
        List<AuditFeeSettlementCheckFee> list = this.auditFeeSettlementCheckFeeRepository.listByIds(ids);
        Validate.notEmpty(list,"未找到费用单信息");
        this.auditFeeSettlementCheckFeeRepository.removeByIds(ids);
        // 删除对应的细案信息
        String code = list.get(0).getCode();
        this.auditFeeSettlementCheckDetailPlanRepository.removeByCodeAndFeeDetailCode(code, null);
    }

    /**
     * 从kms查询
     * @param settlementDetailCode
     * @return
     */
    private AuditFeeSettlementCheckFeeVo findInfoFromKms(String settlementDetailCode) {
        return new AuditFeeSettlementCheckFeeVo();
    }

    @Override
    public Integer getTotal(String cacheKey) {
        return redisService.lSize(this.helper.getRedisCacheIdKey(cacheKey)).intValue();
    }
}
