package com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.internal;

import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.business.audit.fee.sdk.constant.AuditFeeConstant;
import com.biz.crm.kms.business.audit.fee.sdk.dto.AuditFeeReqDto;
import com.biz.crm.kms.business.audit.fee.sdk.enums.AuditFeeMatchStatusEnum;
import com.biz.crm.kms.business.audit.fee.sdk.service.statement.AuditFeeStatementService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheck;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckDetailPlan;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckDiff;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckFee;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckSettlement;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckDetailPlanRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckDiffRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckFeeRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckRepository;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckSettlementRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async.KMSFeeUpdateAsync;
import com.biz.crm.tpm.business.audit.fee.local.service.perdiction.AuditFeePredictionService;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckDetailPlanService;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckDiffService;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckFeeService;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckService;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckSettlementService;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeSettlementConstant;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.auditFeeVerifyDecide.AuditFeeVerifyDecideDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDiffDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckFeeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckFindFeeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckSettlementDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditDiffUseEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffLedgerOperationTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeVerifyDecideSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditStateEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.ConditionsEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffLedgerDataSourceEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.DiffTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchResultEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchStatusEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.SubmitStatusEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeVerifyDecideService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.FeeAccordingEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.TpmDeductionMatchingTemplateEnums;
import com.biz.crm.tpm.business.audit.fee.sdk.template.service.TpmDeductionMatchingTemplateService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateAllowanceVo;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.prediction.AuditFeePredictionVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckFeeVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckSettlementVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.service.TpmDeductionDetailMappingService;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingCustomerVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingRelationActivityConfigVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingTextVo;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.vo.TpmDeductionDetailMappingVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;


/**
 * 结算核对管理
 * @Author: zhouyang
 * @Date: 2023/9/23
 */
@Slf4j
@Service
public class AuditFeeSettlementCheckServiceImpl extends MnPageCacheServiceImpl<AuditFeeSettlementCheckVo, AuditFeeSettlementCheckDto> implements AuditFeeSettlementCheckService {
    @Autowired(required = false)
    private GenerateCodeService generateCodeService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AuditFeeStatementService auditFeeStatementService;
    @Autowired
    private AuditFeePredictionService auditFeePredictionService;
    @Autowired
    private TpmDeductionDetailMappingService tpmDeductionDetailMappingService;
    @Autowired
    private AuditFeeSettlementCheckRepository auditFeeSettlementCheckRepository;
    @Autowired
    private TpmDeductionMatchingTemplateService tpmDeductionMatchingTemplateService;
    @Autowired
    private AuditFeeSettlementCheckFeeRepository auditFeeSettlementCheckFeeRepository;
    @Autowired
    private AuditFeeSettlementCheckDiffRepository auditFeeSettlementCheckDiffRepository;
    @Autowired
    private AuditFeeSettlementCheckDetailPlanRepository auditFeeSettlementCheckDetailPlanRepository;
    @Autowired
    private AuditFeeSettlementCheckSettlementRepository auditFeeSettlementCheckSettlementRepository;
    @Autowired
    private AuditFeeSettlementCheckSettlementService auditFeeSettlementCheckSettlementService;
    @Autowired
    private AuditFeeSettlementCheckFeeService auditFeeSettlementCheckFeeService;
    @Autowired
    private AuditFeeSettlementCheckDetailPlanService auditFeeSettlementCheckDetailPlanService;
    @Autowired
    private AuditFeeSettlementCheckDiffService auditFeeSettlementCheckDiffService;
    @Autowired
    private AuditFeeDiffLedgerLockService auditFeeDiffLedgerLockService;
    @Autowired
    private AuditFeeCheckVoService auditFeeCheckVoService;

    @Autowired(required = false)
    private KMSFeeUpdateAsync kmsFeeUpdateAsync;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired(required = false)
    private RedisLockService redisLockService;


    /**
     * 定时任务更新数据
     * 1.查询所有生效中的扣费匹配模板
     * 2.根据模板配置找到扣费映射信息
     * 3.去kms异步拉取数据
     */
    @Override
    public void autoJobUpdate() {
        // 1
        TpmDeductionMatchingTemplateDto templateDto = new TpmDeductionMatchingTemplateDto();
        templateDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        templateDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        List<TpmDeductionMatchingTemplateVo> templateVoList = this.tpmDeductionMatchingTemplateService.findAllListByConditions(templateDto);
        log.info("结算核对模板：{}", JSONObject.toJSONString(templateVoList));
        if (!CollectionUtils.isEmpty(templateVoList)) {
            // 2
            List<String> mappingCodes = templateVoList.stream().map(TpmDeductionMatchingTemplateVo::getApplyMappingCode).collect(Collectors.toList());
            List<TpmDeductionDetailMappingVo> mappingVoList = this.tpmDeductionDetailMappingService.findByCodes(mappingCodes);
            log.info("结算核对映射：{}", JSONObject.toJSONString(mappingVoList));
            Map<String,TpmDeductionDetailMappingVo> mappingVoMap = mappingVoList.stream().collect(Collectors.toMap(TpmDeductionDetailMappingVo::getCode, Function.identity(),((a, b) -> a)));
            // 获取数据前删除所有单据未确认并且差异未确认的数据
            this.removeAllExtConfirm(null);
            templateVoList.forEach(templateVo -> {
                if (mappingVoMap.containsKey(templateVo.getApplyMappingCode())) {
                    TpmDeductionDetailMappingVo mappingVo = mappingVoMap.get(templateVo.getApplyMappingCode());
                    // 3
                    this.generateSettlement(templateVo,mappingVo, null);
               }
            });
        }
    }

    /**
     * 获取数据前删除所有单据未确认并且差异未确认的数据
     * @param templateCode 模板编码
     */
    private void removeAllExtConfirm(String templateCode) {
        List<String> codes = this.auditFeeSettlementCheckRepository.findAllExtConfirm(templateCode);
        if (!CollectionUtils.isEmpty(codes)) {
            this.auditFeeSettlementCheckRepository.removeByCodes(codes);
            this.auditFeeSettlementCheckSettlementRepository.removeByCodes(codes);
            this.auditFeeSettlementCheckFeeRepository.removeByCodes(codes);
            this.auditFeeSettlementCheckDetailPlanRepository.removeByCodes(codes);
            this.auditFeeSettlementCheckDiffRepository.removeByCodes(codes);
        }
    }

    /**
     * 批量保存2:值保存主表信息和结算单信息，其他单据保存成功后再去kms查询保存
     * @param headerList
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveBatchForSettlementAndFee(List<AuditFeeSettlementCheckVo> headerList) {
        if (CollectionUtils.isEmpty(headerList)) {
            return;
        }
//        log.info("事件推送的结算实体vo：{}", JSONObject.toJSONString(headerList));

        // 查询已存在的结算核对单
        List<String> keyList = headerList.stream().map(AuditFeeSettlementCheckVo::getMd5UniqueKey).filter(Objects::nonNull).collect(Collectors.toList());
        List<AuditFeeSettlementCheck> existEntityList = auditFeeSettlementCheckRepository.findNotConfirmedByKeyList(keyList);
        Map<String, AuditFeeSettlementCheck> existEntityMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(existEntityList)) {
            existEntityMap.putAll(existEntityList.stream().collect(Collectors.toMap(AuditFeeSettlementCheck::getMd5UniqueKey, Function.identity(), (a,b) -> a)));
        }

        // 查询模板信息
        List<String> templateCodes = headerList.stream().map(AuditFeeSettlementCheckVo::getMatchTemplateCode).distinct().collect(Collectors.toList());
        List<TpmDeductionMatchingTemplateVo> templateVoList = this.tpmDeductionMatchingTemplateService.findByCodes(templateCodes);
        Map<String,TpmDeductionMatchingTemplateVo> templateVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(templateVoList)) {
            templateVoMap.putAll(templateVoList.stream().collect(Collectors.toMap(TpmDeductionMatchingTemplateVo::getCode,Function.identity(), (a, b) -> a)));
        }


        List<AuditFeeSettlementCheck> checkList = Lists.newArrayList();
        List<AuditFeeSettlementCheckSettlement> allSettlementList = Lists.newArrayList();
        List<String> codes = this.generateCodeService.generateCode(AuditFeeSettlementConstant.SETTLEMENT_CODE, headerList.size(), 5, 2, TimeUnit.DAYS);
        AtomicReference<Integer> index = new AtomicReference<>(0);

        for (AuditFeeSettlementCheckVo header : headerList) {
            List<AuditFeeSettlementCheckSettlementVo> settlementList = header.getSettlementList();
            // 存在已确认的结算核对，此时推送来的结算核对数据可能具有增量，如果有增量，形成新的一条结算核对数据
            if (!CollectionUtils.isEmpty(settlementList)) {
                // 过滤掉已经存在的结算单，查找出增量结算单，添加到未确认的结算核对（如果存在），没有则新建结算核对
                List<String> settlementCodeList = settlementList.stream().map(AuditFeeSettlementCheckSettlementVo::getSettlementDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List<String> existSettlementDetailCodeList = auditFeeSettlementCheckSettlementRepository.findSettlementDetailCodeBySettlementDetailCodes(settlementCodeList);
                settlementList = settlementList.stream().filter(e -> !existSettlementDetailCodeList.contains(e.getSettlementDetailCode())).collect(Collectors.toList());
            }
            log.info("1234567890-saveBatchForSettlementAndFee-filter:{}", header.getMd5UniqueKey());
            if (CollectionUtils.isEmpty(settlementList)) continue;

            AuditFeeSettlementCheck entity = existEntityMap.get(header.getMd5UniqueKey());
            if (entity == null) {
                // 新增结算核对数据
                entity = this.nebulaToolkitService.copyObjectByBlankList(header,AuditFeeSettlementCheck.class,HashSet.class,ArrayList.class);
                entity.setId(null);
                entity.setCode(codes.get(index.get()));
                entity.setIsConfirm(YesOrNoEnum.NO.getCode());
                entity.setIsShare(YesOrNoEnum.NO.getCode());
                entity.setMatchStatus(MatchStatusEnum.WAIT_MATCH.getCode());
                entity.setDiffStatus(AuditStateEnum.WAIT_CONFIRM.getCode());
                entity.setTenantCode(TenantUtils.getTenantCode());
                entity.setSettlementAmount(BigDecimal.ZERO);
                TpmDeductionMatchingTemplateVo templateVo = templateVoMap.get(entity.getMatchTemplateCode());
                if (Objects.nonNull(templateVo)) {
                    entity.setMatchTemplateType(templateVo.getDeductionMatchingTemplateType());
                }
                List<TpmDeductionDetailMappingVo> mappingVoList = this.tpmDeductionDetailMappingService.findByCodes(Lists.newArrayList(templateVo.getApplyMappingCode()));
                TpmDeductionDetailMappingVo mappingVo = mappingVoList.get(0);
                if (mappingVo != null && org.apache.commons.collections.CollectionUtils.isNotEmpty(mappingVo.getDeductionDetailMappingRelationActivityConfigList())) {
                    TpmDeductionDetailMappingRelationActivityConfigVo activityConfigVo = mappingVo.getDeductionDetailMappingRelationActivityConfigList().get(0);
                    entity.setActivityTypeCode(activityConfigVo.getActivityTypeCode());
                    entity.setActivityTypeName(activityConfigVo.getActivityTypeName());
                }
            }

            checkList.add(entity);
            BigDecimal settlementAmountTotal = BigDecimal.ZERO;
            List<AuditFeeSettlementCheckSettlement> settlements = (List<AuditFeeSettlementCheckSettlement>) this.nebulaToolkitService.copyCollectionByBlankList(settlementList,AuditFeeSettlementCheckSettlementVo.class,AuditFeeSettlementCheckSettlement.class,HashSet.class,ArrayList.class);
            for (AuditFeeSettlementCheckSettlement settlement : settlements) {
                settlement.setId(null);
                settlement.setCode(entity.getCode());
                settlement.setTenantCode(entity.getTenantCode());
                settlementAmountTotal = settlementAmountTotal.add(settlement.getAmount());
            }
            entity.setSettlementAmount(entity.getSettlementAmount().add(settlementAmountTotal).setScale(2, RoundingMode.HALF_UP));
            allSettlementList.addAll(settlements);
            index.set(index.get()+1);
        }

        if (!CollectionUtils.isEmpty(allSettlementList)) {
            this.auditFeeSettlementCheckSettlementRepository.saveBatch(allSettlementList);
        }
        if (!CollectionUtils.isEmpty(checkList)) {
            checkList.forEach(e -> {
                // 金额计算
                e.setSettlementFeeDiff(e.getSettlementAmount().subtract(e.getFeeAmount()));
                e.setSettlementDetailPlanDiff(e.getSettlementAmount().subtract(e.getDetailPlanAmount()));
                BigDecimal diffConfirmAmount = e.getSettlementAmount().subtract(e.getFeeAmount());
                e.setDiffConfirmAmount(diffConfirmAmount);
                // 匹配结果
                if (e.getMatchActivity()) {
                    e.setMatchStatus(MatchStatusEnum.MATCHED.getCode());
                    if (diffConfirmAmount.compareTo(BigDecimal.ZERO) != 0) {
                        e.setMatchResult(MatchResultEnum.HAVE_DIFFERENCE.getCode());
                    } else if (diffConfirmAmount.compareTo(BigDecimal.ZERO) == 0) {
                        e.setMatchResult(MatchResultEnum.NO_DIFFERENCE.getCode());
                    }
                }
                // 差异
                if (diffConfirmAmount.compareTo(BigDecimal.ZERO) > 0) {
                    if (e.getMatchActivity()) {
                        e.setDiffType(DiffTypeEnum.MORE_DEDUCTION_HAD_DEDUCTION.getCode());
                    } else {
                        e.setDiffType(DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode());
                    }
                } else if (diffConfirmAmount.compareTo(BigDecimal.ZERO) < 0) {
                    e.setDiffType(DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode());
                } else if (diffConfirmAmount.compareTo(BigDecimal.ZERO) == 0) {
                    e.setDiffType(DiffTypeEnum.NO_DIFF.getCode());
                }
            });
            this.auditFeeSettlementCheckRepository.saveOrUpdateBatch(checkList);
            List<String> settlementCheckCodeIds = checkList.stream().map(AuditFeeSettlementCheck::getId).collect(Collectors.toList());
            log.info("再匹配结算核对的费用单，使用ID：{}", settlementCheckCodeIds);
            this.handleChangeMatch(settlementCheckCodeIds);
        }
    }


    /**
     * 批量保存(费用单)
     * 方法无事务，注意数据/金额完整性
     * @param list
     */
    @Override
    public void saveBatchForFee(List<AuditFeeSettlementCheckVo> list) {
        if (CollectionUtils.isEmpty(list)) return;
//        log.info("事件推送的费用实体vo：{}", JSONObject.toJSONString(list));
        // 根据key查询
        List<String> keyList = list.stream().map(AuditFeeSettlementCheckVo::getMd5UniqueKey).filter(Objects::nonNull).collect(Collectors.toList());
        log.info("结算拉取到的费用key：{}", keyList);
        // 已存在的结算核对数据
        List<AuditFeeSettlementCheck> entityList = this.auditFeeSettlementCheckRepository.findNotConfirmedByKeyList(keyList);
        if (CollectionUtils.isEmpty(entityList)) return;

        // 查询模板信息
        List<String> templateCodes = entityList.stream().map(AuditFeeSettlementCheck::getMatchTemplateCode).distinct().collect(Collectors.toList());
        List<TpmDeductionMatchingTemplateVo> templateVoList = this.tpmDeductionMatchingTemplateService.findByCodes(templateCodes);
        Map<String,TpmDeductionMatchingTemplateVo> templateVoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(templateVoList)) {
            templateVoMap.putAll(templateVoList.stream().collect(Collectors.toMap(TpmDeductionMatchingTemplateVo::getCode, Function.identity(), ((a, b) ->a))));
        }
        Map<String,AuditFeeSettlementCheckVo> voMap = list.stream().collect(Collectors.toMap(AuditFeeSettlementCheckVo::getMd5UniqueKey, Function.identity(),((a, b) -> a)));
        list.clear();
        for (AuditFeeSettlementCheck entity : entityList) {
            // 根据key匹配
            if (voMap.containsKey(entity.getMd5UniqueKey())) {
                AuditFeeSettlementCheckVo vo = voMap.get(entity.getMd5UniqueKey());

                // 边执行边保存
                try {
                    boolean lock = redisLockService.tryLock(this.getClass().getName() + ":" + entity.getCode(), TimeUnit.MINUTES, 1, 2);
                    if (!lock) throw new Exception("加锁失败");

                    // 过滤出未被确认的费用单，已在结算核对确认的费用单将丢弃
                    List<AuditFeeSettlementCheckFeeVo> feeList = vo.getFeeList();
                    if (!CollectionUtils.isEmpty(feeList)) {
                        List<String> feeDetailCodes = feeList.stream().map(AuditFeeSettlementCheckFeeVo::getFeeDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                        List<String> existFeeDetailCodes = auditFeeSettlementCheckFeeRepository.findFeeDetailCodeByFeeDetailCodes(feeDetailCodes);
                        feeList = feeList.stream().filter(f -> !existFeeDetailCodes.contains(f.getFeeDetailCode())).collect(Collectors.toList());
                    }
                    if (CollectionUtils.isEmpty(feeList)) continue;

                    Set<String> feeCodes = Sets.newHashSet();
                    // 如果费用和无值，初始化为0
                    if (entity.getFeeAmount() == null) entity.setFeeAmount(BigDecimal.ZERO);
                    List<AuditFeeSettlementCheckFee> fees = (List<AuditFeeSettlementCheckFee>) this.nebulaToolkitService.copyCollectionByBlankList(feeList,AuditFeeSettlementCheckFeeVo.class,AuditFeeSettlementCheckFee.class,HashSet.class,ArrayList.class);
                    fees.forEach(s -> {
                        s.setId(null);
                        s.setCode(entity.getCode());
                        s.setTenantCode(TenantUtils.getTenantCode());
                        feeCodes.add(s.getFeeDetailCode());
                        // 追加费用金额
                        entity.setFeeAmount(entity.getFeeAmount().add(s.getAmount()).setScale(2, RoundingMode.HALF_UP));
                    });
                    entity.setSettlementFeeDiff(entity.getSettlementAmount().subtract(entity.getFeeAmount()).setScale(2, RoundingMode.HALF_UP));
                    this.auditFeeSettlementCheckFeeRepository.saveBatch(fees);
                    fees.clear();

                    // 推送可能分成多次，本次要查询出已经关联上的费用明细
                    List<String> codes = Lists.newArrayList(entity.getCode());
                    Set<String> relateFeeCodes = auditFeeSettlementCheckFeeRepository.findFeeDetailCodeByCodes(codes);
                    relateFeeCodes.addAll(feeCodes);

                    // 删除已匹配的活动，本次全量写入。同步费用单过来是分批的，故每次都全部关联的费用单匹配一次
                    auditFeeSettlementCheckDetailPlanRepository.removeByCodes(codes);
                    // 查询费用单关联活动细案信息
                    List<AuditFeeSettlementCheckDetailPlan> detailPlans = this.matchDetailPlan(relateFeeCodes, entity, templateVoMap.get(entity.getMatchTemplateCode()));
                    this.auditFeeSettlementCheckDetailPlanRepository.saveWithShare(detailPlans);
                    entity.setSettlementDetailPlanDiff(entity.getSettlementAmount().subtract(entity.getDetailPlanAmount()).setScale(2, RoundingMode.HALF_UP));
                    detailPlans.clear();

                    // 金额计算
                    BigDecimal diffConfirmAmount = entity.getSettlementFeeDiff();
                    //如果 差异状态为已确认，则差异确认金额取数据库数据
                    if (AuditStateEnum.CONFIRMED.getCode().equals(entity.getDiffStatus())) {
                        diffConfirmAmount = entity.getDiffConfirmAmount();
                    } else {
                        entity.setDiffConfirmAmount(diffConfirmAmount);
                    }
                    // 匹配结果
                    if (entity.getMatchActivity()) {
                        entity.setMatchStatus(MatchStatusEnum.MATCHED.getCode());
                        entity.setMatchResult(diffConfirmAmount.compareTo(BigDecimal.ZERO) == 0 ? MatchResultEnum.NO_DIFFERENCE.getCode() : MatchResultEnum.HAVE_DIFFERENCE.getCode());
                    }
                    // 差异
                    if (diffConfirmAmount.compareTo(BigDecimal.ZERO) > 0) {
                        entity.setDiffType(entity.getMatchActivity() ? DiffTypeEnum.MORE_DEDUCTION_HAD_DEDUCTION.getCode() : DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode());
                    } else if (diffConfirmAmount.compareTo(BigDecimal.ZERO) < 0) {
                        entity.setDiffType(DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode());
                    } else if (diffConfirmAmount.compareTo(BigDecimal.ZERO) == 0) {
                        entity.setDiffType(DiffTypeEnum.NO_DIFF.getCode());
                    }
                } catch (Exception e) {
                    log.info("结算单号：{}费用单推送保存报错：{}", entity.getCode(), e.getMessage());
                    e.printStackTrace();
                } finally {
                    redisLockService.unlock(this.getClass().getName() + ":" + entity.getCode());
                }
            }
        }
        this.auditFeeSettlementCheckRepository.updateBatchById(entityList);
    }

    /**
     * 根据id查询详情
     * 各个明细的缓存key：前缀+主表code+“:”+每次调用此接口生成的uuid
     * @param id
     * @return
     */
    @Override
    public AuditFeeSettlementCheckVo findById(String id) {
        Validate.notEmpty(id,"参数不能为空");
        AuditFeeSettlementCheck entity = this.auditFeeSettlementCheckRepository.getById(id);
        Validate.notNull(entity,"未找到单据信息");
        AuditFeeSettlementCheckVo vo = this.nebulaToolkitService.copyObjectByBlankList(entity,AuditFeeSettlementCheckVo.class,HashSet.class,ArrayList.class);
        // 生成cacheKey
        String uuid = UUID.randomUUID().toString().replaceAll("-","");
        vo.setCacheKey(uuid);
        vo.setCacheKeySettlement(AuditFeeSettlementConstant.CACHE_PREFIX_SETTLEMENT);
        vo.setCacheKeyFee(AuditFeeSettlementConstant.CACHE_PREFIX_FEE);
        vo.setCacheKeyDetailPlan(AuditFeeSettlementConstant.CACHE_PREFIX_DETAIL_PLAN);
        vo.setCacheKeyDiff(AuditFeeSettlementConstant.CACHE_PREFIX_DIFF);
        return vo;
    }

    /**
     * 重新匹配结果
     * @param id
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void matchAgain(String id) {
        Validate.notEmpty(id,"参数错误");
        AuditFeeSettlementCheck entity = this.auditFeeSettlementCheckRepository.getById(id);
        Validate.notNull(entity,"未找到结算核对信息");
        Validate.isTrue(!YesOrNoEnum.YES.getCode().equals(entity.getIsConfirm()) && !AuditStateEnum.CONFIRMED.getCode().equals(entity.getDiffStatus()), "已确认的数据不能重新匹配");

        //AuditFeeSettlementCheckVo vo = this.nebulaToolkitService.copyObjectByBlankList(entity,AuditFeeSettlementCheckVo.class,HashSet.class,ArrayList.class);

        // 删除旧的信息
        List<String> codes = Lists.newArrayList(entity.getCode());
        this.auditFeeSettlementCheckFeeRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckDetailPlanRepository.removeByCodes(codes);
        // 重新匹配
        TpmDeductionMatchingTemplateVo templateVo = tpmDeductionMatchingTemplateService.findByCode(entity.getMatchTemplateCode());
        Validate.notNull(templateVo,"未找到模板信息");
        List<TpmDeductionDetailMappingVo> mappingVoList = this.tpmDeductionDetailMappingService.findByCodes(Lists.newArrayList(templateVo.getApplyMappingCode()));
        Validate.notEmpty(mappingVoList,"未找到映射信息");
        TpmDeductionDetailMappingVo mappingVo = mappingVoList.get(0);
        Validate.notNull(mappingVo,"未找到映射信息");
        // 费用单
        AuditFeeSettlementCheckSettlement settlement = this.auditFeeSettlementCheckSettlementRepository.findFirstByCode(entity.getCode());
        if (Objects.nonNull(settlement)) {
            this.matchFee(templateVo,mappingVo,entity,settlement);
        }
    }

    @Autowired
    private AuditFeeVerifyDecideService auditFeeVerifyDecideService;

    /**
     * 提交保存
     * @param dto
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(AuditFeeSettlementCheckDto dto) {
        Validate.notNull(dto,"编辑时，参数不能为空");
        Validate.notEmpty(dto.getId(),"编辑时，主键不能为空");
        AuditFeeSettlementCheck entity = this.auditFeeSettlementCheckRepository.getById(dto.getId());
        Validate.notNull(entity,"未找到结算核对信息");
        Validate.isTrue(YesOrNoEnum.NO.getCode().equals(entity.getIsConfirm()),"已确认的单据不能再次确认或保存");
        if (SubmitStatusEnum.CONFIRM.getCode().equals(dto.getStatus())) {
            Validate.isTrue(MatchStatusEnum.MATCHED.getCode().equals(dto.getMatchStatus()),"待匹配的单据不能确认");
        }

        List<AuditFeeSettlementCheckSettlementDto> settlementDtoList = this.auditFeeSettlementCheckSettlementService.findCacheList(dto.getCacheKey());
        List<AuditFeeSettlementCheckFeeDto> feeDtoList = this.auditFeeSettlementCheckFeeService.findCacheList(dto.getCacheKey());
        List<AuditFeeSettlementCheckDetailPlanDto> detailPlanDtoList = this.auditFeeSettlementCheckDetailPlanService.findCacheList(dto.getCacheKey());
        List<AuditFeeSettlementCheckDiffDto> diffDtoList = this.auditFeeSettlementCheckDiffService.findCacheList(dto.getCacheKey());
        log.info("缓存，结算单信息：{}",JSONObject.toJSONString(settlementDtoList));
        log.info("缓存，费用单信息：{}",JSONObject.toJSONString(feeDtoList));
        log.info("缓存，活动信息：{}",JSONObject.toJSONString(detailPlanDtoList));
        log.info("缓存，差异单信息：{}",JSONObject.toJSONString(diffDtoList));
        dto.setSettlementList(settlementDtoList);
        dto.setFeeList(feeDtoList);
        dto.setDetailPlanList(detailPlanDtoList);
        dto.setDiffList(diffDtoList);

        // 差异抵扣需要取缓存数据，应该在差异台账落库之前执行
        if (SubmitStatusEnum.CONFIRM.getCode().equals(dto.getStatus())) {
            Validate.isTrue(MatchStatusEnum.MATCHED.getCode().equals(entity.getMatchStatus()),"待匹配的单据不能确认");
            // 确认时，如果差异使用为待确认，顺带进行差异确认
            if (AuditStateEnum.WAIT_CONFIRM.getCode().equals(entity.getDiffStatus())) {
                entity.setDiffConfirmAmount(dto.getDiffConfirmAmount());
                entity.setDiffUse(dto.getDiffUse());
                entity.setRemark(dto.getRemark());
                this.diffSave(dto);
            }
            AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
            entity.setConfirmUserAccount(loginUser.getAccount());
            entity.setConfirmUserName(loginUser.getRealName());
            entity.setConfirmTime(new Date());
            // 生成“扣费核定管理”数据
            this.createAuditFeeVerifyDecide(entity,detailPlanDtoList);
        }

        // 删除旧的
        List<String> codes = Lists.newArrayList(entity.getCode());
        this.auditFeeSettlementCheckSettlementRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckFeeRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckDetailPlanRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckDiffRepository.removeByCodes(codes);
        // 保存新的
        this.updateSaveRelation(dto);

        // 页面变动数据存储
        entity.setSettlementAmount(dto.getSettlementAmount());
        entity.setFeeAmount(dto.getFeeAmount());
        entity.setDetailPlanAmount(dto.getDetailPlanAmount());
        entity.setSettlementFeeDiff(dto.getSettlementFeeDiff());
        entity.setSettlementDetailPlanDiff(dto.getSettlementDetailPlanDiff());
        entity.setDiffConfirmAmount(dto.getDiffConfirmAmount());
        entity.setDiffType(dto.getDiffType());
        entity.setDiffUse(dto.getDiffUse());
        entity.setDiffStatus(dto.getDiffStatus());
        entity.setMatchStatus(dto.getMatchStatus());
        entity.setMatchResult(dto.getMatchResult());
        entity.setMatchActivity(dto.getMatchActivity());

        auditFeeSettlementCheckRepository.updateById(entity);
    }

    /**
     * 生成“扣费核定管理”数据
     * @param entity
     * @param detailPlanDtoList
     */
    private void createAuditFeeVerifyDecide(AuditFeeSettlementCheck entity, List<AuditFeeSettlementCheckDetailPlanDto> detailPlanDtoList) {
        List<AuditFeeVerifyDecideDto> decideList = Lists.newArrayList();
        detailPlanDtoList.forEach(e -> {
            AuditFeeVerifyDecideDto verifyDecideDto = new AuditFeeVerifyDecideDto();
            verifyDecideDto.setActivityDetailItemCode(e.getDetailPlanItemCode());
            verifyDecideDto.setActivityDetailCode(e.getDetailPlanCode());
            verifyDecideDto.setActivityDetailName(e.getDetailPlanName());
            verifyDecideDto.setTerminalCode(e.getTerminalCode());
            verifyDecideDto.setTerminalName(e.getTerminalName());
            verifyDecideDto.setProductCode(e.getProductCode());
            verifyDecideDto.setProductName(e.getProductName());
            verifyDecideDto.setAuditFeeCheckCode(e.getCode());
            verifyDecideDto.setBusinessFormatCode(entity.getBusinessFormatCode());
            verifyDecideDto.setBusinessUnitCode(entity.getBusinessUnitCode());
            verifyDecideDto.setAreaCode(e.getRegion());
            verifyDecideDto.setCustomerRetailerCode(e.getSystemCode());
            verifyDecideDto.setCustomerRetailerName(e.getSystemName());
            verifyDecideDto.setVerifyDecideAmount(e.getThisAuditAmount());
            verifyDecideDto.setSalesInstitutionErpCode(e.getSalesInstitutionCode());
            verifyDecideDto.setSalesInstitutionName(e.getSalesInstitutionName());
            verifyDecideDto.setAuditWay(e.getAuditForm());
            verifyDecideDto.setCustomerCode(e.getCustomerCode());
            verifyDecideDto.setCustomerName(e.getCustomerName());
            verifyDecideDto.setWholeAudit(BooleanEnum.FALSE.getCapital());
            verifyDecideDto.setSource(AuditFeeVerifyDecideSourceEnum.STATEMENT.getCode());
            decideList.add(verifyDecideDto);
        });

        auditFeeVerifyDecideService.createBatch(decideList);
    }

    /**
     * 编辑保存
     * @param dto
     */
    private void updateSaveRelation(AuditFeeSettlementCheckDto dto) {
        List<AuditFeeSettlementCheckSettlement> settlementList = Lists.newArrayList();
        List<AuditFeeSettlementCheckFee> feeList = Lists.newArrayList();
        List<AuditFeeSettlementCheckDetailPlan> detailPlanList = Lists.newArrayList();
        List<AuditFeeSettlementCheckDiff> diffList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(dto.getSettlementList())) {
            List<AuditFeeSettlementCheckSettlement> settlements = (List<AuditFeeSettlementCheckSettlement>) this.nebulaToolkitService.copyCollectionByBlankList(dto.getSettlementList(),AuditFeeSettlementCheckSettlementDto.class,AuditFeeSettlementCheckSettlement.class,HashSet.class,ArrayList.class);
            settlements.forEach(s -> {
                s.setId(null);
                s.setCode(dto.getCode());
            });
            settlementList.addAll(settlements);
        }
        if (!CollectionUtils.isEmpty(dto.getFeeList())) {
            List<AuditFeeSettlementCheckFee> fees = (List<AuditFeeSettlementCheckFee>) this.nebulaToolkitService.copyCollectionByBlankList(dto.getFeeList(),AuditFeeSettlementCheckFeeDto.class,AuditFeeSettlementCheckFee.class,HashSet.class,ArrayList.class);
            fees.forEach(s -> {
                s.setId(null);
                s.setCode(dto.getCode());
            });
            feeList.addAll(fees);
        }
        if (!CollectionUtils.isEmpty(dto.getDetailPlanList())) {
            List<AuditFeeSettlementCheckDetailPlan> detailPlans = (List<AuditFeeSettlementCheckDetailPlan>) this.nebulaToolkitService.copyCollectionByBlankList(dto.getDetailPlanList(),AuditFeeSettlementCheckDetailPlanDto.class,AuditFeeSettlementCheckDetailPlan.class,HashSet.class,ArrayList.class);
            detailPlans.forEach(s -> {
                s.setId(null);
                s.setCode(dto.getCode());
            });
            detailPlanList.addAll(detailPlans);
        }
        if (!CollectionUtils.isEmpty(dto.getDiffList())) {
            List<AuditFeeSettlementCheckDiff> diffs = (List<AuditFeeSettlementCheckDiff>) this.nebulaToolkitService.copyCollectionByBlankList(dto.getDiffList(),AuditFeeSettlementCheckDiffDto.class,AuditFeeSettlementCheckDiff.class,HashSet.class,ArrayList.class);
            diffs.forEach(s -> {
                s.setId(null);
                s.setCode(dto.getCode());
            });
            diffList.addAll(diffs);
        }

        String matchOrConfirm = SubmitStatusEnum.CONFIRM.getCode().equals(dto.getStatus()) ? AuditFeeMatchStatusEnum.CONFIRM.getCode() : AuditFeeMatchStatusEnum.MATCH.getCode();
        if (!CollectionUtils.isEmpty(settlementList)) {
            this.auditFeeSettlementCheckSettlementRepository.saveBatch(settlementList);
            // 同步结算单标记到KMS
            this.updateKMSStatus(settlementList.stream().map(AuditFeeSettlementCheckSettlement::getSettlementDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()), matchOrConfirm, null);
        }
        if (!CollectionUtils.isEmpty(feeList)) {
            this.auditFeeSettlementCheckFeeRepository.saveBatch(feeList);
            // 同步费用单标记到KMS
            this.updateKMSStatus(feeList.stream().map(AuditFeeSettlementCheckFee::getFeeDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList()),null,  matchOrConfirm);
        }
        if (!CollectionUtils.isEmpty(detailPlanList)) {
            this.auditFeeSettlementCheckDetailPlanRepository.saveWithShare(detailPlanList);
        }
        if (!CollectionUtils.isEmpty(diffList)) {
            this.auditFeeSettlementCheckDiffRepository.saveWithShare(diffList);
        }
    }

    /**
     * 取消匹配结果
     * @param id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void cancelMatch(String id) {
        Validate.notEmpty(id,"参数错误");
        AuditFeeSettlementCheck entity = this.auditFeeSettlementCheckRepository.getById(id);
        Validate.notNull(entity,"未找到结算核对单信息");
        Validate.isTrue(!YesOrNoEnum.YES.getCode().equals(entity.getIsConfirm()),"已确认的数据不能取消匹配");
        Validate.isTrue(!AuditStateEnum.CONFIRMED.getCode().equals(entity.getDiffStatus()),"已确认差异的数据不能取消匹配");

        // 删除相关单据信息
        List<String> codes = Lists.newArrayList(entity.getCode());
        this.auditFeeSettlementCheckFeeRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckDetailPlanRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckDiffRepository.removeByCodes(codes);

        entity.setMatchResult(StringUtils.EMPTY);
        entity.setMatchActivity(Boolean.FALSE);
        entity.setMatchStatus(MatchStatusEnum.WAIT_MATCH.getCode());
        entity.setFeeAmount(BigDecimal.ZERO);
        entity.setDetailPlanAmount(BigDecimal.ZERO);
        entity.setSettlementFeeDiff(entity.getSettlementAmount());
        entity.setSettlementDetailPlanDiff(entity.getSettlementAmount());
        entity.setDiffConfirmAmount(entity.getSettlementFeeDiff());
        // 差异
        int i = entity.getDiffConfirmAmount().compareTo(BigDecimal.ZERO);
        if (i > 0) {
            entity.setDiffType(DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode());
        } else if (i < 0) {
            entity.setDiffType(DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode());
        } else {
            entity.setDiffType(DiffTypeEnum.NO_DIFF.getCode());
        }
        entity.setDiffUse(null);
        this.auditFeeSettlementCheckRepository.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void handleChangeMatch(List<String> ids) {
        log.info("手工调整匹配结果：{}", String.join(",", ids));

        Validate.notEmpty(ids,"请选择单据");
        List<AuditFeeSettlementCheck> entityList = this.auditFeeSettlementCheckRepository.listByIds(ids);
        Validate.notEmpty(entityList,"未找到结算核对单信息");
        entityList.forEach(e -> {
            Validate.isTrue(!YesOrNoEnum.YES.getCode().equals(e.getIsConfirm()) && !AuditStateEnum.CONFIRMED.getCode().equals(e.getDiffStatus()), e.getCode() + "已确认或差异确认不能手工匹配");

            //更新费用单金额为0
            e.setFeeAmount(BigDecimal.ZERO);
            e.setSettlementFeeDiff(e.getSettlementAmount());
            e.setDetailPlanAmount(BigDecimal.ZERO);
            e.setSettlementDetailPlanDiff(e.getSettlementAmount());
        });
        // 模板
        List<String> templateCodes = entityList.stream().map(AuditFeeSettlementCheck::getMatchTemplateCode).collect(Collectors.toList());
        TpmDeductionMatchingTemplateDto templateDto = new TpmDeductionMatchingTemplateDto();
        templateDto.setCodeList(Lists.newArrayList(templateCodes));
        List<TpmDeductionMatchingTemplateVo> templateVoList = this.tpmDeductionMatchingTemplateService.findAllListByConditions(templateDto);
        Validate.notEmpty(templateVoList,"未找到关联模板");
        Map<String,TpmDeductionMatchingTemplateVo> templateVoMap = templateVoList.stream().collect(Collectors.toMap(TpmDeductionMatchingTemplateVo::getCode,Function.identity(),((a,b) -> a)));
        // 映射信息
        List<String> mappingCodes = templateVoList.stream().map(TpmDeductionMatchingTemplateVo::getApplyMappingCode).collect(Collectors.toList());
        List<TpmDeductionDetailMappingVo> mappingVoList = this.tpmDeductionDetailMappingService.findByCodes(mappingCodes);
        Validate.notEmpty(mappingVoList,"未找到关联映射");
        Map<String,TpmDeductionDetailMappingVo> mappingVoMap = mappingVoList.stream().collect(Collectors.toMap(TpmDeductionDetailMappingVo::getCode, Function.identity(),((a, b) -> a)));

        // 删除旧的费用单
        List<String> codes = entityList.stream().map(AuditFeeSettlementCheck::getCode).filter(Objects::nonNull).collect(Collectors.toList());
        // 删除旧的费用、活动
        this.auditFeeSettlementCheckFeeRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckDetailPlanRepository.removeByCodes(codes);
        //更新费用单、活动金额为0
        this.auditFeeSettlementCheckRepository.updateBatchById(entityList);

        entityList.forEach(entity -> {
            log.info("开始匹配结算核对：{}", entity.getCode());
            TpmDeductionMatchingTemplateVo templateVo = templateVoMap.get(entity.getMatchTemplateCode());
            if (Objects.nonNull(templateVo)) {
                log.info("模板：{}", templateVo);
                TpmDeductionDetailMappingVo mappingVo = mappingVoMap.get(templateVo.getApplyMappingCode());
                if (Objects.nonNull(mappingVo)) {
                    log.info("映射：{}", mappingVo);
                    // 查询关联的第一条结算单
                    AuditFeeSettlementCheckSettlement settlement = this.auditFeeSettlementCheckSettlementRepository.findFirstByCode(entity.getCode());
                    if (Objects.nonNull(settlement)) {
                        log.info("首条结算单：{}", settlement);
                        this.matchFee(templateVo, mappingVo, entity, settlement);
                    }
                }
            }
        });
    }

    @Autowired
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;

    /**
     * 差异保存
     * @param dto
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void diffSave(AuditFeeSettlementCheckDto dto) {
        log.info("结算核对确认差异：{}", dto);
        Validate.notNull(dto,"编辑时，参数不能为空");
        Validate.notNull(dto.getCacheKey(),"CacheKey不能为空");
        Validate.notNull(dto.getId(),"主键不能为空");
        Validate.notNull(dto.getDiffConfirmAmount(),"差异确认金额不能为空");

        AuditFeeSettlementCheck entity = this.auditFeeSettlementCheckRepository.getById(dto.getId());
        Validate.notNull(entity,"未找到结算核对信息");

        String cacheKey = dto.getCacheKey();
        entity.setDiffUse(dto.getDiffUse());
        entity.setDiffType(dto.getDiffType());
        entity.setRemark(dto.getRemark());
        entity.setDiffStatus(AuditStateEnum.CONFIRMED.getCode());
        entity.setDiffConfirmAmount(dto.getDiffConfirmAmount());

        // 查询活动
        AuditFeeSettlementCheckDetailPlanDto detailPlanDto = null;
        List<AuditFeeSettlementCheckDetailPlanDto> detailPlanDtoList = this.auditFeeSettlementCheckDetailPlanService.findCacheList(cacheKey);
        if (!CollectionUtils.isEmpty(detailPlanDtoList)) {
            // 取匹配到的最后一个活动，按活动细案明细编码排序
            detailPlanDto = detailPlanDtoList.stream().max(Comparator.comparing(AuditFeeSettlementCheckDetailPlanDto::getDetailPlanItemCode)).orElse(null);
        }
        log.info("最后一个活动信息：{}",JSONObject.toJSONString(detailPlanDto));

        if (StringUtils.equalsAny(entity.getDiffType(),DiffTypeEnum.MORE_DEDUCTION_HAD_DEDUCTION.getCode(),DiffTypeEnum.MORE_DEDUCTION_NO_DEDUCTION.getCode())) {
            // 关于生成的台账日期，如果数据不跨月使用数据日期，跨月使用确认差异日期
            String yearMonth = null;
            List<AuditFeeSettlementCheckSettlementDto> settlementDtoList = this.auditFeeSettlementCheckSettlementService.findCacheList(cacheKey);
            if (!CollectionUtils.isEmpty(settlementDtoList)) {
                List<String> settlementDtoYearMonthList = settlementDtoList.stream().
                    sorted(Comparator.comparing(AuditFeeSettlementCheckSettlementDto::getOrderYearMonth))
                    .map(AuditFeeSettlementCheckSettlementDto::getOrderYearMonth).filter(Objects::nonNull)
                    .collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(settlementDtoYearMonthList) && settlementDtoYearMonthList.size() > 1) {
                    if (settlementDtoYearMonthList.get(0).equals(settlementDtoYearMonthList.get(settlementDtoYearMonthList.size()-1))) {
                        yearMonth = settlementDtoYearMonthList.get(0);
                    }
                }
            }
            if (yearMonth == null) {
                // 结算单数据不全或者不在一个月
                yearMonth = DateUtil.format(new Date(), "yyyy-MM");
            }

            log.info("生成台账");
            // 生成差异费用台账
            AuditFeeDiffLedgerDto ledgerDto = new AuditFeeDiffLedgerDto();
            ledgerDto.setAuditFeeCheckCode(entity.getCode());
            ledgerDto.setFeeYearMonth(yearMonth);
            if (Objects.nonNull(ledgerDto.getFeeYearMonth())){
                String[] yearMonthArray = ledgerDto.getFeeYearMonth().split("-");
                ledgerDto.setYear(yearMonthArray[0]);
                ledgerDto.setMonth(yearMonthArray[1]);
            }
            ledgerDto.setBusinessFormatCode(entity.getBusinessFormatCode());
            ledgerDto.setBusinessUnitCode(entity.getBusinessUnitCode());
            ledgerDto.setStatus(AuditStateEnum.WAIT_CONFIRM.getCode());
            ledgerDto.setRetailerCode(entity.getSystemCode());
            ledgerDto.setRetailerName(entity.getSystemName());
            ledgerDto.setBusinessAreaCode(entity.getRegion());
            ledgerDto.setBusinessAreaName(entity.getRegion());
            ledgerDto.setSoldToPartyCode(entity.getCustomerCode());
            ledgerDto.setSoldToPartyName(entity.getCustomerName());
            ledgerDto.setSalesOrgCode(entity.getSalesOrgCode());
            ledgerDto.setSalesOrgName(entity.getSalesOrgName());
//            ledgerDto.setIsEffectStatement(BooleanEnum.TRUE.getCapital());
            ledgerDto.setDiffAmount(entity.getDiffConfirmAmount());
            ledgerDto.setRemark(entity.getRemark());
            ledgerDto.setDataSource(DiffLedgerDataSourceEnum.FEE_COLLATE.getCode());
            // 匹配上活动就从最后一条活动中取值传递
            if (detailPlanDto != null) {
                ledgerDto.setDeliveryPartyCode(detailPlanDto.getTerminalCode());
                ledgerDto.setDeliveryPartyName(detailPlanDto.getTerminalName());
//                ledgerDto.setSoldToPartyCode(detailPlanDto.getCustomerCode());
//                ledgerDto.setSoldToPartyName(detailPlanDto.getCustomerName());
                ledgerDto.setActivitiesType(detailPlanDto.getActivityTypeCode());
                ledgerDto.setActivitiesTypeName(detailPlanDto.getActivityTypeName());
                ledgerDto.setActivity_form_code(detailPlanDto.getActivityFormCode());
                ledgerDto.setActivity_form_name(detailPlanDto.getActivityFormName());
            }
            auditFeeDiffLedgerVoService.create(ledgerDto);
        } else if (StringUtils.equalsAny(entity.getDiffType(),DiffTypeEnum.LESS_DEDUCTION_HAD_DEDUCTION.getCode())) {
            Validate.notNull(entity.getDiffUse(),"请选择差异使用");
            if (AuditDiffUseEnum.DEDUCTION_DIFFERENCE.getCode().equalsIgnoreCase(entity.getDiffUse())) {
                // 抵扣差异费用台账
                log.info("扣减台账");
                List<AuditFeeSettlementCheckDiffDto> diffCatchDtoList = this.auditFeeSettlementCheckDiffService.findCacheList(cacheKey);
                // 确认时校验
                Validate.notEmpty(diffCatchDtoList,"差异使用为【抵扣差异】时，必须选择差异费用");

                // 校验单条数据扣减正确性
                List<String> notEnoughDeductCodeList = new ArrayList<>();
                BigDecimal totalDeductionAmount = BigDecimal.ZERO;
                for (AuditFeeSettlementCheckDiffDto diffVo : diffCatchDtoList) {
                    String feeDiffLedgerCode = diffVo.getFeeDiffLedgerCode();
                    Validate.notNull(diffVo.getBeRecoveredAmount(), "所选差异数据["+ feeDiffLedgerCode +"]待追回金额不能为空");
                    Validate.notNull(diffVo.getDeductAmount(), "所选差异数据[" + feeDiffLedgerCode + "]本次抵扣金额不能为空");
                    // 检查待追回金额大于本次抵扣金额
                    if (diffVo.getBeRecoveredAmount().compareTo(diffVo.getDeductAmount()) < 0) {
                        // 不够扣减
                        notEnoughDeductCodeList.add(feeDiffLedgerCode);
                    }
                    totalDeductionAmount = totalDeductionAmount.add(diffVo.getDeductAmount());
                }
                // 存在不足扣减数据
                Validate.isTrue(CollectionUtils.isEmpty(notEnoughDeductCodeList), "所选差异数据[" + String.join(",", notEnoughDeductCodeList) + "]不足抵扣");
                log.info("差异确认金额-抵扣金额,{}-{}",entity.getDiffConfirmAmount().abs(),totalDeductionAmount);
                Validate.isTrue(totalDeductionAmount.compareTo(entity.getDiffConfirmAmount().abs()) == 0,"抵扣金额之和必须与差异确认金额绝对值相等");

                List<String> feeDiffLedgerCodeList = diffCatchDtoList.stream().peek(e -> e.setCode(entity.getCode())).map(AuditFeeSettlementCheckDiffDto::getFeeDiffLedgerCode).filter(Objects::nonNull).collect(Collectors.toList());

                // 删除旧的
                this.auditFeeSettlementCheckDiffRepository.removeByCodes(Lists.newArrayList(entity.getCode()));
                List<AuditFeeSettlementCheckDiff> diffList = (List<AuditFeeSettlementCheckDiff>) this.nebulaToolkitService.copyCollectionByBlankList(diffCatchDtoList,AuditFeeSettlementCheckDiffDto.class,AuditFeeSettlementCheckDiff.class,HashSet.class,ArrayList.class);
                this.auditFeeSettlementCheckDiffRepository.saveWithShare(diffList);

                Validate.isTrue(auditFeeDiffLedgerLockService.lock(feeDiffLedgerCodeList, TimeUnit.MINUTES, 1), "扣减差异费用台账失败，请重试");
                // 这里取差异台账数据缓存，但不清理，因为前端并没关闭编辑窗口
                for (AuditFeeSettlementCheckDiff diff : diffList) {
                    AuditFeeDiffLedgerDeductionDto deductionDto = new AuditFeeDiffLedgerDeductionDto();
                    deductionDto.setOperationType(AuditFeeDiffLedgerOperationTypeEnum.DEDUCTION_AMOUNT.getCode());
                    deductionDto.setFeeDiffLedgerCode(diff.getFeeDiffLedgerCode());
                    deductionDto.setBusinessCode(entity.getCode());
                    deductionDto.setRecoveredAmount(diff.getDeductAmount());
                    AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
                    deductionDto.setOperatorAccount(loginUser.getAccount());
                    deductionDto.setOperatorName(loginUser.getRealName());
                    deductionDto.setRemark(entity.getRemark());
                    deductionDto.setResaleCommercialCode(entity.getSystemCode());
                    deductionDto.setResaleCommercialName(entity.getSystemName());
                    if (detailPlanDto != null) {
                        deductionDto.setTerminalCode(detailPlanDto.getTerminalCode());
                        deductionDto.setTerminalName(detailPlanDto.getTerminalName());
                        deductionDto.setActivityFormCode(detailPlanDto.getActivityFormCode());
                        deductionDto.setActivityFormName(detailPlanDto.getActivityFormName());
                        deductionDto.setActivityTypeCode(detailPlanDto.getActivityTypeCode());
                        deductionDto.setActivityTypeName(detailPlanDto.getActivityTypeName());
                    }
                    deductionDto.setDataSource(DiffLedgerDataSourceEnum.FINAL_STATEMENT_COLLATE.getCode());
                    auditFeeDiffLedgerVoService.useAmount(deductionDto);
                }
                auditFeeDiffLedgerLockService.unlock(feeDiffLedgerCodeList);
            }
        }
        this.auditFeeSettlementCheckRepository.updateById(entity);
    }

    @Override
    public AuditFeeSettlementCheckDto compute(AuditFeeSettlementCheckDto dto) {
        log.info("开始计算：{}", dto);
        // 获取缓存数据
        String code = dto.getCode();
        String cacheKey = dto.getCacheKey();
        List<AuditFeeSettlementCheckSettlementDto> settlementDtoList = this.auditFeeSettlementCheckSettlementService.findCacheList(cacheKey);
        List<AuditFeeSettlementCheckFeeDto> feeDtoList = this.auditFeeSettlementCheckFeeService.findCacheList(cacheKey);
        List<AuditFeeSettlementCheckDetailPlanDto> detailPlanDtoList = this.auditFeeSettlementCheckDetailPlanService.findCacheList(cacheKey);

        if (Boolean.TRUE.equals(dto.getRematchDetailPlan())) {
            log.info("重新匹配活动");
            // 因为存在关联，操作费用单，需要对应操作活动，采用每次都全量费用单号 重新查询费用核对，得到匹配的活动
            detailPlanDtoList.clear();
            auditFeeSettlementCheckDetailPlanService.clearCache(cacheKey);
            Set<String> feeDetailCodeSet = feeDtoList.stream().map(AuditFeeSettlementCheckFeeDto::getFeeDetailCode).filter(Objects::nonNull).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(feeDetailCodeSet)) {
                TpmDeductionMatchingTemplateVo template = tpmDeductionMatchingTemplateService.findByCode(dto.getMatchTemplateCode());
                if (template != null && template.getFeeAccording() != null) {
                    AuditFeeSettlementCheck settlementCheck = nebulaToolkitService.copyObjectByBlankList(dto, AuditFeeSettlementCheck.class, HashSet.class, ArrayList.class);
                    List<AuditFeeSettlementCheckDetailPlan> detailPlanList = this.matchDetailPlan(feeDetailCodeSet, settlementCheck, template);
                    if (!CollectionUtils.isEmpty(detailPlanList)) {
                        // 字段修改数据拷贝回来
                        BeanUtils.copyProperties(settlementCheck, dto);
                        detailPlanDtoList.addAll(nebulaToolkitService.copyCollectionByWhiteList(detailPlanList, AuditFeeSettlementCheckDetailPlan.class, AuditFeeSettlementCheckDetailPlanDto.class, HashSet.class, ArrayList.class));
                    }
                }
            }
            // 获取到的活动全量放入缓存
            auditFeeSettlementCheckDetailPlanService.saveListCache(cacheKey, detailPlanDtoList);
        }

        log.info("计算settlement缓存条数：{}", settlementDtoList.size());
        log.info("计算fee缓存条数：{}", feeDtoList.size());
        log.info("计算detailPlan缓存条数：{}", detailPlanDtoList.size());

        dto.setSettlementAmount(settlementDtoList.stream().map(AuditFeeSettlementCheckSettlementDto::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        dto.setFeeAmount(feeDtoList.stream().map(AuditFeeSettlementCheckFeeDto::getAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        dto.setDetailPlanAmount(detailPlanDtoList.stream().map(AuditFeeSettlementCheckDetailPlanDto::getCanAuditAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        dto.setSettlementFeeDiff(dto.getSettlementAmount().subtract(dto.getFeeAmount()));
        dto.setSettlementDetailPlanDiff(dto.getSettlementAmount().subtract(dto.getDetailPlanAmount()));

        // 修改匹配状态，匹配结果，是否匹配活动
        dto.setMatchStatus(CollectionUtils.isEmpty(detailPlanDtoList) ? MatchStatusEnum.WAIT_MATCH.getCode() : MatchStatusEnum.MATCHED.getCode());
        dto.setMatchResult(BigDecimal.ZERO.compareTo(dto.getDiffConfirmAmount()) == 0 ? MatchResultEnum.NO_DIFFERENCE.getCode() : MatchResultEnum.HAVE_DIFFERENCE.getCode());
        dto.setMatchActivity(CollectionUtils.isEmpty(detailPlanDtoList) ? Boolean.FALSE : Boolean.TRUE);

        return dto;
    }

    /**
     * 抽取费用数据
     * @param dto
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void findFeeInfo(AuditFeeSettlementCheckFindFeeDto dto) {
        Validate.notNull(dto,"参数不能为空");
        Validate.notNull(dto.getStartDate(),"开始时间不能为空");
        Validate.notNull(dto.getEndDate(),"结束时间不能为空");
        Validate.notEmpty(dto.getBusinessFormatCode(),"业态不能为空");
        Validate.notEmpty(dto.getBusinessUnitCode(),"业务单元不能为空");
        //Validate.notEmpty(dto.getSystemCode(),"零售商不能为空");
        Validate.notEmpty(dto.getMatchTemplateCode(),"模板不能为空");

        // 模板信息
        TpmDeductionMatchingTemplateVo templateVo = this.tpmDeductionMatchingTemplateService.findByCode(dto.getMatchTemplateCode());
        Validate.notNull(templateVo,"未找到模板信息");
        List<TpmDeductionDetailMappingVo> mappingVoList = this.tpmDeductionDetailMappingService.findByCodes(Lists.newArrayList(templateVo.getApplyMappingCode()));
        Validate.notEmpty(mappingVoList,"未找到映射信息");
        TpmDeductionDetailMappingVo mappingVo = mappingVoList.get(0);
        // 删除旧的未确认的数据
        //this.auditFeeSettlementCheckRepository.removeByConfirm(YesOrNoEnum.NO.getCode());
        this.removeAllExtConfirm(templateVo.getCode());
        this.generateSettlement(templateVo,mappingVo,dto);

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByIds(String ids) {
        Validate.notEmpty(ids,"参数错误");
        List<String> array = Lists.newArrayList(ids.split(","));
        List<AuditFeeSettlementCheck> list = this.auditFeeSettlementCheckRepository.listByIds(array);
        Validate.notEmpty(list,"未找到结算核对信息");
        List<String> codes = Lists.newArrayList();
        list.forEach(e -> {
            Validate.isTrue(!YesOrNoEnum.YES.getCode().equals(e.getIsConfirm()), e.getCode()+"已确认不能删除");
            Validate.isTrue(!AuditStateEnum.CONFIRMED.getCode().equals(e.getDiffStatus()), e.getCode()+"已确认差异不能删除");
            codes.add(e.getCode());
        });
        this.auditFeeSettlementCheckRepository.removeByIds(array);
        // 删除关联单据数据库和缓存
        this.auditFeeSettlementCheckSettlementRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckFeeRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckDetailPlanRepository.removeByCodes(codes);
        this.auditFeeSettlementCheckDiffRepository.removeByCodes(codes);
    }

    /**
     * 更新分摊金额
     * @param dto
     */
    @Override
    public void updateApportionAmount(AuditFeeSettlementCheckDto dto) {
        Validate.notNull(dto,"参数错误");
        Validate.notNull(dto.getCode(),"参数错误");
        Validate.notNull(dto.getCacheKey(),"请传入cacheKey");
        // 需要使用页面数据做分摊金额
        Validate.notNull(dto.getSettlementAmount(),"请传入结算单金额");
        Validate.notNull(dto.getSettlementFeeDiff(),"请传入结算单-费用差异");

        AuditFeeSettlementCheck entity = this.auditFeeSettlementCheckRepository.findByCode(dto.getCode());
        Validate.notNull(entity,"结算核对单信息不存在");
        // 分摊需要使用
        entity.setSettlementAmount(dto.getSettlementAmount());
        entity.setSettlementFeeDiff(dto.getSettlementFeeDiff());

        // 从缓存中取细案信息
        String cacheKey = dto.getCacheKey();
        List<AuditFeeSettlementCheckDetailPlanDto> detailPlanDtoList = auditFeeSettlementCheckDetailPlanService.findCacheList(cacheKey);
        Validate.notEmpty(detailPlanDtoList,"未找到结算核对细案信息");

        // 模板信息
        TpmDeductionMatchingTemplateVo templateVo = this.tpmDeductionMatchingTemplateService.findByCode(entity.getMatchTemplateCode());
        Validate.notNull(templateVo,"未找到结算核对关联模板信息");

        List<AuditFeeSettlementCheckDetailPlan> detailPlanList = (List<AuditFeeSettlementCheckDetailPlan>) this.nebulaToolkitService.copyCollectionByBlankList(detailPlanDtoList, AuditFeeSettlementCheckDetailPlanDto.class, AuditFeeSettlementCheckDetailPlan.class, HashSet.class, ArrayList.class);
        List<AuditFeeSettlementCheckDetailPlan> checkDetailPlans = this.doShare(detailPlanList, entity, templateVo);
        // 回写到缓存
        if (!CollectionUtils.isEmpty(detailPlanDtoList)) {
            detailPlanDtoList = (List<AuditFeeSettlementCheckDetailPlanDto>) this.nebulaToolkitService.copyCollectionByBlankList(checkDetailPlans, AuditFeeSettlementCheckDetailPlan.class, AuditFeeSettlementCheckDetailPlanDto.class, HashSet.class, ArrayList.class);
            auditFeeSettlementCheckDetailPlanService.saveListCache(cacheKey, detailPlanDtoList);
        }
    }

    /**
     * 匹配细案信息
     * @param feeCodes
     * @param entity
     * @param templateVo
     * @return
     */
    private List<AuditFeeSettlementCheckDetailPlan> matchDetailPlan(Set<String> feeCodes, AuditFeeSettlementCheck entity, TpmDeductionMatchingTemplateVo templateVo) {
        log.info("模板信息：{}", JSONObject.toJSONString(templateVo));
        log.info("头表信息：{}", JSONObject.toJSONString(entity));
        log.info("费用单code信息：{}", feeCodes.size());

        if (CollectionUtils.isEmpty(feeCodes) || Objects.isNull(entity) || Objects.isNull(templateVo)) {
            return new ArrayList<>(0);
        }

        // 用所有费用单编号去查匹配到的活动
        List<String> detailPLanItemCodeList = auditFeeCheckVoService.findDetailPlanItemCodeByCost(feeCodes);
        log.info("1234567890-size-of-activity-matched-by-check:{}-{}", detailPLanItemCodeList.size(), entity.getMd5UniqueKey());

        if (CollectionUtils.isEmpty(detailPLanItemCodeList)) return new ArrayList<>(0);

        // 去扣费预测管理查询活动信息
        List<AuditFeePredictionVo> predictionVoList = auditFeePredictionService.findByActivityDetailPlanItemCodes(detailPLanItemCodeList);
        log.info("1234567890-size-of-predict-activity-matched-by-check:{}-{}", predictionVoList.size(), entity.getMd5UniqueKey());

        if (CollectionUtils.isEmpty(predictionVoList)) return new ArrayList<>(0);

        // 当前结算核对匹配的活动
        List<AuditFeeSettlementCheckDetailPlan> detailPlanList = Lists.newArrayList();
        for (AuditFeePredictionVo predictionVo : predictionVoList) {
            AuditFeeSettlementCheckDetailPlan vo = this.nebulaToolkitService.copyObjectByBlankList(predictionVo, AuditFeeSettlementCheckDetailPlan.class,HashSet.class,ArrayList.class);
            vo.setId(null);
            vo.setCode(entity.getCode());
            detailPlanList.add(vo);
        }

        return this.doShare(detailPlanList, entity, templateVo);
    }

    /**
     * 结算核对细案分摊逻辑
     * @param detailPlanList
     * @param entity
     * @param templateVo
     * @return
     */
    private List<AuditFeeSettlementCheckDetailPlan> doShare(List<AuditFeeSettlementCheckDetailPlan> detailPlanList, AuditFeeSettlementCheck entity, TpmDeductionMatchingTemplateVo templateVo) {
        if (CollectionUtils.isEmpty(detailPlanList)) {
            entity.setDetailPlanAmount(BigDecimal.ZERO);
            entity.setSettlementDetailPlanDiff(entity.getSettlementAmount());
            entity.setMatchActivity(Boolean.FALSE);
            return new ArrayList<>(0);
        }
        log.info("开始分摊的活动：{}", detailPlanList.size());
        log.info("开始分摊的结算核对KEY：{}", entity.getMd5UniqueKey());

        AtomicReference<BigDecimal> beShareAmount = null;
        if (FeeAccordingEnum.INVOICES.getCode().equals(templateVo.getFeeAccording())) {
            beShareAmount = new AtomicReference<>(entity.getSettlementAmount());
        } else if (FeeAccordingEnum.FEE_INVOICE.getCode().equals(templateVo.getFeeAccording())) {
            beShareAmount = new AtomicReference<>(entity.getSettlementFeeDiff());
        } else {
            entity.setMatchActivity(Boolean.TRUE);
            return detailPlanList.stream().peek(e -> e.setRemark("模板扣费依据错误，无法进行金额分摊")).collect(Collectors.toList());
        }
        log.info("开始分摊的扣费依据：{}，分摊金额：{}", templateVo.getFeeAccording(), beShareAmount);

        // 匹配完毕，开始分摊，取可核销金额不为空并排序
        List<AuditFeeSettlementCheckDetailPlan> sortList = detailPlanList.stream().filter(e -> Objects.nonNull(e.getCanAuditAmount())).sorted(Comparator.comparing(AuditFeeSettlementCheckDetailPlan::getDetailPlanItemCode)).collect(Collectors.toList());

        // 分摊
        for (int i = 0; i < sortList.size(); i++) {
            AuditFeeSettlementCheckDetailPlan detailPlan = sortList.get(i);
            BigDecimal canAuditAmount = detailPlan.getCanAuditAmount();
            if (beShareAmount.get().compareTo(BigDecimal.ZERO) > 0) {
                if (beShareAmount.get().compareTo(canAuditAmount) >= 0) {
                    detailPlan.setAuditFeeCheckShareAmount(canAuditAmount);
                    beShareAmount.set(beShareAmount.get().subtract(canAuditAmount));
                } else {
                    detailPlan.setAuditFeeCheckShareAmount(beShareAmount.get());
                    beShareAmount.set(BigDecimal.ZERO);
                }

                // 到了最后一条细案，仍未完成缺口补全，将剩余缺口补充到最后一条细案中，即将未完成的费用全部分摊到当前细案的分摊金额中(活动少了)
                if (i + 1 == sortList.size() && beShareAmount.get().compareTo(BigDecimal.ZERO) > 0) {
                    detailPlan.setAuditFeeCheckShareAmount(beShareAmount.get().add(detailPlan.getAuditFeeCheckShareAmount()));
                    beShareAmount.set(BigDecimal.ZERO);
                }

            } else {
                // 待核销金额缺口 <= 0，不扣减细案
                detailPlan.setAuditFeeCheckShareAmount(BigDecimal.ZERO);
            }

            // 计算待补录金额（元）= 已核销金额（元）+本次扣费金额（元）-申请金额（元）,大于0才有用
            BigDecimal toBeSupplementedAmount = Optional.ofNullable(detailPlan.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO)
                .add(detailPlan.getAuditFeeCheckShareAmount())
                .subtract(Optional.ofNullable(detailPlan.getApplyAmount()).orElse(BigDecimal.ZERO));
            if (toBeSupplementedAmount.compareTo(BigDecimal.ZERO) > 0) {
                detailPlan.setToBeSupplementedAmount(toBeSupplementedAmount);
            }
            if (BusinessUnitEnum.VERTICAL.getCode().equals(entity.getBusinessUnitCode())) {
                // 计算本次核销金额（元）= （申请金额-已核销金额）与本次扣费金额二者中的较小值 (垂直)
                BigDecimal subtract = Optional.ofNullable(detailPlan.getApplyAmount()).orElse(BigDecimal.ZERO)
                    .subtract(Optional.ofNullable(detailPlan.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO));
                detailPlan.setThisAuditAmount(subtract.compareTo(detailPlan.getAuditFeeCheckShareAmount()) < 0 ? subtract : detailPlan.getAuditFeeCheckShareAmount());
            } else {
                detailPlan.setThisAuditAmount(detailPlan.getAuditFeeCheckShareAmount());
            }

            // 累计的情况，分摊完成就退出，不要后续的细案（累计，活动多了）
//            if (StringUtils.equals(BooleanEnum.TRUE.getCapital(), templateVo.getIsAddUpMapping())) {
//                // 待核销金额缺口已补全，后续细案不再扣减
//                if (beShareAmount.get().compareTo(BigDecimal.ZERO) <= 0) {
//                    break;
//                }
//            }
        }
        // 部分细案未使用到，过滤掉
        sortList = sortList.stream().filter(e -> e.getAuditFeeCheckShareAmount() != null).collect(Collectors.toList());
        log.info("分摊完成使用的活动：{}", sortList.size());
        // 主表金额默认为匹配到的活动可核销金额和
        BigDecimal detailPlanAmount = sortList.stream().map(AuditFeeSettlementCheckDetailPlan::getCanAuditAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        entity.setDetailPlanAmount(detailPlanAmount);
        entity.setSettlementDetailPlanDiff(entity.getSettlementAmount().subtract(entity.getDetailPlanAmount()));
        entity.setMatchActivity(Boolean.TRUE);
        return sortList;
    }

    private void matchFee(TpmDeductionMatchingTemplateVo templateVo, TpmDeductionDetailMappingVo mappingVo, AuditFeeSettlementCheck entity, AuditFeeSettlementCheckSettlement settlement) {
        List<TpmDeductionMatchingTemplateAllowanceVo> statementAllowancesList = templateVo.getStatementAllowances();
        List<TpmDeductionMatchingTemplateAllowanceVo> feeAllowanceVoList = templateVo.getFeeAllowances();
        log.info("模板信息：{}",JSONObject.toJSONString(templateVo));

        if (CollectionUtils.isEmpty(statementAllowancesList)) {
            log.info("扣费匹配模板-结算单适用范围缺失");
            return;
        }
        if (CollectionUtils.isEmpty(feeAllowanceVoList)) {
            log.info("扣费匹配模板-费用单适用范围适用范围缺失");
            return;
        }
        List<String> feeAllowancesDateSource = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(feeAllowanceVoList)) {
            feeAllowancesDateSource.addAll(feeAllowanceVoList.stream().map(TpmDeductionMatchingTemplateAllowanceVo::getDataSource).collect(Collectors.toList()));
        }
        AuditFeeReqDto dto = new AuditFeeReqDto();
        // 根据区域匹配费用单容差
        String feeMatchingCondition = templateVo.getFeeMatchingCondition();
        TpmDeductionMatchingTemplateAllowanceVo feeAllowance = null;
        log.info("匹配费用单-费用匹配条件设置:{}", JSON.toJSONString(feeMatchingCondition));
        log.info("匹配费用单-费用容差集合:{}", JSON.toJSONString(feeAllowanceVoList));
        if (feeMatchingCondition.contains(ConditionsEnum.AREA_CODE.getCode())) {
            for (TpmDeductionMatchingTemplateAllowanceVo feeAllowanceVo : feeAllowanceVoList) {
                if (StringUtils.isBlank(feeAllowanceVo.getApplyBusinessAreaCode())) {
                // 配置空/空字符串，匹配上
                feeAllowance = feeAllowanceVo;
                break;
                } else {
                    // 配置为明确区域代码，且核对数据上区域不为空/空字符串，配置区域包含核对数据区域，匹配上
                    if (StringUtils.isNotBlank(settlement.getBusinessArea()) && feeAllowanceVo.getApplyBusinessAreaCode().contains(settlement.getBusinessArea())) {
                        feeAllowance = feeAllowanceVo;
                        break;
                    }
                }
            }
        } else {
            feeAllowance = feeAllowanceVoList.get(0);
        }
        log.info("匹配费用单-匹配的费用容差:{}", JSON.toJSONString(feeAllowance));
        if (feeAllowance == null) {
            log.info("匹配费用单，按区域未找到费用单容差");
            return;
        }
        dto.setDataSource(feeAllowance.getDataSource());
        for (TpmDeductionMatchingTemplateAllowanceVo e : statementAllowancesList) {
            // 如果条件选了区域+年月，校验容差中的区域包含核对数据的区域/容差数据区域配置为空，则使用该容差
            String statementMatchingCondition = templateVo.getStatementMatchingCondition();
            if (statementMatchingCondition.contains(ConditionsEnum.AREA_CODE.getCode()) && statementMatchingCondition.contains(ConditionsEnum.YEAR_MONTH.getCode())) {
                String applyBusinessAreaCode = e.getApplyBusinessAreaCode();
                if (applyBusinessAreaCode != null && !applyBusinessAreaCode.contains(settlement.getBusinessArea())) {
                    continue;
                }
            }

            // 查询KMS 结算单,通过PushMatchedKmsDataToStatementEvent事件返回
            dto.setCostIsMatch(AuditFeeMatchStatusEnum.WITH.getCode());

            dto.setOnlyKey(entity.getMd5UniqueKey());
            dto.setCustomerRetailerCode(mappingVo.getResaleCommercialCode());
            dto.setDemander(AuditFeeConstant.TPM_AUDIT_FEE_STATEMENT_MATCH_COST);
            if (StringUtils.isNotEmpty(templateVo.getStatementMatchingCondition())) {
                List<String> matchSummaryCodes = Arrays.stream(templateVo.getStatementMatchingCondition().split(",")).collect(Collectors.toList());
                dto.setMatchSummaryCondition(matchSummaryCodes);
            }

            dto.setBusinessFormatCode(templateVo.getBusinessFormatCode());
            dto.setBusinessUnitCode(templateVo.getBusinessUnitCode());
            if (!CollectionUtils.isEmpty(mappingVo.getDeductionDetailMappingTextList())) {
                List<String> deductionNames = mappingVo.getDeductionDetailMappingTextList().stream().map(TpmDeductionDetailMappingTextVo::getText).collect(Collectors.toList());
                dto.setDeductionNameList(deductionNames);
            }
            if (!CollectionUtils.isEmpty(mappingVo.getCustomerList())) {
                List<String> customerErpCodeList = mappingVo.getCustomerList().stream().map(TpmDeductionDetailMappingCustomerVo::getErpCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(customerErpCodeList)) {
                    dto.setSoldToPartyCodeList(customerErpCodeList);
                }
            }

            dto.setMatchTemplateCode(templateVo.getCode());
            dto.setMatchTemplateName(templateVo.getName());
            dto.setFeeDataSourceList(feeAllowancesDateSource);

            // 直接用结算核对的查询日期条件
            String queryStartDate = entity.getQueryStartDate();
            String queryEndDate = entity.getQueryEndDate();
            dto.setOrderDateBegin(queryStartDate);
            dto.setOrderDateEnd(queryEndDate);

            String[] conditions = templateVo.getStatementMatchingCondition().split(",");
            for(String condition : conditions){
                ConditionsEnum conditionsEnum = ConditionsEnum.codeToEnum(condition);
                if (ConditionsEnum.EMPTY.equals(conditionsEnum)) continue;
                switch (conditionsEnum){
                    case PRODUCT_CODE:
                        if (null != settlement.getProductCode()) {
                            dto.setProductCode(settlement.getProductCode());
                        }
                        break;
                    case TERMINAL_CODE:
                        if (null != settlement.getDeliveryPartyCode()) {
                            dto.setDeliveryPartyCode(settlement.getDeliveryPartyCode());
                        }
                        break;
                    case YEAR_MONTH:
                        // 结核对存在时，修改模板，重新拉取费用单数据，如果修改了年月，此时应该重新设置年月浮动，但是无法找到年月初始信息（结算核对的年月可能是加工过的），暂时使用结算核对查询时间
                        if (settlement.getOrderYearMonth() != null) {
                            String timeAllowanceType = e.getTimeAllowanceType();
                            if (timeAllowanceType == null){
                                log.error("模板时间容差类型配置错误;");
                                break;
                            }
                            // 年月需要考虑容差，但是时间类型必须为月 ,APPOINT_DATE类型不需要TimeAllowanceUnit、timeAllowanceValue
                            if (!TpmDeductionMatchingTemplateEnums.AllowanceType.APPOINT_DATE.getValue().equals(e.getTimeAllowanceType())
                                && !TpmDeductionMatchingTemplateEnums.AllowanceUnit.MONTH.getValue().equals(e.getTimeAllowanceUnit())) {
                                log.error("适用范围日期类型异常");
                                break;
                            }
                            Integer timeAllowanceValue = e.getTimeAllowanceValue();
                            if (!TpmDeductionMatchingTemplateEnums.AllowanceType.APPOINT_DATE.getValue().equals(e.getTimeAllowanceType()) && timeAllowanceValue == null) {
                                log.error("模板时间容差值配置错误;");
                                break;
                            }
                            String orderDate = settlement.getOrderDate();
                            if (TpmDeductionMatchingTemplateEnums.AllowanceType.POSITIVE.getValue().equals(timeAllowanceType)) {
                                // 向未来加月并设置月末
                                dto.setOrderDateBegin(this.adjustMonth(orderDate, 0, true));
                                dto.setOrderDateEnd(this.adjustMonth(orderDate, timeAllowanceValue, false));
                            } else if (TpmDeductionMatchingTemplateEnums.AllowanceType.POSITIVE_POINT.getValue().equals(timeAllowanceType)) {
                                // 向未来加月并设置起始时间为目标月
                                dto.setOrderDateBegin(this.adjustMonth(orderDate, timeAllowanceValue, true));
                                dto.setOrderDateEnd(this.adjustMonth(orderDate, timeAllowanceValue, false));
                            } else if (TpmDeductionMatchingTemplateEnums.AllowanceType.NEGATIVE.getValue().equals(timeAllowanceType)) {
                                // 向历史加月并设置月初
                                dto.setOrderDateBegin(this.adjustMonth(orderDate, - timeAllowanceValue, true));
                                dto.setOrderDateEnd(this.adjustMonth(orderDate, 0, false));
                            } else if (TpmDeductionMatchingTemplateEnums.AllowanceType.NEGATIVE_POINT.getValue().equals(timeAllowanceType)) {
                                // 向历史加月并设置起始时间为目标月
                                dto.setOrderDateBegin(this.adjustMonth(orderDate, - timeAllowanceValue, true));
                                dto.setOrderDateEnd(this.adjustMonth(orderDate, - timeAllowanceValue, false));
                            } else if (TpmDeductionMatchingTemplateEnums.AllowanceType.INTEGER.getValue().equals(timeAllowanceType)) {
                                // 向未来，历史加月并设置起始时间为目标月
                                dto.setOrderDateBegin(this.adjustMonth(orderDate, - timeAllowanceValue, true));
                                dto.setOrderDateEnd(this.adjustMonth(orderDate, timeAllowanceValue, false));
                            } else if (TpmDeductionMatchingTemplateEnums.AllowanceType.APPOINT_DATE.getValue().equals(timeAllowanceType)) {
                                // 指定区间
                                if (e.getBeginDate() == null || e.getEndDate() == null) {
                                    log.info("模板时间容差指定区间配置错误;");
                                    break;
                                }
                                dto.setOrderDateBegin(this.adjustMonth(e.getBeginDate()+"-01", 0, true));
                                dto.setOrderDateEnd(this.adjustMonth(e.getEndDate()+"-01", 0, false));
                            } else {
                                break;
                            }
                        }
                        break;
                    case PROVINCE:
                        if (null != settlement.getProvinceCode()) {
                            dto.setProvinceCode(settlement.getProvinceCode());
                        }
                        break;
                    case AREA_CODE:
                        if (null != settlement.getBusinessArea()) {
                            dto.setBusinessArea(settlement.getBusinessArea());
                        }
                        break;
                    case ACTIVITY_FORM_DESC:
                        if (null != settlement.getActivityFormDesc()) {
                            dto.setActivityFormDesc(settlement.getActivityFormDesc());
                        }
                        break;
                    case SCHEDULE:
                    case FEE_CODE:
                    case FEE_ITEM_CODE:
                    case CHANNEL:
                    default:
                        break;
                }
            }

            log.info("匹配费用单入参：{}",JSONObject.toJSONString(dto));
            this.auditFeeStatementService.statementMatchFeeByConditions(dto);
            break;
        }
    }

    private void generateSettlement(TpmDeductionMatchingTemplateVo templateVo, TpmDeductionDetailMappingVo mappingVo, AuditFeeSettlementCheckFindFeeDto queryDto) {
        List<TpmDeductionMatchingTemplateAllowanceVo> statementAllowancesList = templateVo.getStatementAllowances();
        List<TpmDeductionMatchingTemplateAllowanceVo> feeAllowanceVoList = templateVo.getFeeAllowances();
        log.info("模板信息：{}",JSONObject.toJSONString(templateVo));
        log.info("映射信息：{}",JSONObject.toJSONString(mappingVo));
        if (CollectionUtils.isEmpty(statementAllowancesList)) {
            log.info("扣费匹配模板-结算单适用范围缺失");
            return;
        }
        List<String> feeAllowancesDateSource = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(feeAllowanceVoList)) {
            feeAllowancesDateSource.addAll(feeAllowanceVoList.stream().map(TpmDeductionMatchingTemplateAllowanceVo::getDataSource).collect(Collectors.toList()));
        }
        Map<String, TpmDeductionMatchingTemplateAllowanceVo> statementAllowanceMap = statementAllowancesList.stream().collect(Collectors.toMap(e -> e.getDataSource() + "_" + e.getApplyBusinessAreaCode(), Function.identity(), (a,b) -> a));
        log.info("拉取结算单模板去重容差:{}个数:{}", JSON.toJSONString(statementAllowanceMap.keySet()), statementAllowanceMap.size());
        statementAllowanceMap.forEach((k,v) -> {
            // 查询KMS 结算单,通过PushMatchedKmsDataToStatementEvent事件返回
            AuditFeeReqDto dto = new AuditFeeReqDto();
            dto.setStatementIsMatch(AuditFeeMatchStatusEnum.WITH.getCode());
            if (Objects.nonNull(queryDto)) {
                dto.setOrderDateBegin(DateFormatUtils.format(queryDto.getStartDate(),"yyyy-MM-dd"));
                dto.setOrderDateEnd(DateFormatUtils.format(queryDto.getEndDate(),"yyyy-MM-dd"));
                dto.setDeliveryPartyCode(queryDto.getTerminalCode());
            } else {
                //                dto.setOrderDateBegin(this.getLastMonthStartDate());
                //                dto.setOrderDateEnd(this.getLastMonthEndDate());

                // 默认时间范围[前两月,当前时间]
                DateTime lastTwoMonth = cn.hutool.core.date.DateUtil.offsetMonth(new DateTime(), -2);
                dto.setOrderDateBegin(DateFormatUtils.format(DateUtil.getFirstDayOfMonth(lastTwoMonth),"yyyy-MM-dd"));
                dto.setOrderDateEnd(DateFormatUtils.format(DateUtil.getFirstDayOfMonth(new Date()),"yyyy-MM-dd"));
            }
            dto.setCustomerRetailerCode(mappingVo.getResaleCommercialCode());
            dto.setDemander(AuditFeeConstant.TPM_AUDIT_FEE_STATEMENT);
            if (StringUtils.isNotEmpty(templateVo.getStatementMatchingCondition())) {
                List<String> matchSummaryCodes = Arrays.stream(templateVo.getStatementMatchingCondition().split(",")).collect(Collectors.toList());
                dto.setMatchSummaryCondition(matchSummaryCodes);
            }

            dto.setBusinessFormatCode(templateVo.getBusinessFormatCode());
            dto.setBusinessUnitCode(templateVo.getBusinessUnitCode());
            if (!CollectionUtils.isEmpty(mappingVo.getDeductionDetailMappingTextList())) {
                List<String> deductionNames = mappingVo.getDeductionDetailMappingTextList().stream().map(TpmDeductionDetailMappingTextVo::getText).collect(Collectors.toList());
                dto.setDeductionNameList(deductionNames);
            }
            if (!CollectionUtils.isEmpty(mappingVo.getCustomerList())) {
                List<String> customerErpCodeList = mappingVo.getCustomerList().stream().map(TpmDeductionDetailMappingCustomerVo::getErpCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(customerErpCodeList)) {
                    dto.setSoldToPartyCodeList(customerErpCodeList);
                }
            }
            dto.setMatchTemplateCode(templateVo.getCode());
            dto.setMatchTemplateName(templateVo.getName());
            dto.setFeeDataSourceList(feeAllowancesDateSource);

            dto.setDataSource(v.getDataSource());
            String[] areaArray = null;
            if (StringUtils.isNotBlank(v.getApplyBusinessAreaCode())) {
                areaArray = v.getApplyBusinessAreaCode().split(",");
            } else {
                areaArray = new String[1];
                areaArray[0] = null;
            }
            for (String areaCode : areaArray) {
                dto.setBusinessArea(areaCode);
                log.info("查询结算单入参：{}",JSONObject.toJSONString(dto));
                this.auditFeeStatementService.matchByConditions(dto);
            }
        });
    }

    /**
     * 月浮动及起始天
     * @param dateStr
     * @param span
     * @param begin 是否月初
     * @return
     */
    public String adjustMonth(String dateStr, Integer span, boolean begin) {
        DateTime adjustedDate = cn.hutool.core.date.DateUtil.offsetMonth(DateUtil.parse(dateStr, "yyyy-MM-dd"), span);
        DateTime headOrTail;
        if (begin) headOrTail = cn.hutool.core.date.DateUtil.beginOfDay(cn.hutool.core.date.DateUtil.beginOfMonth(adjustedDate));
        else headOrTail = cn.hutool.core.date.DateUtil.endOfDay(cn.hutool.core.date.DateUtil.endOfMonth(adjustedDate));
        return cn.hutool.core.date.DateUtil.format(headOrTail,"yyyy-MM-dd HH:mm:ss");
    }

    /**
     * 上个月第一天
     * @return
     */
    private String getLastMonthStartDate(){
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.MONTH,-1);
        calendar.set(Calendar.DAY_OF_MONTH,1);
        return DateFormatUtils.format(calendar.getTime(),"yyyy-MM-dd");
    }
    /**
     * 上个月最后一天
     * @return
     */
    private String getLastMonthEndDate(){
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(Calendar.MONTH);
        calendar.set(Calendar.MONTH,month-1);
        calendar.set(Calendar.DAY_OF_MONTH,calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
        return DateFormatUtils.format(calendar.getTime(),"yyyy-MM-dd");
    }



    /**
     * 更新KMS 结算单/费用单状态
     * @param tpmDeductionCodeList 结算单/费用单编码，含行号
     * @param statementIsMatch 结算单已使用
     * @param costIsMatch 费用单已使用
     */
    private void updateKMSStatus(List<String> tpmDeductionCodeList, String statementIsMatch, String costIsMatch){
        if (CollectionUtils.isEmpty(tpmDeductionCodeList)) return;
        // 只打已确认标记
        if (StringUtils.equalsAny(AuditFeeMatchStatusEnum.CONFIRM.getCode(), statementIsMatch, costIsMatch)) {
            AuditFeeReqDto reqDto = new AuditFeeReqDto();
            reqDto.setTpmDeductionCodeList(tpmDeductionCodeList);
            reqDto.setStatementIsMatch(statementIsMatch);
            reqDto.setCostIsMatch(costIsMatch);
            String dataSource = null;
            if (statementIsMatch != null) {
                AuditFeeSettlementCheckSettlement settlement = auditFeeSettlementCheckSettlementRepository.findByDetailCode(tpmDeductionCodeList.get(0));
                if (settlement != null) dataSource = settlement.getDataSource();
            } else if (costIsMatch != null) {
                AuditFeeSettlementCheckFee fee = auditFeeSettlementCheckFeeRepository.findByDetailCode(tpmDeductionCodeList.get(0));
                if (fee != null) dataSource = fee.getDataSource();
            }
            reqDto.setDataSource(dataSource);
            log.info("结算核对-更新KMS结算单/费用单状态参数：{}", JSON.toJSONString(reqDto));
            kmsFeeUpdateAsync.updateKMSStatusAsync(reqDto);
        }
    }
}
