package com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.page.cache.constant.MnPageCacheConstant;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.constant.ActivityDetailPlanConstant;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckSettlement;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckSettlementRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckSettlementService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckSettlementDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckSettlementVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

@Slf4j
@Service
public class AuditFeeSettlementCheckSettlementServiceImpl extends MnPageCacheServiceImpl<AuditFeeSettlementCheckSettlementVo,AuditFeeSettlementCheckSettlementDto> implements AuditFeeSettlementCheckSettlementService {

    @Autowired
    private RedisService redisService;
    @Autowired
    private AuditFeeSettlementCheckSettlementRepository auditFeeSettlementCheckSettlementRepository;

    @Override
    public Page<AuditFeeSettlementCheckSettlementVo> findByConditions(Pageable pageable, AuditFeeSettlementCheckSettlementDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        Page<AuditFeeSettlementCheckSettlementVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        dto = Optional.ofNullable(dto).orElse(new AuditFeeSettlementCheckSettlementDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.auditFeeSettlementCheckSettlementRepository.findByConditions(page,dto);
    }

    @Override
    public AuditFeeSettlementCheckSettlementVo findById(String id) {
        Validate.notEmpty(id,"参数错误");
        AuditFeeSettlementCheckSettlement entity = this.auditFeeSettlementCheckSettlementRepository.getById(id);
        Validate.notNull(entity,"未找到结算单信息");
        // TODO: 2023/9/27 应根据编码去kms取值
        AuditFeeSettlementCheckSettlementVo vo = this.findInfoFromKms(entity.getSettlementDetailCode());
        Validate.notNull(vo,"未从kms找到结算单信息");
        return vo;
    }

    /**
     * 批量删除
     * @param ids
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        Validate.notEmpty(ids,"参数错误");
        List<AuditFeeSettlementCheckSettlement> list = this.auditFeeSettlementCheckSettlementRepository.listByIds(ids);
        Validate.notEmpty(list,"未找到结算单信息");
        this.auditFeeSettlementCheckSettlementRepository.removeByIds(ids);
    }

    /**
     * 从kms查询
     * @param settlementDetailCode
     * @return
     */
    private AuditFeeSettlementCheckSettlementVo findInfoFromKms(String settlementDetailCode) {
        return new AuditFeeSettlementCheckSettlementVo();
    }

    /**
     * 获取总条数
     *
     * @param cacheKey 缓存key
     * @return Integer
     */
    @Override
    public Integer getTotal(String cacheKey) {
        return redisService.lSize(this.helper.getRedisCacheIdKey(cacheKey)).intValue();
    }
}
