package com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.internal;

import com.alibaba.excel.util.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.kms.business.audit.fee.sdk.dto.AuditFeeReqDto;
import com.biz.crm.kms.business.audit.fee.sdk.enums.AuditFeeMatchStatusEnum;
import com.biz.crm.kms.business.audit.fee.sdk.service.cost.AuditFeeCostService;
import com.biz.crm.kms.business.invoice.expense.sheet.sdk.dto.InvoiceExpenseSheetDto;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckUpdateMatched;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckUpdateMatchedRepository;
import com.biz.crm.tpm.business.audit.fee.local.service.settlement.check.AuditFeeSettlementCheckUpdateMatchedService;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeSettlementConstant;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.auditFeeVerifyDecide.AuditFeeVerifyDecideVo;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/11/26
 */
@Service
@Slf4j
public class AuditFeeSettlementCheckUpdateMatchedServiceImpl implements AuditFeeSettlementCheckUpdateMatchedService {

    @Autowired(required = false)
    private AuditFeeSettlementCheckUpdateMatchedRepository updateMatchedRepository;

    @Autowired(required = false)
    private AuditFeeCostService auditFeeCostService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Override
    @DynamicTaskService(cornExpression = "0 0 7 * * ?", taskDesc = "定时更新结算单匹配状态")
    public void autoUpdateMatchedStatus() {
        loginUserService.refreshAuthentication(null);
        String date = DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        boolean lock = false;
        try {
            lock = redisLockService.tryLock(AuditFeeSettlementConstant.SETTLEMENT_CACHE_UPDATE_MATCHED_LOCK + date, TimeUnit.HOURS, 2);
            if (!lock) {
                throw new RuntimeException("任务正在执行中...");
            }
            this.updateMatchedStatus(date, AuditFeeMatchStatusEnum.MATCH.getCode());
        } catch (Exception e) {
            log.info("定时更新结算单匹配状态失败");
            e.printStackTrace();
            throw e;
        } finally {
            if (lock) {
                redisLockService.unlock(AuditFeeSettlementConstant.SETTLEMENT_CACHE_UPDATE_MATCHED_LOCK + date);
            }
        }
    }

    @Override
    public void updateMatchedStatus(String date, String status) {
        if (StringUtils.isBlank(date) || StringUtils.isBlank(status)) {
            return;
        }
        PageRequest pageable = PageRequest.of(1, 1000);
        Page<AuditFeeSettlementCheckUpdateMatched> pageResult = null;

        do {
            pageResult = updateMatchedRepository.findByCondition(pageable, date);
            if (!CollectionUtils.isEmpty(pageResult.getRecords())) {
                Map<String, List<AuditFeeSettlementCheckUpdateMatched>> updateMap = pageResult.getRecords().stream().filter(f-> StringUtils.isNotBlank(f.getDataSource())).collect(Collectors.groupingBy(AuditFeeSettlementCheckUpdateMatched::getDataSource));
                for (String key : updateMap.keySet()) {
                    List<AuditFeeSettlementCheckUpdateMatched> updateMatchedList = updateMap.get(key);
                    List<String> tpmDeductionCodeList = updateMatchedList.stream().map(AuditFeeSettlementCheckUpdateMatched::getTpmDeductionCode).filter(Objects::nonNull).collect(Collectors.toList());
                    AuditFeeReqDto updateDto = new AuditFeeReqDto();
                    updateDto.setTpmDeductionCodeList(tpmDeductionCodeList);
                    updateDto.setDataSource(key);
                    updateDto.setStatementIsMatch(status);
                    auditFeeCostService.updateStatus(updateDto);
                }
            }
            pageable = pageable.next();

        } while (pageResult.hasNext() && pageable.getPageNumber() < AuditFeeSettlementConstant.LOOP_TIMES_MAX);
    }

    @Override
    @DynamicTaskService(cornExpression = "0 0 4 ? * 7", taskDesc = "结算单匹配数据临时表,每周7天定时删除一次6天已前的数据")
    public void clearData() {
        loginUserService.refreshAuthentication(null);
        String date = DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        boolean lock = false;
        try {
            lock = redisLockService.tryLock(AuditFeeSettlementConstant.SETTLEMENT_CACHE_UPDATE_MATCHED_LOCK + date, TimeUnit.HOURS, 2);
            if (!lock) {
                throw new RuntimeException("任务正在执行中...");
            }
            this.deleteMatchedData(date);
        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        } finally {
            if (lock) {
                redisLockService.unlock(AuditFeeSettlementConstant.SETTLEMENT_CACHE_UPDATE_MATCHED_LOCK + date);
            }
        }
    }

    private void deleteMatchedData(String date) {
        if (StringUtils.isBlank(date)) {
            return;
        }
        this.updateMatchedRepository.deleteMatchedData(date);
    }

}
