package com.biz.crm.tpm.business.audit.fee.local.template.controller;


import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateSelectDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.service.TpmDeductionMatchingTemplateService;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * TPM-扣费匹配模板(TpmDeductionMatchingTemplate)表相关的http接口
 *
 * @author duyiran
 * @since 2022-11-11 09:57:00
 */
@RestController
@RequestMapping("/v1/tpmDeductionMatchingTemplate")
@Slf4j
@Api(tags = "TPM-扣费匹配模板")
public class TpmDeductionMatchingTemplateController {

    /**
     * 服务对象
     */
    @Autowired(required = false)
    private TpmDeductionMatchingTemplateService tpmDeductionMatchingTemplateService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<TpmDeductionMatchingTemplateVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                         @ApiParam(name = "dto", value = "TPM-扣费匹配模板") TpmDeductionMatchingTemplateDto dto) {
        try {
            Page<TpmDeductionMatchingTemplateVo> page = this.tpmDeductionMatchingTemplateService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分页查询模板信息，更据适用的零售商（商超）、适用客户过滤
     *
     * @param pageable
     * @param dto
     * @return
     */
    @ApiOperation(value = "分页查询所有数据--更据适用的零售商（商超）、适用客户过滤")
    @GetMapping("findByConditionsWithResaleCommercial")
    public Result<Page<TpmDeductionMatchingTemplateVo>> findByConditionsWithResaleCommercial(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                         @ApiParam(name = "dto", value = "TPM-扣费匹配模板") TpmDeductionMatchingTemplateSelectDto dto) {
        try {
            Page<TpmDeductionMatchingTemplateVo> page = this.tpmDeductionMatchingTemplateService.findByConditionsWithResaleCommercial(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<TpmDeductionMatchingTemplateVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
        try {
            TpmDeductionMatchingTemplateVo tpmDeductionMatchingTemplate = this.tpmDeductionMatchingTemplateService.findById(id);
            return Result.ok(tpmDeductionMatchingTemplate);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param dto dto
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<TpmDeductionMatchingTemplateVo> create(@ApiParam(name = "dto", value = "TPM-扣费匹配模板") @RequestBody TpmDeductionMatchingTemplateDto dto) {
        try {
            TpmDeductionMatchingTemplateVo result = this.tpmDeductionMatchingTemplateService.create(dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param dto dto
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping("update")
    public Result<TpmDeductionMatchingTemplateVo> update(@ApiParam(name = "dto", value = "TPM-扣费匹配模板") @RequestBody TpmDeductionMatchingTemplateDto dto) {
        try {
            TpmDeductionMatchingTemplateVo result = this.tpmDeductionMatchingTemplateService.update(dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @ApiOperation(value = "删除数据")
    @DeleteMapping
    public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam("idList") List<String> idList) {
        try {
            this.tpmDeductionMatchingTemplateService.delete(idList);
            return Result.ok("删除成功！");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用数据
     *
     * @param idList 主键结合
     * @return 禁用数据
     */
    @ApiOperation(value = "禁用数据")
    @PatchMapping("disable")
    public Result<?> disable(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
        try {
            this.tpmDeductionMatchingTemplateService.disableOrEnable(idList, EnableStatusEnum.DISABLE.getCode());
            return Result.ok("禁用成功！");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用数据
     *
     * @param idList 主键结合
     * @return 启用数据
     */
    @ApiOperation(value = "启用数据")
    @PatchMapping("enable")
    public Result<?> enable(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
        try {
            this.tpmDeductionMatchingTemplateService.disableOrEnable(idList, EnableStatusEnum.ENABLE.getCode());
            return Result.ok("启用成功！");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
