package com.biz.crm.tpm.business.audit.fee.local.template.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.*;
import java.util.List;

/**
 * 扣费匹配模板 实体
 *
 * @author duyiran
 * @create 2022-11-07 17:42
 */
@Data
@TableName("tpm_deduction_matching_template")
@Entity(name = "tpm_deduction_matching_template")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmDeductionMatchingTemplate", description = "TPM-扣费匹配模板")
@org.hibernate.annotations.Table(appliesTo = "tpm_deduction_matching_template", comment = "TPM-扣费匹配模板")
@Table(name = "tpm_deduction_matching_template",
        indexes = {
        @Index(name = "tpm_deduction_matching_template_index1", columnList = "del_flag,tenant_code,enable_status,code", unique = true),
        @Index(name = "tpm_deduction_matching_template_index2", columnList = "create_time,id", unique = false)
})
public class TpmDeductionMatchingTemplate extends TenantFlagOpEntity {

    /**
     * 编码
     */
    @ApiModelProperty(name = "编码", notes = "编码")
    @Column(name = "code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '编码'")
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(name = "名称", notes = "名称")
    @Column(name = "name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '名称'")
    private String name;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
    @Column(name = "sales_org_code",  length = 32, columnDefinition = "VARCHAR(128) COMMENT '销售组织编码'")
    private String salesOrgCode;

    /**
     * 销售组织erp编码
     */
    @ApiModelProperty(name = "销售组织erp编码", notes = "销售组织erp编码")
    @Column(name = "sales_org_erp_code",  length = 32, columnDefinition = "VARCHAR(128) COMMENT '销售组织erp编码'")
    private String salesOrgErpCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sales_org_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称'")
    private String salesOrgName;


    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "销售机构编码", notes = "销售机构编码")
    @Column(name = "sales_institution_code",  length = 32, columnDefinition = "VARCHAR(128) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 销售组织erp编码
     */
    @ApiModelProperty(name = "销售机构ERP编码", notes = "销售机构ERP编码")
    @Column(name = "sales_institution_erp_code",  length = 32, columnDefinition = "VARCHAR(128) COMMENT '销售机构ERP编码'")
    private String salesInstitutionErpCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty(name = "销售机构名称", notes = "销售机构名称")
    @Column(name = "sales_institution_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    /**
     * 扣费匹配模板类型[数据字典:tpm_deduction_matching_template_type]
     */
    @ApiModelProperty(name = "扣费匹配模板[数据字典:tpm_deduction_matching_template_type]", notes = "扣费匹配模板类型[数据字典:tpm_deduction_matching_template_type]")
    @Column(name = "deduction_matching_template_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '扣费匹配模板[数据字典:tpm_deduction_matching_template_type] '")
    private String deductionMatchingTemplateType;

    /**
     * 费用单匹配条件设置[数据字典:tpm_deduction_matching_template_type]
     */
    @ApiModelProperty(name = "费用单匹配条件设置[数据字典:tpm_deduction_matching_condition]", notes = "匹配条件设置[数据字典:tpm_deduction_matching_condition]")
    @Column(name = "fee_matching_condition", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '匹配条件设置[数据字典:tpm_deduction_matching_condition] '")
    private String feeMatchingCondition;

    /**
     * 结算单匹配条件设置[数据字典:tpm_deduction_matching_template_type]
     */
    @ApiModelProperty(name = "结算单匹配条件设置[数据字典:tpm_deduction_matching_condition]", notes = "匹配条件设置[数据字典:tpm_deduction_matching_condition]")
    @Column(name = "statement_matching_condition", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '匹配条件设置[数据字典:tpm_deduction_matching_condition] '")
    private String statementMatchingCondition;

    @ApiModelProperty(name = "扣费依据[数据字典:]", notes = "扣费依据[数据字典:]")
    @Column(name = "fee_according", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '扣费依据[数据字典:] '")
    private String feeAccording;

    /**
     * 是否累计匹配[数据字典:yesOrNo]
     */
    @ApiModelProperty(name = "是否累计匹配[数据字典:yesOrNo]", notes = "是否累计匹配[数据字典:yesOrNo]")
    @Column(name = "is_add_up_mapping", length = 1, columnDefinition = "VARCHAR(10) COMMENT '是否累计匹配[数据字典:yesOrNo]'")
    private String isAddUpMapping;

    /**
     * 适用映射编码
     */
    @ApiModelProperty(name = "适用映射编码", notes = "适用映射编码")
    @Column(name = "apply_mapping_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '适用映射编码'")
    private String applyMappingCode;

    /**
     * 适用映射名称
     */
    @ApiModelProperty(name = "适用映射名称", notes = "适用映射名称")
    @Column(name = "apply_mapping_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '适用映射名称'")
    private String applyMappingName;

    /**
     * 零售商编码
     */
    @ApiModelProperty(name = "零售商编码", notes = "零售商编码")
    @Column(name = "resale_commercial_code", length = 32,columnDefinition = "VARCHAR(32) COMMENT '零售商编码'")
    private String resaleCommercialCode;

    /**
     * 零售商名称
     */
    @ApiModelProperty(name = "零售商名称", notes = "零售商名称")
    @Column(name = "resale_commercial_name", columnDefinition = "VARCHAR(255) COMMENT '零售商名称'")
    private String resaleCommercialName;

    /**
     * 适用业务客户编码
     */
    @ApiModelProperty(name ="适用业务客户编码",notes = "适用业务客户编码")
    @Column(name = "apply_business_customer_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '适用业务客户编码'")
    private String applyBusinessCustomerCode;

    /**
     * 适用业务客户名称
     */
    @ApiModelProperty(name ="适用业务客户名称",notes = "适用业务客户名称")
    @Column(name = "apply_business_customer_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '适用业务客户名称'")
    private String applyBusinessCustomerName;

    @Transient
    @TableField(exist = false)
    @ApiModelProperty("扣费匹配模板-容差")
    List<TpmDeductionMatchingTemplateAllowance> allowances;

}
