package com.biz.crm.tpm.business.audit.fee.local.template.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 扣费匹配模板-容差 子表实体
 *
 * @author duyiran
 * @create 2022-11-10 16:41
 */
@Data
@TableName("tpm_deduction_matching_template_allowance")
@Entity(name = "tpm_deduction_matching_template_allowance")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmDeductionMatchingTemplateAllowance", description = "TPM-扣费匹配模板-容差")
@org.hibernate.annotations.Table(appliesTo = "tpm_deduction_matching_template_allowance", comment = "TPM-扣费匹配模板-容差")
@Table(name = "tpm_deduction_matching_template_allowance",
        indexes = {
        @Index(name = "tpm_deduction_matching_template_allowance_index1", columnList = "deduction_unique_key", unique = true),
        @Index(name = "tpm_deduction_matching_template_allowance_index2", columnList = "code", unique = false),
})
public class TpmDeductionMatchingTemplateAllowance extends TenantFlagOpEntity {

    /**
     * 主表编码
     */
    @ApiModelProperty(name = "主表编码", notes = "主表编码")
    @Column(name = "code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '主表编码'")
    private String code;

    /**
     * 容差类型
     */
    @ApiModelProperty(name = "容差类型", notes = "容差类型")
    @Column(name = "allowance_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '容差类型'")
    private String allowanceType;

    /**
     * 数据来源
     */
    @ApiModelProperty(name = "数据来源", notes = "数据来源")
    @Column(name = "data_source", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据来源'")
    private String dataSource;


    /**
     * 适用业务区域编码
     */
    @ApiModelProperty(name ="适用业务区域编码",notes = "适用业务区域编码")
    @Column(name = "apply_business_area_code",  length = 255, columnDefinition = "VARCHAR(255) COMMENT '适用业务区域编码'")
    private String applyBusinessAreaCode;

    /**
     * 适用业务区域名称
     */
    @ApiModelProperty(name ="适用业务区域名称",notes = "适用业务区域名称")
    @Column(name = "apply_business_area_name",  length = 255, columnDefinition = "VARCHAR(10) COMMENT '适用业务区域名称'")
    private String applyBusinessAreaName;

    /**
     * 适用映射编码
     */
    @ApiModelProperty(name ="适用映射编码",notes = "适用映射编码")
    @Column(name = "apply_mapping_code", length = 32, columnDefinition = "VARCHAR(10) COMMENT '适用映射编码'")
    private String applyMappingCode;

    /**
     * 适用映射名称
     */
    @ApiModelProperty(name ="适用映射名称",notes = "适用映射名称")
    @Column(name = "apply_mapping_name", length = 255, columnDefinition = "VARCHAR(10) COMMENT '适用映射名称'")
    private String applyMappingName;

    /**
     * 时间容差[数据字典:tpm_deduction_matching_allowance_type]
     */
    @ApiModelProperty(name = "时间容差[数据字典:tpm_deduction_matching_allowance_type]", notes = "时间容差[数据字典:tpm_deduction_matching_allowance_type]")
    @Column(name = "time_allowance_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '时间容差[数据字典:tpm_deduction_matching_allowance_type]'")
    private String timeAllowanceType;

    /**
     * 时间容差类型[数据字典:tpm_deduction_matching_time_allowance_unit]
     */
    @ApiModelProperty(name = "时间容差类型[数据字典:tpm_deduction_matching_time_allowance_unit]", notes = "时间容差类型[数据字典:tpm_deduction_matching_time_allowance_unit]")
    @Column(name = "time_allowance_unit", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT '时间容差类型[数据字典:tpm_deduction_matching_time_allowance_unit]'")
    private String timeAllowanceUnit;

    /**
     * 时间容差值
     */
    @ApiModelProperty(name = "时间容差值", notes = "时间容差值")
    @Column(name = "time_allowance_value", nullable = true, columnDefinition = "int(8) COMMENT '时间容差值'")
    private Integer timeAllowanceValue;




    /**
     * 唯一键（适用零售商+适用客户+适用映射+匹配模板编码）
     */
    @ApiModelProperty(name = "deductionUniqueKey",value = "唯一键（适用零售商+适用客户+适用映射+匹配模板编码）",notes = "唯一键（适用零售商+适用客户+适用映射+匹配模板编码）")
    @Column(name = "deduction_unique_key",  length = 225, columnDefinition = "VARCHAR(225) COMMENT '唯一键（适用零售商+适用客户+适用映射+匹配模板编码）'")
    private String deductionUniqueKey;

    @ApiModelProperty("指定时间范围-开始(yyyy-MM)")
    @Column(name = "begin_date", nullable = true, length = 20, columnDefinition = "VARCHAR(20) COMMENT '指定时间范围-开始'")
    private String beginDate;

    @ApiModelProperty("指定时间范围-结束(yyyy-MM)")
    @Column(name = "end_date", nullable = true, length = 20,  columnDefinition = "VARCHAR(20) COMMENT '指定时间范围-结束'")
    private String endDate;
}
