package com.biz.crm.tpm.business.audit.fee.local.template.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/9/15
 */
@Data
@TableName("tpm_deduction_matching_template_rules")
@Entity(name = "tpm_deduction_matching_template_rules")
@ApiModel(value = "TpmDeductionMatchingTemplateRules", description = "TPM-扣费匹配模板-取值公式")
@org.hibernate.annotations.Table(appliesTo = "tpm_deduction_matching_template_rules", comment = "TPM-扣费匹配模板-取值公式")
@Table(name = "tpm_deduction_matching_template_rules", indexes = {@Index(name = "tpm_deduction_matching_template_rules_index1", columnList = "code", unique = false)})
public class TpmDeductionMatchingTemplateRules extends TenantFlagOpEntity {


    /**
     * 主表编码
     */
    @ApiModelProperty(name = "主表编码", notes = "主表编码")
    @Column(name = "code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '主表编码'")
    private String code;

    @Column(name = "formula_code" ,   columnDefinition = "VARCHAR(500) COMMENT '公式'")
    @ApiModelProperty("公式")
    private String formulaCode;

    @Column(name = "formula_name" ,   columnDefinition = "VARCHAR(500) COMMENT '公式（展示用）'")
    @ApiModelProperty("公式（展示用）")
    private String formulaName;

    @Column(name = "formula_json" ,   columnDefinition = "VARCHAR(500) COMMENT '公式json'")
    @ApiModelProperty("公式json")
    private String formulaJson;
}
