package com.biz.crm.tpm.business.audit.fee.local.template.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.audit.fee.local.template.entity.TpmDeductionMatchingTemplateAllowance;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateAllowanceDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateAllowanceVo;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateSelectVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * TPM-扣费匹配模板-容差(TpmDeductionMatchingTemplateAllowance)表mybatis访问层
 *
 * @author duyiran
 * @since 2022-11-11 09:58:42
 */
public interface TpmDeductionMatchingTemplateAllowanceMapper extends BaseMapper<TpmDeductionMatchingTemplateAllowance> {

    /**
     * 根据code查询容差
     *
     * @param code
     * @return
     */
    List<TpmDeductionMatchingTemplateAllowanceVo> findByCode(@Param("code") String code, @Param("tenantCode") String tenantCode);

    /**
     * 根据codeList查询容差
     *
     * @param codeList
     * @return
     */
    List<TpmDeductionMatchingTemplateAllowanceVo> findByCodeList(@Param("codeList") List<String> codeList);

    /**
     * 查询所有的‘适用映射编码’
     * @param tenantCode
     * @return
     */
    List<TpmDeductionMatchingTemplateSelectVo> findAllApplyMappingCode(@Param("tenantCode") String tenantCode);

    /**
     * 根据隐射编码 获取明细信息
     * @param allowanceDto
     * @param tenantCode
     * @return
     */
    List<TpmDeductionMatchingTemplateAllowanceVo> findListAnywayByCodeOrCodes(@Param("dto") TpmDeductionMatchingTemplateAllowanceDto allowanceDto,@Param("tenantCode") String tenantCode);

}

