package com.biz.crm.tpm.business.audit.fee.local.template.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.tpm.business.audit.fee.local.template.entity.TpmDeductionMatchingTemplate;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateSelectDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * TPM-扣费匹配模板(TpmDeductionMatchingTemplate)表mybatis访问层
 *
 * @author duyiran
 * @since 2022-11-11 09:57:10
 */
public interface TpmDeductionMatchingTemplateMapper extends BaseMapper<TpmDeductionMatchingTemplate> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param dto  查询dto
     * @return 所有数据
     */
    Page<TpmDeductionMatchingTemplateVo> findByConditions(@Param("page") Page<TpmDeductionMatchingTemplateVo> page, @Param("dto") TpmDeductionMatchingTemplateDto dto);

    /**
     * 根据编码查询数据(不分页)
     *
     * @param dto dto
     * @return
     */
    List<TpmDeductionMatchingTemplateVo> findAllListByConditions(@Param("dto") TpmDeductionMatchingTemplateDto dto);

    /**
     * 分页查询模板信息，更据适用的零售商（商超）、适用客户过滤
     *
     * @param page
     * @param dto
     * @return
     */
    Page<TpmDeductionMatchingTemplateVo> findByConditionsWithResaleCommercial(@Param("page") Page<TpmDeductionMatchingTemplateVo> page,@Param("dto") TpmDeductionMatchingTemplateSelectDto dto);

    /**
     *
     * @param page
     * @param dto
     * @return
     */
    Page<String> findAllEnableTemplateCode(Page<TpmDeductionMatchingTemplateVo> page, @Param("dto") TpmDeductionMatchingTemplateDto dto);

    /**
     * 根据低头查询
     * @param dto
     * @return
     */
    List<TpmDeductionMatchingTemplate> findByDto(@Param("dto") TpmDeductionMatchingTemplateDto dto);
}

