package com.biz.crm.tpm.business.audit.fee.local.template.repository;


import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.template.entity.TpmDeductionMatchingTemplateAllowance;
import com.biz.crm.tpm.business.audit.fee.local.template.mapper.TpmDeductionMatchingTemplateAllowanceMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateAllowanceDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateAllowanceVo;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateSelectVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;


/**
 * TPM-扣费匹配模板-容差(TpmDeductionMatchingTemplateAllowance)表数据库访问层
 *
 * @author duyiran
 * @since 2022-11-11 09:58:41
 */
@Component
public class TpmDeductionMatchingTemplateAllowanceRepository extends ServiceImpl<TpmDeductionMatchingTemplateAllowanceMapper, TpmDeductionMatchingTemplateAllowance> {

    @Autowired(required = false)
    private TpmDeductionMatchingTemplateAllowanceMapper tpmDeductionMatchingTemplateAllowanceMapper;

    /**
     * 根据code查询容差
     * @param code
     * @return
     */
    public List<TpmDeductionMatchingTemplateAllowanceVo> findByCode(String code) {
        return this.tpmDeductionMatchingTemplateAllowanceMapper.findByCode(code, TenantUtils.getTenantCode());
    }

    /**
     * 根据codeList查询容差
     * @param codeList
     * @return
     */
    public List<TpmDeductionMatchingTemplateAllowanceVo> findByCodeList(List<String> codeList) {
        return this.tpmDeductionMatchingTemplateAllowanceMapper.findByCodeList(codeList);
    }

    public List<TpmDeductionMatchingTemplateAllowance> listByUniqueKey(List<String> uniqueKeyList) {
        return this.lambdaQuery().in(TpmDeductionMatchingTemplateAllowance::getDeductionUniqueKey, uniqueKeyList)
                .eq(TpmDeductionMatchingTemplateAllowance::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmDeductionMatchingTemplateAllowance::getTenantCode, TenantUtils.getTenantCode()).list();
    }

    public List<TpmDeductionMatchingTemplateSelectVo> findAllApplyMappingCode(String tenantCode) {
        return this.tpmDeductionMatchingTemplateAllowanceMapper.findAllApplyMappingCode(tenantCode);
    }

    public void removeByCode(String code) {
        this.lambdaUpdate()
                .eq(TpmDeductionMatchingTemplateAllowance::getCode,code)
                .remove();
    }

    public List<TpmDeductionMatchingTemplateAllowanceVo> findListAnywayByCodeOrCodes(TpmDeductionMatchingTemplateAllowanceDto allowanceDto) {
        if (Objects.isNull(allowanceDto)) {
            return Lists.newArrayList();
        }
        if (CollectionUtils.isEmpty(allowanceDto.getCodeList()) && StringUtils.isBlank(allowanceDto.getCode())) {
            return Lists.newArrayList();
        }
        List<TpmDeductionMatchingTemplateAllowanceVo> list = this.baseMapper.findListAnywayByCodeOrCodes(allowanceDto, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }
}

