package com.biz.crm.tpm.business.audit.fee.local.template.repository;


import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.template.entity.TpmDeductionMatchingTemplate;
import com.biz.crm.tpm.business.audit.fee.local.template.mapper.TpmDeductionMatchingTemplateMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateSelectDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Objects;


/**
 * TPM-扣费匹配模板(TpmDeductionMatchingTemplate)表数据库访问层
 *
 * @author duyiran
 * @since 2022-11-11 09:57:09
 */
@Component
public class TpmDeductionMatchingTemplateRepository extends ServiceImpl<TpmDeductionMatchingTemplateMapper, TpmDeductionMatchingTemplate> {

    @Autowired(required = false)
    private TpmDeductionMatchingTemplateMapper tpmDeductionMatchingTemplateMapper;

    /**
     * 分页查询数据
     *
     * @param pageable                     分页对象
     * @param dto 实体对象
     * @return
     */
    public Page<TpmDeductionMatchingTemplateVo> findByConditions(Pageable pageable, TpmDeductionMatchingTemplateDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new TpmDeductionMatchingTemplateDto();
        }
        if (StringUtils.isEmpty(dto.getTenantCode())) {
            String tenantCode = TenantUtils.getTenantCode();
            dto.setTenantCode(tenantCode);
        }
        Page<TpmDeductionMatchingTemplateVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.tpmDeductionMatchingTemplateMapper.findByConditions(page, dto);
    }

    /**
     * 根据编码查询数据(不分页)
     *
     * @param dto dto
     * @return
     */
    public List<TpmDeductionMatchingTemplateVo> findAllListByConditions(TpmDeductionMatchingTemplateDto dto) {
        return this.tpmDeductionMatchingTemplateMapper.findAllListByConditions(dto);
    }

    public TpmDeductionMatchingTemplate findByCode(String matchTemplateCode) {
        return this.lambdaQuery().eq(TpmDeductionMatchingTemplate::getCode, matchTemplateCode)
                .eq(TpmDeductionMatchingTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmDeductionMatchingTemplate::getTenantCode, TenantUtils.getTenantCode())
                .one();
    }

    public List<TpmDeductionMatchingTemplate> findByCodes(List<String> matchTemplateCodes) {
        return this.lambdaQuery()
                .eq(TpmDeductionMatchingTemplate::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmDeductionMatchingTemplate::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmDeductionMatchingTemplate::getCode, matchTemplateCodes)
                .list();
    }

    public Page<TpmDeductionMatchingTemplateVo> findByConditionsWithResaleCommercial(Pageable pageable, TpmDeductionMatchingTemplateSelectDto dto) {
        Page<TpmDeductionMatchingTemplateVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.tpmDeductionMatchingTemplateMapper.findByConditionsWithResaleCommercial(page, dto);
    }

    public Page<String> findAllEnableTemplateCode(Page<TpmDeductionMatchingTemplateVo> page, TpmDeductionMatchingTemplateDto dto) {
        return this.tpmDeductionMatchingTemplateMapper.findAllEnableTemplateCode(page,dto);
    }

    public List<TpmDeductionMatchingTemplate> findByDto(TpmDeductionMatchingTemplateDto dto) {
        if (Objects.isNull(dto)) {
            dto = new TpmDeductionMatchingTemplateDto();
        }
        return this.baseMapper.findByDto(dto);
    }

    public void updateByMappingUpdate(TpmDeductionMatchingTemplateDto dto) {
        this.lambdaUpdate()
                .set(TpmDeductionMatchingTemplate::getSalesInstitutionCode,dto.getSalesInstitutionCode())
                .set(TpmDeductionMatchingTemplate::getSalesInstitutionErpCode,dto.getSalesInstitutionErpCode())
                .set(TpmDeductionMatchingTemplate::getSalesInstitutionName,dto.getSalesInstitutionName())
                .set(TpmDeductionMatchingTemplate::getResaleCommercialCode,dto.getResaleCommercialCode())
                .set(TpmDeductionMatchingTemplate::getResaleCommercialName,dto.getResaleCommercialName())
                .eq(TpmDeductionMatchingTemplate::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmDeductionMatchingTemplate::getTenantCode,TenantUtils.getTenantCode())
                .eq(TpmDeductionMatchingTemplate::getApplyMappingCode,dto.getApplyMappingCode())
                .update();
    }
}

