package com.biz.crm.tpm.business.audit.fee.local.template.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.template.entity.TpmDeductionMatchingTemplateRules;
import com.biz.crm.tpm.business.audit.fee.local.template.mapper.TpmDeductionMatchingTemplateRulesMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/9/16
 */
@Component
public class TpmDeductionMatchingTemplateRulesRepository extends ServiceImpl<TpmDeductionMatchingTemplateRulesMapper, TpmDeductionMatchingTemplateRules> {

    public List<TpmDeductionMatchingTemplateRules> findByCode(String code) {
        return this.lambdaQuery()
                .eq(TpmDeductionMatchingTemplateRules::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmDeductionMatchingTemplateRules::getTenantCode, TenantUtils.getTenantCode())
                .eq(TpmDeductionMatchingTemplateRules::getCode,code)
                .list();
    }

    public void removeByCode(String code) {
        this.lambdaUpdate()
                .eq(TpmDeductionMatchingTemplateRules::getCode,code)
                .remove();
    }

    public List<TpmDeductionMatchingTemplateRules> findByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(TpmDeductionMatchingTemplateRules::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(TpmDeductionMatchingTemplateRules::getTenantCode, TenantUtils.getTenantCode())
                .in(TpmDeductionMatchingTemplateRules::getCode,codes)
                .list();
    }
}
