package com.biz.crm.tpm.business.audit.fee.local.template.service.internal;

import com.alibaba.excel.util.StringUtils;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.service.TpmDeductionMatchingTemplateService;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.dto.TpmDeductionDetailMappingEventDto;
import com.biz.crm.tpm.business.deduction.detail.mapping.sdk.event.log.TpmDeductionDetailMappingEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/10/12
 */
@Slf4j
@Service
public class TpmDeductionDetailMappingEventImpl implements TpmDeductionDetailMappingEvent {

    @Autowired(required = false)
    private TpmDeductionMatchingTemplateService tpmDeductionMatchingTemplateService;

    @Override
    public void onUpdate(TpmDeductionDetailMappingEventDto eventDto) {
        if (Objects.isNull(eventDto) || StringUtils.isBlank(eventDto.getCode())) {
            return;
        }
        TpmDeductionMatchingTemplateDto dto = new TpmDeductionMatchingTemplateDto();
        dto.setApplyMappingCode(eventDto.getCode());
        dto.setSalesInstitutionCode(eventDto.getSalesInstitutionCode());
        dto.setSalesInstitutionErpCode(eventDto.getSalesInstitutionErpCode());
        dto.setSalesInstitutionName(eventDto.getSalesInstitutionName());
        dto.setResaleCommercialCode(eventDto.getResaleCommercialCode());
        dto.setResaleCommercialName(eventDto.getResaleCommercialName());

        tpmDeductionMatchingTemplateService.updateByMappingUpdate(dto);
    }
}
