package com.biz.crm.tpm.business.audit.fee.local.template.service.internal;


import com.biz.crm.tpm.business.audit.fee.local.template.entity.TpmDeductionMatchingTemplateAllowance;
import com.biz.crm.tpm.business.audit.fee.local.template.repository.TpmDeductionMatchingTemplateAllowanceRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.template.service.TpmDeductionMatchingTemplateAllowanceService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateAllowanceVo;
import com.biz.crm.tpm.business.audit.fee.sdk.template.vo.TpmDeductionMatchingTemplateSelectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

/**
 * TPM-扣费匹配模板-容差(TpmDeductionMatchingTemplateAllowance)表服务实现类
 *
 * @author duyiran
 * @since 2022-11-11 09:58:39
 */
@Service("tpmDeductionMatchingTemplateAllowanceService")
public class TpmDeductionMatchingTemplateAllowanceServiceImpl implements TpmDeductionMatchingTemplateAllowanceService {

    @Autowired(required = false)
    private TpmDeductionMatchingTemplateAllowanceRepository tpmDeductionMatchingTemplateAllowanceRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<TpmDeductionMatchingTemplateAllowanceVo> findByIdList(List<String> idList) {
        List<TpmDeductionMatchingTemplateAllowance> entityList = tpmDeductionMatchingTemplateAllowanceRepository.listByIds(idList);
        return new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(entityList, TpmDeductionMatchingTemplateAllowance.class, TpmDeductionMatchingTemplateAllowanceVo.class, LinkedHashSet.class, ArrayList.class));
    }

    @Override
    public List<TpmDeductionMatchingTemplateAllowanceVo> findByUniqueKeyList(List<String> uniqueKeyList) {
        List<TpmDeductionMatchingTemplateAllowance> entityList = tpmDeductionMatchingTemplateAllowanceRepository.listByUniqueKey(uniqueKeyList);
        return new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(entityList, TpmDeductionMatchingTemplateAllowance.class, TpmDeductionMatchingTemplateAllowanceVo.class, LinkedHashSet.class, ArrayList.class));
    }

    @Override
    public List<TpmDeductionMatchingTemplateSelectVo> findAllApplyMappingCode(String tenantCode) {
        if (StringUtils.isBlank(tenantCode)) {
            return Lists.newArrayList();
        }
        List<TpmDeductionMatchingTemplateSelectVo> list = this.tpmDeductionMatchingTemplateAllowanceRepository.findAllApplyMappingCode(tenantCode);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }
}

