package com.biz.crm.tpm.business.audit.fee.local.template.service.notifier;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.TpmDeductionMatchingTemplateDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.dto.log.TpmDeductionMatchingTemplateLogEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.template.log.TpmDeductionMatchingTemplateLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 业务单元事件通知
 *
 * @author: duyiran
 * @version: v1.0.0
 * @date: 2022.11.11 11:11
 */
@Component
public class TpmDeductionMatchingTemplateLogEventListenerImpl implements TpmDeductionMatchingTemplateLogEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;


    /**
     * 创建
     *
     * @param dto
     * @return void
     * @author: duyiran
     * @version: v1.0.0
     * @date: 2022.11.11 11:11
     */
    @Override
    public void onCreate(TpmDeductionMatchingTemplateLogEventDto dto) {
        // 新对象
        TpmDeductionMatchingTemplateDto newest = dto.getNewest();
        // 旧对象
        TpmDeductionMatchingTemplateDto original = dto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }


    /**
     * 删除
     *
     * @param dto
     * @return void
     * @author: duyiran
     * @version: v1.0.0
     * @date: 2022.11.11 11:11
     */
    @Override
    public void onDelete(TpmDeductionMatchingTemplateLogEventDto dto) {
        // 新对象
        TpmDeductionMatchingTemplateDto newest = dto.getNewest();
        // 旧对象
        TpmDeductionMatchingTemplateDto original = dto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }


    /**
     * 更新
     *
     * @param dto
     * @return void
     * @author: duyiran
     * @version: v1.0.0
     * @date: 2022.11.11 11:11
     */
    @Override
    public void onUpdate(TpmDeductionMatchingTemplateLogEventDto dto) {
        // 新对象
        TpmDeductionMatchingTemplateDto newest = dto.getNewest();
        // 旧对象
        TpmDeductionMatchingTemplateDto original = dto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    /**
     * 启禁用
     *
     * @param eventDto
     */
    @Override
    public void onUpdateEnable(TpmDeductionMatchingTemplateLogEventDto eventDto) {
        //获取最新的
        TpmDeductionMatchingTemplateDto newest = eventDto.getNewest();
        //获取原始值
        TpmDeductionMatchingTemplateDto original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //只传单个字段
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("enableStatus", original.getEnableStatus());
        newObject.put("enableStatus", newest.getEnableStatus());
        crmBusinessLogDto.setOldObject(oldObject);
        crmBusinessLogDto.setNewObject(newObject);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }


}
