package com.biz.crm.tpm.business.audit.fee.local.util;

import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DetailedPredictionTypeEnum;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

/**
 * <p>
 * 差异费用追踪预测参数构建
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-18
 */
public class AuditFeeDiffTrackPassDetailedForecastBuilder {

    /**
     * 主体、垂直
     *
     * @param activityDetailPlanDto
     * @param item
     * @param regionMap
     * @param customerVo
     * @param salesOrgAllParentVo
     * @return
     */
    public static DetailedForecastDto buildUnit1Dto(
                                                    AuditFeeDiffTrackForecastDto activityDetailPlanDto,
                                                    AuditFeeDiffTrackDetailDto item,
                                                    Map<String, String> regionMap,
                                                    CustomerVo customerVo,
                                                    SalesOrgAllParentVo salesOrgAllParentVo) {
        DetailedForecastDto detailedForecastDto = new DetailedForecastDto();
        detailedForecastDto.setBusinessFormatCode(activityDetailPlanDto.getBusinessFormatCode());
        detailedForecastDto.setBusinessUnitCode(activityDetailPlanDto.getBusinessUnitCode());
        detailedForecastDto.setDetailedCaseCode(activityDetailPlanDto.getPlanCode());
        detailedForecastDto.setDetailedCaseName(activityDetailPlanDto.getPlanName());
        detailedForecastDto.setActivityTypeCode(item.getActivityTypeCode());
        detailedForecastDto.setActivityTypeName(item.getActivityTypeName());
        detailedForecastDto.setActivityFormCode(item.getActivityFormCode());
        detailedForecastDto.setActivityFormName(item.getActivityFormName());
        detailedForecastDto.setActivityStartTime(item.getActivityBeginDate());
        detailedForecastDto.setActivityEndTime(item.getActivityEndDate());
        detailedForecastDto.setPrimaryManagementChannel(item.getFirstChannelCode());
        detailedForecastDto.setCustomer(item.getCustomerName());
        detailedForecastDto.setCustomerCode(item.getCustomerCode());
        detailedForecastDto.setAuditType(item.getAuditType());
        detailedForecastDto.setSaleOrgCode(item.getActivityOrgCode());
        detailedForecastDto.setSaleOrgName(item.getActivityOrgName());
        detailedForecastDto.setSalesOrgCode(item.getActivityOrgCode());
        detailedForecastDto.setSalesOrgName(item.getActivityOrgName());
        detailedForecastDto.setIdentityCard(item.getPersonIdCard());
        detailedForecastDto.setFirstChannelCode(item.getFirstChannelCode());
        detailedForecastDto.setFirstChannelName(item.getFirstChannelName());
        detailedForecastDto.setSecondChannelCode(item.getSecondChannelCode());
        detailedForecastDto.setSecondChannelName(item.getSecondChannelName());
//        detailedForecastDto.setHeadBudgetItemCode(item.getHeadBudgetItemCode());
//        detailedForecastDto.setMonthBudgetCode(item.getMonthBudgetCode());
        detailedForecastDto.setFormDescription(item.getActivityRemark());
        detailedForecastDto.setIsTemporary(activityDetailPlanDto.getIsTemporary());
        detailedForecastDto.setApplyAmount(item.getFeeAmount());
//        detailedForecastDto.setCustomerAccount(item.getIsCustomerAccount());
//        detailedForecastDto.setDisplayNumber(item.getDisplayLot());
//        detailedForecastDto.setDepartmentFeeAmount(item.getDepartmentFeeAmount());
        detailedForecastDto.setHeadFeeAmount(item.getHeadFeeAmount());
        detailedForecastDto.setBuyWay(item.getBuyWay());
        detailedForecastDto.setRegion(item.getRegion());
        if (StringUtils.isNotEmpty(item.getRegion())) {
            detailedForecastDto.setRegionName(regionMap.get(item.getRegion()));
        }

        if (Objects.nonNull(salesOrgAllParentVo)) {
            detailedForecastDto.setSalesOrgErpCode(salesOrgAllParentVo.getCurrSalesOrgVo().getErpCode());
            detailedForecastDto.setSalesInstitutionErpCode(salesOrgAllParentVo.getSalesInstitutionErpCode());
            detailedForecastDto.setSalesInstitutionCode(salesOrgAllParentVo.getSalesInstitutionCode());
            detailedForecastDto.setSalesInstitutionName(salesOrgAllParentVo.getSalesInstitutionName());
            detailedForecastDto.setSalesRegionErpCode(salesOrgAllParentVo.getSalesDepartErpCode());
            detailedForecastDto.setSalesRegionCode(salesOrgAllParentVo.getSalesDepartCode());
            detailedForecastDto.setSalesRegionName(salesOrgAllParentVo.getSalesDepartName());
            detailedForecastDto.setSalesGroupErpCode(salesOrgAllParentVo.getSalesGroupErpCode());
            detailedForecastDto.setSalesGroupCode(salesOrgAllParentVo.getSalesGroupCode());
            detailedForecastDto.setSalesGroupName(salesOrgAllParentVo.getSalesGroupName());
        } else {
            //查不到就用原来表里面的数据
            detailedForecastDto.setSalesInstitutionErpCode(item.getSalesInstitutionErpCode());
//            detailedForecastDto.setSalesInstitutionCode(item.getSalesInstitutionCode());
//            detailedForecastDto.setSalesInstitutionName(item.getSalesInstitutionName());
//            detailedForecastDto.setSalesRegionErpCode(item.getSalesRegionErpCode());
//            detailedForecastDto.setSalesRegionCode(item.getSalesRegionCode());
//            detailedForecastDto.setSalesRegionName(item.getSalesRegionName());
//            detailedForecastDto.setSalesGroupErpCode(item.getSalesOrgErpCode());
//            detailedForecastDto.setSalesGroupCode(item.getSalesOrgCode());
//            detailedForecastDto.setSalesGroupName(item.getSalesOrgName());
        }
        detailedForecastDto.setSystemName(item.getSystemName());
        if (Objects.nonNull(customerVo)) {
            detailedForecastDto.setCustomerErpCode(customerVo.getErpCode());
            detailedForecastDto.setRtmMode(customerVo.getRtmModelCode());
            detailedForecastDto.setCusCreateTime(customerVo.getCreateTime());
            detailedForecastDto.setChannelCode(customerVo.getCustomerChannelCode());
            detailedForecastDto.setChannelName(customerVo.getCustomerChannelName());
        }
        if (StringUtils.equals("Y", item.getIsClose())) {
            detailedForecastDto.setDetailedPredictionType(DetailedPredictionTypeEnum.CLOSED.getDictCode());
        } else {
            detailedForecastDto.setDetailedPredictionType(DetailedPredictionTypeEnum.NORMAL.getDictCode());
        }
        //细案明细编码
        detailedForecastDto.setActivityDetailItemCode(item.getDetailCode());
        detailedForecastDto.setAuditFormulaCode(item.getAuditConditionCode());

        if (Objects.nonNull(item.getFeeYearMonth())) {
            detailedForecastDto.setYearMonthStr(DateFormatUtils.format(item.getFeeYearMonth(), "yyyy-MM"));
        }
        detailedForecastDto.setProductCode(item.getProductCode());
        detailedForecastDto.setProductName(item.getProductName());
        detailedForecastDto.setTerminalCode(item.getTerminalCode());
        detailedForecastDto.setTerminalName(item.getTerminalName());
        detailedForecastDto.setProductBrandCode(item.getProductBrandCode());
        detailedForecastDto.setProductBrandName(item.getProductBrandName());
        detailedForecastDto.setProductCategoryCode(item.getProductCategoryCode());
        detailedForecastDto.setProductCategoryName(item.getProductCategoryName());
        detailedForecastDto.setProductItemCode(item.getProductItemCode());
        detailedForecastDto.setProductItemName(item.getProductItemName());
        detailedForecastDto.setSystemCode(item.getSystemCode());
        if (StringUtils.equals(activityDetailPlanDto.getBusinessUnitCode(), BusinessUnitEnum.HEADQUARTERS.getCode())) {
//            detailedForecastDto.setPersonCode(item.getPersonCode());
        } else {
            detailedForecastDto.setPersonCode(item.getEmployeeId());
        }
        detailedForecastDto.setWriteOffMethod(item.getWriteOffMethod());
        return detailedForecastDto;
    }


}
