package com.biz.crm.tpm.business.audit.fee.local.util;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaInfoVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackForecastDto;
import com.biz.crm.tpm.business.audit.summary.configure.sdk.service.TpmCustomerSummaryConfigureService;
import com.biz.crm.tpm.business.business.policy.sdk.service.BusinessPolicyService;
import com.biz.crm.tpm.business.detailed.forecast.local.entity.DetailedForecastEntity;
import com.biz.crm.tpm.business.detailed.forecast.local.mapper.DetailedForecastMapper;
import com.biz.crm.tpm.business.detailed.forecast.local.repository.DetailedForecastRepository;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.log.DetailedForecastLogEventDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.event.DetailedForecastLogEventListener;
import com.biz.crm.tpm.business.detailed.forecast.sdk.util.MathUtil;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 * 差异费用追踪推送细案预测生成
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-21
 */
@Slf4j
@Component
public class AuditFeeDiffTrackPassDetailedForecastUtil {

    @Autowired(required = false)
    private AuditFormulaMainService auditFormulaMainService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private VariableService variableService;

    @Autowired(required = false)
    private GeneralExpensesService generalExpensesService;

    @Autowired(required = false)
    private DetailedForecastRepository detailedForecastRepository;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private TpmCustomerSummaryConfigureService tpmCustomerSummaryConfigureService;

    @Autowired(required = false)
    private BusinessPolicyService businessPolicyService;

    @Autowired(required = false)
    private DetailedForecastMapper detailedForecastMapper;

    /**
     * 主体
     *
     * @param activityDetailPlanDto
     * @param detailedForecastDto
     * @param item
     */
    @Async("asyncThread")
    public void buildUnit1Param(AuditFeeDiffTrackForecastDto activityDetailPlanDto, DetailedForecastDto detailedForecastDto, AuditFeeDiffTrackDetailDto item, UserIdentity loginUser) {
        loginUserService.refreshAuthentication(loginUser);
        log.info("细案编码[{}]明细编码[{}]差异追踪细案预测主体新增计算", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode());
        if (StringUtils.isNotEmpty(item.getAuditType())) {
            if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(item.getAuditType())) {
                AuditFormulaMainDto dto = new AuditFormulaMainDto();
                dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
                dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
                dto.setAuditType(item.getAuditType());
                dto.setSalesOrgCodes(detailedForecastDto.getSaleOrgCode());
                dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
                dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
                dto.setCustomerTypes(detailedForecastDto.getRtmMode());
                dto.setFirstChannel(detailedForecastDto.getFirstChannelCode());
                dto.setSecondChannel(detailedForecastDto.getSecondChannelCode());
                dto.setCustomerAccount(detailedForecastDto.getCustomerAccount());
                dto.setDisplayNumber(detailedForecastDto.getDisplayNumber());
                dto.setWriteOffMethod(detailedForecastDto.getWriteOffMethod());
                List<AuditFormulaMainVo> formulaMainVoList = auditFormulaMainService.findListByDto(dto);
                formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty(e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                    //上面查核销公式的时候会处理，默认取第一条公式不为空的就可以了
                    CalculateDto calDto = this.buildCalParam(formulaMainVoList.get(0), detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE1.getCode());
                    this.setParam(formulaMainVoList.get(0), detailedForecastDto, calDto);
                } else {
                    detailedForecastDto.setAuditFormulaCode(null);
                }
            } else if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(item.getAuditType())) {
                AuditFormulaMainVo auditFormulaMainVo = null;
                try {
                    auditFormulaMainVo = auditFormulaMainService.findByCode(item.getAuditConditionCode());
                } catch (Exception e) {
                    log.error("细案编码[" + detailedForecastDto.getDetailedCaseCode() + "]明细编码[" + detailedForecastDto.getActivityDetailItemCode() + "]细案预测主体新增计算" + e.getMessage(), e);
                }
                CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE2.getCode());
                this.setParam(auditFormulaMainVo, detailedForecastDto, calDto);
            } else if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(item.getAuditType())) {
                detailedForecastDto.setWriteOffConditions(TpmAuditTypeEnum.AUDITTYPE3.getValue());
                detailedForecastDto.setEstimatedWriteOffAmount(item.getFeeAmount());
//                this.setCommonQueryParam(detailedForecastDto);
            } else {
//                throw new RuntimeException("细案编码[" + detailedForecastDto.getDetailedCaseCode() + "]细案预测生成计算失败：未知核销类型编码[" + item.getAuditType() + "]！");
            }
        }
        this.insert(detailedForecastDto);
    }

    /**
     * 垂直
     *
     * @param detailedForecastDto
     * @param item
     */
    @Async("asyncThread")
    public void buildUnit3Param(DetailedForecastDto detailedForecastDto, AuditFeeDiffTrackDetailDto item, UserIdentity loginUser) {
        loginUserService.refreshAuthentication(loginUser);
        log.info("细案编码[{}]明细编码[{}]差异追踪细案预测垂直新增计算", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode());
        if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(item.getAuditType())) {
            AuditFormulaMainDto dto = new AuditFormulaMainDto();
            dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
            dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
            dto.setAuditType(item.getAuditType());
            dto.setSalesOrgCodes(detailedForecastDto.getSaleOrgCode());
            dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
            dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
            dto.setWriteOffMethod(detailedForecastDto.getWriteOffMethod());
            log.info("细案编码[{}]明细编码[{}]差异追踪细案预测垂直新增计算:查询核销公式主表{}", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), JSON.toJSONString(dto));
            List<AuditFormulaMainVo> formulaMainVoList = auditFormulaMainService.findListByDto(dto);
            formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty(e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                log.info("细案编码[{}]明细编码[{}]差异追踪细案预测垂直新增计算:查询核销公式主表结果1{}", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), JSON.toJSONString(formulaMainVoList.get(0)));
                //上面查核销公式的时候会处理，默认取第一条公式不为空的就可以了
                CalculateDto calDto = this.buildCalParam(formulaMainVoList.get(0), detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE1.getCode());
                this.setParam(formulaMainVoList.get(0), detailedForecastDto, calDto);
            } else {
                detailedForecastDto.setAuditFormulaCode(null);
            }
        } else if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(item.getAuditType())) {
            AuditFormulaMainVo auditFormulaMainVo = null;
            try {
                auditFormulaMainVo = auditFormulaMainService.findByCode(item.getAuditConditionCode());
            } catch (Exception e) {
                log.error("细案编码[" + detailedForecastDto.getDetailedCaseCode() + "]明细编码[" + detailedForecastDto.getActivityDetailItemCode() + "]差异追踪细案预测垂直新增计算" + e.getMessage(), e);
            }
            CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, detailedForecastDto, TpmAuditTypeEnum.AUDITTYPE2.getCode());
            this.setParam(auditFormulaMainVo, detailedForecastDto, calDto);
        } else if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(item.getAuditType())) {
            detailedForecastDto.setWriteOffConditions(TpmAuditTypeEnum.AUDITTYPE3.getValue());
            detailedForecastDto.setEstimatedWriteOffAmount(item.getFeeAmount());
//            this.setCommonQueryParam(detailedForecastDto);
        } else {
//            throw new RuntimeException("细案编码[" + detailedForecastDto.getDetailedCaseCode() + "]细案预测生成计算失败：未知核销类型编码[" + item.getAuditType() + "]！");
        }
        this.insert(detailedForecastDto);
    }

    /**
     * 公式计算请求参数构建
     * paramMap 参数说明：
     * productCode：产品编码
     * productCode：产品编码
     * yearMonthStr：年月
     * terminalCode：门店编码
     * terminalName：门店名称
     * productBrandCode：品牌编码
     * productBrandName：品牌名称
     * productCategoryCode：大类编码
     * productCategoryName：大类名称
     * productItemCode：品项编码
     * productItemName：品项名称
     * activitiesDetailCode：活动明细编码
     * region：区域
     * channelCode：渠道编码
     * channelName：渠道名称
     * planItemCode：方案活动明细编码、促销规划明细编码、分子公司活动细案明细编码
     * detailPlanItemCode：活动细案明细编码
     *
     * @param auditFormulaMainVo
     * @param detailedForecastDto
     * @param auditType
     * @return
     */
    public CalculateDto buildCalParam(AuditFormulaMainVo auditFormulaMainVo, DetailedForecastDto detailedForecastDto, String auditType) {
        if (Objects.nonNull(auditFormulaMainVo) && CollectionUtil.isNotEmpty(auditFormulaMainVo.getAuditFormulaInfoVoList())) {
            CalculateDto dto = new CalculateDto();
            dto.setCode(auditFormulaMainVo.getAuditFormulaCode());
            dto.setAuditFormulaCode(auditFormulaMainVo.getAuditFormulaCode());
            dto.setCustomerCode(detailedForecastDto.getCustomerCode());
            dto.setCustomerErpCode(detailedForecastDto.getCustomerErpCode());
            dto.setCustomerName(detailedForecastDto.getCustomer());
            dto.setBusinessFormatCode(detailedForecastDto.getBusinessFormatCode());
            dto.setBusinessUnitCode(detailedForecastDto.getBusinessUnitCode());
            dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
            dto.setActivityTypeName(detailedForecastDto.getActivityTypeName());
            dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
            dto.setActivityFormName(detailedForecastDto.getActivityFormName());
            dto.setStartTimeOrDate(detailedForecastDto.getActivityStartTime());
            dto.setEndTimeOrDate(detailedForecastDto.getActivityEndTime());
            dto.setFormulaInfoDtoList(this.copyFormulaInfoList(auditFormulaMainVo.getAuditFormulaInfoVoList()));
            dto.setAuditType(auditType);
            dto.setSalesOrgCode(detailedForecastDto.getSaleOrgCode());
            dto.setSalesOrgErpCode(detailedForecastDto.getSalesOrgErpCode());
            dto.setSalesOrganizationCode(detailedForecastDto.getSalesInstitutionCode());
            dto.setSalesOrganizationErpCode(detailedForecastDto.getSalesInstitutionErpCode());
            dto.setSalesRegionCode(detailedForecastDto.getSalesRegionCode());
            dto.setSalesRegionErpCode(detailedForecastDto.getSalesRegionErpCode());
            dto.setSalesGroupCode(detailedForecastDto.getSalesGroupCode());
            dto.setSalesGroupErpCode(detailedForecastDto.getSalesOrgErpCode());
            dto.setProductCode(detailedForecastDto.getProductCode());
            dto.setYearMonthLy(detailedForecastDto.getYearMonthStr());
            dto.setStoresCode(detailedForecastDto.getTerminalCode());
            dto.setBrandCode(detailedForecastDto.getProductBrandCode());
            dto.setCategoryCode(detailedForecastDto.getProductCategoryCode());
            dto.setItemCode(detailedForecastDto.getProductItemCode());
            dto.setDetailPlanItemCode(detailedForecastDto.getActivityDetailItemCode());
            dto.setPlanItemCode(detailedForecastDto.getDetailedCaseCode());
            dto.setActivityOrgCode(detailedForecastDto.getRegion());
            dto.setActivityOrgName(detailedForecastDto.getRegionName());
            dto.setRetailBusinessmanCode(detailedForecastDto.getSystemCode());
            dto.setRetailBusinessmanName(detailedForecastDto.getSystemName());
            dto.setActivityTypeCode(detailedForecastDto.getActivityTypeCode());
            dto.setActivityFormCode(detailedForecastDto.getActivityFormCode());
            dto.setPersonCode(detailedForecastDto.getPersonCode());
            dto.setIdentityCard(detailedForecastDto.getIdentityCard());
            dto.setSecondChannelCode(detailedForecastDto.getSecondChannelCode());
            dto.setEstoreCustomerLevel(detailedForecastDto.getEstoreCustomerLevel());
            if (Objects.nonNull(detailedForecastDto.getActivityStartTime())) {
                String date = DateUtil.format(detailedForecastDto.getActivityStartTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
                //长度为10满足yyyy-MM-dd
                if (date.length() == 10) {
                    dto.setDate(DateUtil.parse(date, DateUtil.DEFAULT_YEAR_MONTH_DAY));
                }
                //长度为19满足yyyy-MM-dd HH:mm:ss
                else if (date.length() == 19) {
                    dto.setDate(DateUtil.parse(date, DateUtil.DEFAULT_DATE_ALL_PATTERN));
                }
            }

            dto.setDealerCode(detailedForecastDto.getCustomerErpCode());
            dto.setChannel(detailedForecastDto.getChannelCode());
            dto.setStartTimeOrDate(detailedForecastDto.getActivityStartTime());
            dto.setEndTimeOrDate(detailedForecastDto.getActivityEndTime());
            dto.setPersonIdCard(detailedForecastDto.getIdentityCard());
            dto.setFirstChannelCode(detailedForecastDto.getFirstChannelCode());
            dto.setSecondChannelCode(detailedForecastDto.getSecondChannelCode());
            dto.setHeadBudgetItemCode(detailedForecastDto.getHeadBudgetItemCode());
            dto.setMonthBudgetCode(detailedForecastDto.getMonthBudgetCode());
            dto.setSpecification(detailedForecastDto.getFormDescription());
            dto.setIsTemporary(detailedForecastDto.getIsTemporary());
            dto.setCusCreateTime(detailedForecastDto.getCusCreateTime());
            dto.setDistributionChannel(detailedForecastDto.getDistributionChannelCode());

            //合并客户编码-主体
            if (StringUtils.isNotEmpty(dto.getCustomerCode()) && BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode())) {
                Map<String, Set<String>> map = tpmCustomerSummaryConfigureService.configureIncludeMap(Lists.newArrayList(dto.getCustomerCode()));
                if (map.containsKey(dto.getCustomerCode())) {
                    dto.setCustomerCodeList(map.get(dto.getCustomerCode()));
                } else {
                    dto.setCustomerCodeList(Sets.newHashSet(dto.getCustomerCode()));
                }
            }
            return dto;
        } else {
            log.info("细案预测=====》核销条件为空");
        }
        return null;
    }

    /**
     * 公式参数计算组装
     *
     * @param auditFormulaMainVo
     * @param detailedForecastDto
     * @param calDto
     */
    public void setParam(AuditFormulaMainVo auditFormulaMainVo, DetailedForecastDto detailedForecastDto, CalculateDto calDto) {
        if (Objects.isNull(calDto)) {
            return;
        }
        detailedForecastDto.setCalEx("");
        List<CalculateVo> calculateVos = Lists.newArrayList();
        try {
//            calculateVos = variableService.allCalculateConditionAndExpression(Lists.newArrayList(calDto));
            // 标识为差异追踪数据
            calDto.setIsDiffTrack(true);
            log.info("细案编码[{}]明细编码[{}]差异追踪细案预测垂直新增计算:获取计算条件&公式参数{}", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), JSON.toJSONString(calDto));
            calculateVos = variableService.orCalculateConditionAndExpression(Lists.newArrayList(calDto));
            log.info("细案编码[{}]明细编码[{}]差异追踪细案预测垂直新增计算:获取计算条件&公式返回{}", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), JSON.toJSONString(calculateVos));
        } catch (Exception ex) {
            //todo 记日志
            ex.printStackTrace();
            if (StringUtils.isNotEmpty(ex.getMessage())) {
                int length = Math.min(ex.getMessage().length(), 200);
                detailedForecastDto.setCalEx(ex.getMessage().substring(0, length));
            } else {
                detailedForecastDto.setCalEx("NPE");
            }
            log.error("细案编码[{}]明细编码[{}]差异追踪细案预测计算失败：{}", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), ex.getMessage());
        }

        //公式条件满足的计算结果
        AtomicReference<String> filterCondition = new AtomicReference<>();
        List<CalculateVo> filterVos = calculateVos.stream().filter(CalculateVo::getFormulaConditionValue).collect(Collectors.toList());
        if (filterVos.size() > 1) {
            log.error("核销公式编码 [" + auditFormulaMainVo.getAuditFormulaCode() + "] 计算结果：多个核销公式条件同时满足！");
        } else if (CollectionUtils.isNotEmpty(filterVos)) {
            filterCondition.set(filterVos.get(0).getFormulaConditionName());
        }
        //预估核销金额
        BigDecimal estimatedWriteOffAmount = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(filterVos)) {
            estimatedWriteOffAmount = filterVos.get(0).getFormulaValue();
        } else {
            log.info("细案编码[{}]明细编码[{}]未满足公式任何条件，默认预核销金额为0！", detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode());
        }

        //变量对应的值
        Map<String, BigDecimal> variableValueMap = new HashMap<>();
        calculateVos.forEach(v -> {
            if (Objects.nonNull(v.getVariableValueMap())) {
                variableValueMap.putAll(v.getVariableValueMap());
            }
        });

        List<String> variableCodeList = new ArrayList<>();
        for (CalculateVo calculateVo : calculateVos) {
            if (Objects.nonNull(calculateVo.getVariableValueMap())) {
                variableCodeList.addAll(calculateVo.getVariableValueMap().keySet());
            }
        }

        //核销变量编码-名称映射
        Map<String, String> variableNameMap = variableService.getVariableMap(VariableFunctionEnum.AUDIT.getCode(), variableCodeList);

        //核销条件取值
        Map<String, String> conditionValueMap = new HashMap<>();
        //核销公式取值
        Map<String, String> formulaValueMap = new HashMap<>();
        //可核销前提
        List<String> canAuditPreList = new ArrayList<>();
        auditFormulaMainVo.getAuditFormulaInfoVoList()
//                .stream().filter(e -> StringUtils.equals(e.getAuditFormulaConditionName(), filterCondition.get()))
            .forEach(formula -> {
                //核销条件
                Set<String> formulaCondition = MathUtil.getFormulaReplace(formula.getAuditFormulaCondition());
                formulaCondition.forEach(v -> {
                    if (conditionValueMap.containsKey(v)) {
                        return;
                    }
                    if (variableValueMap.containsKey(v)) {
                        conditionValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : " + variableValueMap.get(v).toString());
                        return;
                    }
                    conditionValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : ");
                });
                //核销公式
                Set<String> auditFormula = MathUtil.getFormulaReplace(formula.getAuditFormula());
                auditFormula.forEach(v -> {
                    if (formulaValueMap.containsKey(v)) {
                        return;
                    }
                    if (variableValueMap.containsKey(v)) {
                        formulaValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : " + variableValueMap.get(v).toString());
                        return;
                    }
                    formulaValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : ");
                    //查不到数据先默认达标
                    canAuditPreList.add(variableNameMap.getOrDefault(v, v) + "达标");
                });
            });
        detailedForecastDto.setCalParam(JSON.toJSONString(calDto));
        detailedForecastDto.setAuditFormulaCode(auditFormulaMainVo.getAuditFormulaCode());
        detailedForecastDto.setWriteOffConditions(auditFormulaMainVo.getAuditFormulaInfoVoList().stream()
            .filter(e -> StringUtils.equals(e.getAuditFormulaConditionName(), filterCondition.get()))
            .map(AuditFormulaInfoVo::getAuditFormulaConditionName).filter(Objects::nonNull)
            .collect(Collectors.joining(" , ")));
        detailedForecastDto.setWriteOffFormula(auditFormulaMainVo.getAuditFormulaInfoVoList().stream()
            .filter(e -> StringUtils.equals(e.getAuditFormulaConditionName(), filterCondition.get()))
            .map(AuditFormulaInfoVo::getAuditFormulaName).filter(Objects::nonNull)
            .collect(Collectors.joining(" , ")));
        detailedForecastDto.setWriteOffConditionValue(String.join(" , ", conditionValueMap.values()));
        detailedForecastDto.setWriteOffFormulaValue(String.join(" , ", formulaValueMap.values()));
        detailedForecastDto.setEstimatedWriteOffAmount(estimatedWriteOffAmount);
        detailedForecastDto.setWriteOffPremise(String.join(" , ", canAuditPreList));

        //公式查询条件保存
//        this.setCommonQueryParam(detailedForecastDto, paramMap);
    }

    @Transactional(rollbackFor = Exception.class)
    public void insert(DetailedForecastDto detailedForecastDto) {
        DetailedForecastEntity detailedForecastEntity = this.nebulaToolkitService.copyObjectByWhiteList(detailedForecastDto, DetailedForecastEntity.class, null, null);
        detailedForecastEntity.setTenantCode(TenantUtils.getTenantCode());
        detailedForecastEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        detailedForecastEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        detailedForecastEntity.setShowFlag(YesOrNoEnum.YES.getCode());
        if (StringUtils.isNotEmpty(detailedForecastEntity.getYearMonthStr())) {
            detailedForecastEntity.setYearMonthLy(DateUtil.parse(detailedForecastEntity.getYearMonthStr() + "-01 00:00:00", DateUtil.DEFAULT_YEAR_MONTH));
        }
        detailedForecastEntity.setOnlyKey(this.packageOnlyKey(detailedForecastEntity, null));
        // 日志新增
        DetailedForecastLogEventDto logEventDto = new DetailedForecastLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(detailedForecastDto);
        SerializableBiConsumer<DetailedForecastLogEventListener, DetailedForecastLogEventDto> onCreate =
            DetailedForecastLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, DetailedForecastLogEventListener.class, onCreate);
        log.info("细案编码[{}]明细编码[{}]差异追踪细案预测dto insert", JSON.toJSONString(detailedForecastDto));
        log.info("细案编码[{}]明细编码[{}]差异追踪细案预测insert", JSON.toJSONString(detailedForecastEntity));
        this.detailedForecastRepository.save(detailedForecastEntity);
//        this.detailedForecastMapper.insert(detailedForecastEntity);
    }

    public List<FormulaInfoDto> copyFormulaInfoList(List<AuditFormulaInfoVo> auditFormulaInfoVoList) {
        List<FormulaInfoDto> list = new ArrayList<>();
        auditFormulaInfoVoList.forEach(info -> {
            FormulaInfoDto dto = new FormulaInfoDto();
            dto.setFormulaCode(info.getAuditFormulaCode());
            dto.setFormulaCondition(info.getAuditFormulaCondition());
            dto.setFormulaConditionName(info.getAuditFormulaConditionName());
            dto.setFormula(info.getAuditFormula());
            dto.setFormulaName(info.getAuditFormulaName());
            list.add(dto);
        });
        return list;
    }

    /**
     * onlyKey生成
     *
     * @param entity
     * @return
     */
    public String packageOnlyKey(DetailedForecastEntity entity, String timeStamp) {
        if (StringUtils.isEmpty(timeStamp)) {
            timeStamp = "";
        }
        return DigestUtils.md5Hex(entity.getDetailedCaseCode() + entity.getActivityDetailItemCode() + timeStamp);
    }
}
