/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanListDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.WriteOffMethodEnum;
import com.biz.crm.tpm.business.audit.fee.local.service.perdiction.AuditFeePredictionService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.DataSourceEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="TPM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC${rocketmq.environment}", selectorExpression="TPM_ACTIVITY_DETAIL_PLAN_PASS_AUDIT_FEE_PREDICTION", consumerGroup="TPM_ACTIVITY_DETAIL_PLAN_PASS_AUDIT_FEE_PREDICTION${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class ActivityDetailPlanPassAuditFeePredictionConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailPlanPassAuditFeePredictionConsumer.class);
    @Autowired(required=false)
    private AuditFeePredictionService predictionService;
    @Autowired(required=false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private TerminalVoService terminalVoService;

    protected Object handleMessage(MqMessageVo message) {
        log.info("\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u8d39\u7528\u9884\u6d4b\u7ba1\u7406 order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            List detailPlanCodeList = JSON.parseArray((String)message.getMsgBody(), String.class);
            List dtoList = this.activityDetailPlanSdkService.buildActivityDetailPlanParams(detailPlanCodeList);
            log.info("\u5782\u76f4\u6d3b\u52a8\u7ec6\u6848\u4fe1\u606f\uff1a{}", (Object)dtoList);
            ActivityDetailPlanListDto dto = new ActivityDetailPlanListDto();
            dto.setList(dtoList);
            List<AuditFeePredictionDto> predictionDtoList = this.buildData(dto);
            if (CollectionUtils.isEmpty(predictionDtoList)) {
                return "\u6d88\u8d39\u6210\u529f.";
            }
            this.predictionService.createBatch(predictionDtoList);
        }
        catch (Exception e) {
            log.error(ActivityDetailPlanPassMqTagEnum.PASS_MATERIAL_PURCHASING_ORDER.getName() + "\u5904\u7406\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }

    private List<AuditFeePredictionDto> buildData(ActivityDetailPlanListDto listDto) {
        ArrayList predictionDtoList = Lists.newArrayList();
        if (Objects.isNull(listDto)) {
            return predictionDtoList;
        }
        List activityDetailPlanDtoList = listDto.getList();
        if (CollectionUtils.isEmpty((Collection)activityDetailPlanDtoList)) {
            return predictionDtoList;
        }
        ArrayList itemList = Lists.newArrayList();
        activityDetailPlanDtoList.forEach(activityDetailPlanDto -> itemList.addAll(activityDetailPlanDto.getItemList()));
        Map activityDetailPlanDtoMap = activityDetailPlanDtoList.stream().collect(Collectors.toMap(ActivityDetailPlanBase::getDetailPlanCode, Function.identity()));
        List activityFormCodes = itemList.stream().map(ActivityDetailPlanItemBase::getActivityFormCode).collect(Collectors.toList());
        List activityFormVos = this.activityFormService.findByCodes(activityFormCodes);
        List<ActivityDetailPlanItemDto> itemListTwo = itemList.stream().filter(a -> StringUtils.isEmpty((CharSequence)a.getWriteOffMethod()) || StringUtils.equals((CharSequence)a.getWriteOffMethod(), (CharSequence)WriteOffMethodEnum.AFTER_THE_EVENT.getCode())).collect(Collectors.toList());
        Map activityFormVoMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
        List terminalCodes = itemList.stream().map(ActivityDetailPlanItemBase::getTerminalCode).collect(Collectors.toList());
        List terminalVos = this.terminalVoService.findByTerminalCodes(terminalCodes);
        HashMap terminalVoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)terminalVos)) {
            terminalVoMap.putAll(terminalVos.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity())));
        }
        itemListTwo.forEach(item -> {
            ActivityFormVo activityFormVo;
            if (activityFormVoMap.containsKey(item.getActivityFormCode()) && (activityFormVo = (ActivityFormVo)activityFormVoMap.get(item.getActivityFormCode())).getIsSupermarketDeductionItem().booleanValue()) {
                AuditFeePredictionDto dto = (AuditFeePredictionDto)this.nebulaToolkitService.copyObjectByWhiteList(item, AuditFeePredictionDto.class, HashSet.class, ArrayList.class, new String[0]);
                dto.setId(null);
                if (activityDetailPlanDtoMap.containsKey(item.getDetailPlanCode())) {
                    dto.setDetailPlanName(((ActivityDetailPlanDto)activityDetailPlanDtoMap.get(item.getDetailPlanCode())).getDetailPlanName());
                }
                if (terminalVoMap.containsKey(item.getTerminalCode())) {
                    dto.setProvinceCode(((TerminalVo)terminalVoMap.get(item.getTerminalCode())).getProvinceCode());
                    dto.setProvinceName(((TerminalVo)terminalVoMap.get(item.getTerminalCode())).getProvinceName());
                }
                dto.setCustomerCode(item.getCustomerErpCode());
                dto.setApplyAmount(item.getFeeAmount());
                dto.setSalesInstitutionCode(item.getSalesInstitutionErpCode());
                dto.setSalesInstitutionName(item.getActivityOrgName());
                dto.setActivityYearMonth(item.getActivityBeginDate());
                dto.setDataSource(DataSourceEnum.ACTIVITY_DETAIL.getCode());
                dto.setWholeAudit(YesOrNoEnum.NO.getCode());
                dto.setRollbackBudgetTag(item.getRollbackBudgetTag());
                dto.setIsClose(YesOrNoEnum.NO.getCode());
                dto.setRetailerChannel(item.getRetailerChannel());
                dto.setActivityFormDesc(item.getRemark());
                predictionDtoList.add(dto);
            }
        });
        return predictionDtoList;
    }
}

