/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.prediction.AuditFeePredictionVoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="TPM_ACTIVITY_DETAIL_PLAN_ROLLBACK_TOPIC${rocketmq.environment}", selectorExpression="ROLLBACK_AUDIT_FEE_PREDICTION", consumerGroup="ROLLBACK_AUDIT_FEE_PREDICTION${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class ActivityDetailPlanRollbackPushPredictionConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(ActivityDetailPlanRollbackPushPredictionConsumer.class);
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired
    private AuditFeePredictionVoService voService;

    protected Object handleMessage(MqMessageVo message) {
        log.info("\u6d3b\u52a8\u7ec6\u6848\u56de\u9000\u9884\u7b97\u72b6\u6001\u63a8\u9001\u8d39\u7528\u9884\u6d4b\u7ba1\u7406 order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        List businessNoList = JSON.parseArray((String)message.getMsgBody(), String.class);
        List voList = this.activityDetailPlanItemSdkService.listByItemCodeList(businessNoList);
        log.info("\u5782\u76f4\u6d3b\u52a8\u7ec6\u6848\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)voList));
        ArrayList dtos = Lists.newArrayList();
        voList.forEach(e -> {
            AuditFeePredictionDto predictionDto = new AuditFeePredictionDto();
            predictionDto.setRollbackBudgetTag(e.getRollbackBudgetTag());
            predictionDto.setDetailPlanItemCode(e.getDetailPlanItemCode());
            dtos.add(predictionDto);
        });
        this.voService.updateRollbackBudgetTag((List)dtos);
        return "\u6d88\u8d39\u6210\u529f.";
    }
}

