/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeMatchDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckVoService;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="AUDIT_FEE_CHECK_MATCH_JOB_TOPIC${rocketmq.environment}", selectorExpression="AUDIT_FEE_CHECK_MATCH_JOB_TAG", consumerGroup="AUDIT_FEE_CHECK_MATCH_JOB_TAG${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class AuditFeeCheckMatchJobConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckMatchJobConsumer.class);
    @Autowired(required=false)
    private AuditFeeCheckVoService auditFeeCheckVoService;

    protected Object handleMessage(MqMessageVo message) {
        try {
            String msgBody = message.getMsgBody();
            log.info("---------------------------------------------\u3010\u5546\u8d85\u8d39\u7528\u5339\u914d\u7ec6\u6848 matchFee\u3011\u6d88\u606f\u5f00\u59cb\u6267\u884c------------------------------------------------------------------------------------------------" + msgBody + "-----------------------------------");
            AuditFeeMatchDto matchDto = (AuditFeeMatchDto)JSON.parseObject((String)msgBody, AuditFeeMatchDto.class);
            this.auditFeeCheckVoService.matchFee(matchDto);
            log.info("---------------------------------------------\u3010\u5546\u8d85\u8d39\u7528\u5339\u914d\u7ec6\u6848 matchFee\u3011\u6d88\u606f\u6267\u884c\u7ed3\u675f------------------------------------------------------------------------------------------------" + msgBody + "-----------------------------------");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return "\u6d88\u8d39\u6210\u529f";
    }
}

