/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.consumer;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.audit.fee.local.util.AuditFeeDiffTrackPassDetailedForecastBuilder;
import com.biz.crm.tpm.business.audit.fee.local.util.AuditFeeDiffTrackPassDetailedForecastUtil;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackForecastDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffTrackPassMqTagEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackVoService;
import com.biz.crm.tpm.business.detailed.forecast.local.util.ActivityDetailPlanPassDetailedForecastUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@RocketMQMessageListener(topic="TPM_AUDIT_FEE_DIFF_TRACK_PROCESS_PASS_TOPIC${rocketmq.environment}", selectorExpression="TPM_AUDIT_FEE_DIFF_TRACK_PASS_DETAILED_FORECAST", consumerGroup="TPM_AUDIT_FEE_DIFF_TRACK_PASS_DETAILED_FORECAST${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class AuditFeeDiffTrackPassDetailedForecastConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffTrackPassDetailedForecastConsumer.class);
    @Autowired(required=false)
    private AuditFeeDiffTrackVoService auditFeeDiffTrackVoService;
    @Autowired(required=false)
    private ActivityDetailPlanPassDetailedForecastUtil activityDetailPlanPassDetailedForecastUtil;
    @Autowired(required=false)
    private AuditFeeDiffTrackPassDetailedForecastUtil auditFeeDiffTrackPassDetailedForecastUtil;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;

    protected Object handleMessage(MqMessageVo message) {
        log.info("\u5dee\u5f02\u8ffd\u8e2a\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u7ec6\u6848\u9884\u6d4b\u8868 order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            List businessNoList = JSON.parseArray((String)message.getMsgBody(), String.class);
            List dtoList = this.auditFeeDiffTrackVoService.buildAuditFeeDiffTrackPlanParams(businessNoList);
            UserIdentity loginUser = this.loginUserService.getLoginUser();
            if (!CollectionUtils.isEmpty((Collection)dtoList)) {
                Map regionMap = this.dictToolkitService.findMapByDictTypeCode("MDM_CUSTOMIZE_ORG");
                dtoList.forEach(trackDetailPlanDto -> {
                    List customerVos;
                    if (Objects.isNull(trackDetailPlanDto) || CollectionUtil.isEmpty((Collection)trackDetailPlanDto.getItemList())) {
                        return;
                    }
                    List cusCodes = trackDetailPlanDto.getItemList().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCustomerCode())).map(AuditFeeDiffTrackDetailDto::getCustomerCode).distinct().collect(Collectors.toList());
                    HashMap<String, CustomerVo> customerVoMap = new HashMap<String, CustomerVo>();
                    if (!CollectionUtils.isEmpty(cusCodes) && !CollectionUtils.isEmpty((Collection)(customerVos = this.customerVoService.findBaseByCustomerCodes(cusCodes)))) {
                        customerVoMap.putAll(customerVos.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getErpCode())).collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v)));
                    }
                    List salesOrgCodes = trackDetailPlanDto.getItemList().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getActivityOrgCode())).map(AuditFeeDiffTrackDetailDto::getActivityOrgCode).distinct().collect(Collectors.toList());
                    HashMap<String, SalesOrgAllParentVo> salesOrgVoMap = new HashMap<String, SalesOrgAllParentVo>();
                    if (!CollectionUtils.isEmpty(salesOrgCodes)) {
                        List list = this.salesOrgVoService.findSalesOrgIncludeAllParentByCodes(salesOrgCodes);
                        salesOrgVoMap.putAll(list.stream().collect(Collectors.toMap(SalesOrgAllParentVo::getCurrSalesOrgCode, v -> v, (v1, v2) -> v2)));
                    }
                    trackDetailPlanDto.getItemList().forEach(item -> {
                        SalesOrgAllParentVo salesOrgAllParentVo = null;
                        if (StringUtils.isNotEmpty((CharSequence)item.getActivityOrgCode())) {
                            salesOrgAllParentVo = (SalesOrgAllParentVo)salesOrgVoMap.get(item.getActivityOrgCode());
                        }
                        CustomerVo customerVo = null;
                        if (StringUtils.isNotEmpty((CharSequence)item.getCustomerCode())) {
                            customerVo = (CustomerVo)customerVoMap.get(item.getCustomerCode());
                        }
                        DetailedForecastDto detailedForecastDto = AuditFeeDiffTrackPassDetailedForecastBuilder.buildUnit1Dto(trackDetailPlanDto, item, regionMap, customerVo, salesOrgAllParentVo);
                        log.info("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u5dee\u5f02\u8ffd\u8e2a\u7ec6\u6848\u9884\u6d4b\u4f7f\u7528\u7ec6\u6848", (Object)JSON.toJSONString((Object)item));
                        log.info("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u5dee\u5f02\u8ffd\u8e2a\u7ec6\u6848\u9884\u6d4b\u9884\u6d4b\u6570\u636einit", (Object)JSON.toJSONString((Object)detailedForecastDto));
                        if (StringUtils.equals((CharSequence)trackDetailPlanDto.getBusinessUnitCode(), (CharSequence)BusinessUnitEnum.HEADQUARTERS.getCode())) {
                            try {
                                this.auditFeeDiffTrackPassDetailedForecastUtil.buildUnit1Param((AuditFeeDiffTrackForecastDto)trackDetailPlanDto, detailedForecastDto, (AuditFeeDiffTrackDetailDto)item, loginUser);
                            }
                            catch (Exception e) {
                                log.error("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u7ec6\u6848\u9884\u6d4b\u751f\u6210\u5931\u8d25\uff1a{}", new Object[]{detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), e.getMessage()});
                                e.printStackTrace();
                            }
                        } else if (StringUtils.equals((CharSequence)trackDetailPlanDto.getBusinessUnitCode(), (CharSequence)BusinessUnitEnum.VERTICAL.getCode())) {
                            try {
                                this.auditFeeDiffTrackPassDetailedForecastUtil.buildUnit3Param(detailedForecastDto, (AuditFeeDiffTrackDetailDto)item, loginUser);
                            }
                            catch (Exception e) {
                                log.error("\u7ec6\u6848\u7f16\u7801[{}]\u660e\u7ec6\u7f16\u7801[{}]\u7ec6\u6848\u9884\u6d4b\u751f\u6210\u5931\u8d25\uff1a{}", new Object[]{detailedForecastDto.getDetailedCaseCode(), detailedForecastDto.getActivityDetailItemCode(), e.getMessage()});
                                e.printStackTrace();
                            }
                        }
                    });
                });
            }
        }
        catch (Exception e) {
            log.error(AuditFeeDiffTrackPassMqTagEnum.PASS_DETAILED_FORECAST.getName() + "\u5904\u7406\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }
}

