/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.audit.fee.local.service.perdiction.AuditFeePredictionService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.DataSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.enums.SubComActivityDetailPlanPassMqTagEnum;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_PROCESS_PASS_TOPIC${rocketmq.environment}", selectorExpression="TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_PASS_AUDIT_FEE_PREDICTION", consumerGroup="TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_PASS_AUDIT_FEE_PREDICTION${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class SubComActivityDetailPlanPassAuditFeePredictionConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDetailPlanPassAuditFeePredictionConsumer.class);
    @Autowired(required=false)
    private AuditFeePredictionService predictionService;
    @Autowired(required=false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;

    protected Object handleMessage(MqMessageVo message) {
        log.info("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u8d39\u7528\u9884\u6d4b\u7ba1\u7406 order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            List businessNoList = JSON.parseArray((String)message.getMsgBody(), String.class);
            List subDetailPlanList = this.subComActivityDetailPlanVoService.findDetailByPlanCodes(businessNoList);
            log.info("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u4fe1\u606f\uff1a{}", (Object)subDetailPlanList);
            if (CollectionUtils.isEmpty((Collection)subDetailPlanList)) {
                log.error("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u8d39\u7528\u9884\u6d4b\u7ba1\u7406,\u672a\u67e5\u8be2\u5230\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848!");
                return "\u672a\u67e5\u8be2\u5230\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\uff01";
            }
            List<AuditFeePredictionDto> predictionDtoList = this.buildData(subDetailPlanList);
            if (CollectionUtils.isEmpty(predictionDtoList)) {
                log.error("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u8d39\u7528\u9884\u6d4b\u7ba1\u7406,\u6784\u5efa\u8d39\u7528\u9884\u6d4b\u7ba1\u7406\u4fe1\u606f\u5931\u8d25!");
                return "\u6d88\u8d39\u6210\u529f.";
            }
            log.info("\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u5ba1\u6279\u901a\u8fc7\u63a8\u9001\u8d39\u7528\u9884\u6d4b\u7ba1\u7406,\u5f00\u59cb\u4fdd\u5b58\u6d3b\u52a8\u7ec6\u6848\u7684\u8d39\u7528\u9884\u6d4b\u7ba1\u7406:{}", predictionDtoList);
            this.predictionService.createBatch(predictionDtoList);
        }
        catch (Exception e) {
            log.error(SubComActivityDetailPlanPassMqTagEnum.PASS_MATERIAL_PURCHASING_ORDER.getName() + "\u5904\u7406\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }

    private List<AuditFeePredictionDto> buildData(List<SubComActivityDetailPlanVo> subDetailPlanList) {
        ArrayList predictionDtoList = Lists.newArrayList();
        if (Objects.isNull(subDetailPlanList)) {
            return predictionDtoList;
        }
        ArrayList itemList = Lists.newArrayList();
        subDetailPlanList.forEach(subComActivityDetailPlanVo -> itemList.addAll(subComActivityDetailPlanVo.getItemList()));
        Map subComActivityDetailPlanVoMap = subDetailPlanList.stream().collect(Collectors.toMap(SubComActivityDetailPlanVo::getConstituentDetailPlanCode, Function.identity()));
        List activityFormCodes = itemList.stream().map(SubComActivityDetailPlanItemVo::getActivityFormCode).collect(Collectors.toList());
        List activityFormVos = this.activityFormService.findByCodes(activityFormCodes);
        Map activityFormVoMap = activityFormVos.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
        itemList.forEach(item -> {
            ActivityFormVo activityFormVo;
            if (activityFormVoMap.containsKey(item.getActivityFormCode()) && (activityFormVo = (ActivityFormVo)activityFormVoMap.get(item.getActivityFormCode())).getIsSupermarketDeductionItem().booleanValue()) {
                AuditFeePredictionDto dto = (AuditFeePredictionDto)this.nebulaToolkitService.copyObjectByWhiteList(item, AuditFeePredictionDto.class, HashSet.class, ArrayList.class, new String[0]);
                dto.setId(null);
                dto.setDataSource(DataSourceEnum.SON_ACTIVITY_DETAIL.getCode());
                dto.setActivityYearMonth(item.getFeeYearMonth());
                dto.setSystemCode(item.getResaleCommercialCode());
                dto.setSystemName(item.getResaleCommercialName());
                dto.setActivityBeginDate(item.getActivityBeginTime());
                dto.setActivityEndDate(item.getActivityEndTime());
                dto.setOrderBeginDate(item.getOrderStartDate());
                dto.setDetailPlanItemCode(item.getConstituentDetailPlanItemCode());
                dto.setDetailPlanCode(item.getConstituentDetailPlanCode());
                dto.setDetailPlanName(item.getConstituentDetailPlanName());
                dto.setApplyAmount(item.getTotalCost());
                dto.setWholeAudit(YesOrNoEnum.NO.getCode());
                dto.setRollbackBudgetTag(YesOrNoEnum.NO.getCode());
                dto.setIsClose(YesOrNoEnum.NO.getCode());
                if (StringUtils.isEmpty((CharSequence)dto.getSalesInstitutionCode()) && subComActivityDetailPlanVoMap.containsKey(item.getConstituentDetailPlanCode())) {
                    dto.setSalesInstitutionCode(((SubComActivityDetailPlanVo)subComActivityDetailPlanVoMap.get(item.getConstituentDetailPlanCode())).getSalesInstitutionCode());
                    dto.setSalesInstitutionName(((SubComActivityDetailPlanVo)subComActivityDetailPlanVoMap.get(item.getConstituentDetailPlanCode())).getSalesInstitutionName());
                }
                predictionDtoList.add(dto);
            }
        });
        return predictionDtoList;
    }
}

