/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.controller.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckSelectDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeMatchDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6838\u9500\u8d39\u7528\u6838\u5bf9\u4e3b\u8868"})
@RestController
@RequestMapping(value={"/v1/auditFeeCheck/auditFeeCheck"})
public class AuditFeeCheckController {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckController.class);
    @Resource
    private AuditFeeCheckVoService auditFeeCheckVoService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<AuditFeeCheckVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, AuditFeeCheckDto paginationDto) {
        try {
            Page result = this.auditFeeCheckVoService.findByConditions(pageable, paginationDto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<AuditFeeCheckVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            AuditFeeCheckVo auditFeeCheckVo = this.auditFeeCheckVoService.findDetailById(id);
            return Result.ok((Object)auditFeeCheckVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<AuditFeeCheckVo> update(@RequestBody AuditFeeCheckVo auditFeeCheckVo) {
        try {
            AuditFeeCheckVo current = this.auditFeeCheckVoService.update(auditFeeCheckVo, true);
            return Result.ok((Object)current);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.auditFeeCheckVoService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.auditFeeCheckVoService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.auditFeeCheckVoService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u62bd\u53d6\u6838\u5bf9\u6570\u636e")
    @PostMapping(value={"/pullKmsData"})
    public Result<?> pullKmsData(@RequestBody AuditFeeMatchDto auditFeeMatchDto) {
        try {
            this.auditFeeCheckVoService.pullKmsData(auditFeeMatchDto);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f,\u6b63\u5728\u83b7\u53d6\u6570\u636e\u4e2d...");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u62bd\u53d6\u6838\u5bf9\u6570\u636e\u5b9a\u65f6\u4efb\u52a1")
    @PostMapping(value={"/pullKmsDataAndMatchTask"})
    public Result<?> pullKmsDataAndMatchTask() {
        try {
            this.auditFeeCheckVoService.pullKmsDataAndMatchTask();
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f,\u6b63\u5728\u83b7\u53d6\u6570\u636e\u4e2d...");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u5de5\u5339\u914d")
    @PostMapping(value={"/matchFee"})
    public Result<?> matchFee(@RequestBody AuditFeeMatchDto auditFeeMatchDto) {
        try {
            this.auditFeeCheckVoService.manualMatchFee(auditFeeMatchDto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u5de5\u6267\u884c\u5339\u914d\u4efb\u52a1")
    @GetMapping(value={"/executeJob"})
    public Result<?> executeJob() {
        try {
            this.auditFeeCheckVoService.matchJob();
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f,\u6b63\u5728\u5339\u914d\u4e2d...");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u786e\u8ba4")
    @PatchMapping(value={"/confirm"})
    public Result confirm(@RequestBody AuditFeeCheckVo auditFeeCheckVo) {
        try {
            this.auditFeeCheckVoService.confirm(auditFeeCheckVo);
            return Result.ok((String)"\u786e\u8ba4\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u786e\u8ba4\u5dee\u5f02")
    @PatchMapping(value={"/confirmDiff"})
    public Result confirmDiff(@RequestBody AuditFeeCheckVo vo) {
        try {
            this.auditFeeCheckVoService.confirmDiff(vo);
            return Result.ok((String)"\u786e\u8ba4\u5dee\u5f02\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u9875\u9762\u8c03\u6574\u8ba1\u7b97\u5dee\u5f02")
    @PatchMapping(value={"/compute"})
    public Result compute(@RequestBody AuditFeeCheckVo vo) {
        try {
            return Result.ok((Object)this.auditFeeCheckVoService.compute(vo));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53d6\u6d88\u5339\u914d")
    @PatchMapping(value={"/cancelingMatch"})
    public Result cancelingMatch(@RequestBody String id) {
        try {
            this.auditFeeCheckVoService.cancelingMatch(id);
            return Result.ok((String)"\u53d6\u6d88\u5339\u914d\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8bbe\u7f6e\u5907\u6ce8")
    @PatchMapping(value={"/note"})
    public Result updateNote(@RequestParam(value="id") String id, @RequestBody String note) {
        try {
            this.auditFeeCheckVoService.updateNote(id, note);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u725bE\u8d22\u901a\u67e5\u8be2\u8d39\u7528\u6838\u5bf9\u6570\u636e")
    @GetMapping(value={"/findByConditionsForEct"})
    public Result<Page<AuditFeeCheckVo>> findByConditionsForEct(@PageableDefault(value=50) Pageable pageable, AuditFeeCheckSelectDto dto) {
        try {
            Page result = this.auditFeeCheckVoService.findByConditionsForEct(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="pos-\u7ec6\u6848\u8d39\u7528\u6c47\u603b\u66f4\u65b0")
    @PostMapping(value={"/posActivityAmountSummary"})
    public Result<?> posActivityAmountSummary(@RequestParam(value="matchCode") String matchCode) {
        try {
            this.auditFeeCheckVoService.posActivityAmountSummary(true, null, matchCode);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5237\u65b0\u7ec6\u6848\u5206\u644a")
    @PostMapping(value={"/detailPlanReshare"})
    public Result<?> detailPlanReshare(@RequestBody AuditFeeCheckVo auditFeeCheckVo) {
        try {
            this.auditFeeCheckVoService.detailPlanReshare(auditFeeCheckVo);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

