/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.controller.check;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeCheckPosPullKmsDataService;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeCheckPosService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.dto.SubComActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.List;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6838\u9500\u8d39\u7528\u6838\u5bf9Pos\u8868\u63a7\u5236\u5c42"})
@RestController
@RequestMapping(value={"/v1/auditFeeCheckPos/auditFeeCheckPos"})
public class AuditFeeCheckPosController {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckPosController.class);
    @Autowired(required=false)
    private AuditFeeCheckPosService auditFeeCheckPosService;
    @Autowired(required=false)
    private AuditFeeCheckPosVoService auditFeeCheckPosVoService;
    @Autowired(required=false)
    private AuditFeeCheckPosPullKmsDataService auditFeeCheckPosPullKmsDataService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisService redisService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8d39\u7528\u6838\u5bf9Pos\u6570\u636e")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<AuditFeeCheckPosVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=20) Pageable pageable, @ApiParam(name="dto", value="\u8d39\u7528\u6838\u5bf9Pos\u6570\u636e") AuditFeeCheckPosDto dto) {
        try {
            Page page = this.auditFeeCheckPosVoService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u660e\u7ec6\u5206\u9875")
    @GetMapping(value={"/findActivityDetailPlanItemPage"})
    public Result<Page<ActivityDetailPlanItemVo>> findActivityDetailPlanItemPage(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=20) Pageable pageable, @ApiParam(name="dto", value="\u8be6\u60c5") @RequestBody ActivityDetailPlanItemDto dto) {
        try {
            Page<ActivityDetailPlanItemVo> page = this.auditFeeCheckPosService.findActivityDetailPlanItemPage(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u5b50\u6d3b\u52a8\u660e\u7ec6\u5206\u9875")
    @GetMapping(value={"/findSubComActivityDetailPlanItemPage"})
    public Result<Page<SubComActivityDetailPlanItemVo>> findSubComActivityDetailPlanItemPage(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=20) Pageable pageable, @ApiParam(name="dto", value="\u8be6\u60c5") @RequestBody SubComActivityDetailPlanItemDto dto) {
        try {
            Page<SubComActivityDetailPlanItemVo> page = this.auditFeeCheckPosService.findSubComActivityDetailPlanItemPage(pageable, dto);
            return Result.ok(page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping
    public Result<?> update(@ApiParam(name="dto", value="\u5bf9\u8c61") @RequestBody AuditFeeCheckPosDto dto) {
        try {
            this.auditFeeCheckPosService.update(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findByIdOrCode"})
    public Result<AuditFeeCheckPosVo> findByIdOrCode(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam(value="id", required=false) String id, @ApiParam(name="matchCode", value="\u6263\u8d39\u5339\u914d\u5355\u53f7") @RequestParam(value="matchCode", required=false) String matchCode) {
        try {
            return Result.ok((Object)this.auditFeeCheckPosVoService.findByIdOrCode(id, matchCode));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7f16\u8f91\u5907\u6ce8")
    @PostMapping(value={"/updateRemark"})
    public Result<?> updateRemark(@ApiParam(name="dto", value="pos") @RequestBody AuditFeeCheckPosDto dto) {
        try {
            this.auditFeeCheckPosVoService.updateRemark(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53d6\u6d88\u5339\u914d")
    @PostMapping(value={"/cancelMatch"})
    public Result<?> cancelMatch(@ApiParam(name="dto", value="pos") @RequestBody AuditFeeCheckPosDto dto) {
        try {
            this.auditFeeCheckPosVoService.cancelMatch(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5dee\u5f02\u6838\u5bf9\u83b7\u53d6\u6570\u636e")
    @PostMapping(value={"/findDiffCheckDataList"})
    public Result<List<AuditFeeCheckPosVo>> findDiffCheckDataList(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            return Result.ok((Object)this.auditFeeCheckPosVoService.findDiffCheckDataList(ids));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6682\u5b58")
    @PostMapping(value={"/tempSave"})
    public Result<?> tempSave(@ApiParam(name="dtoList", value="\u6570\u636e\u96c6\u5408") @RequestBody List<AuditFeeCheckPosDto> dtoList) {
        try {
            this.auditFeeCheckPosVoService.tempSave(dtoList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u786e\u8ba4\u5339\u914d")
    @PostMapping(value={"/sureMatch"})
    public Result<?> sureMatch(@ApiParam(name="dtoList", value="\u6570\u636e\u96c6\u5408") @RequestBody List<AuditFeeCheckPosDto> dtoList) {
        try {
            this.auditFeeCheckPosVoService.sureMatch(dtoList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5339\u914d\u6d3b\u52a8")
    @PostMapping(value={"/matchActivity"})
    public Result<?> matchActivity(@ApiParam(name="dto", value="\u6570\u636e\u96c6\u5408") @RequestBody AuditFeeCheckPosDto dto) {
        try {
            this.auditFeeCheckPosVoService.matchActivity(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u62c9\u53d6KMS\u6570\u636e")
    @GetMapping(value={"/pullKmsDataAsync"})
    public Result<?> pullKmsDataAsync(@ApiParam(name="beginDateStr", value="POS\u6570\u636e\u4fee\u6539\u65f6\u95f4\u5f00\u59cb") @RequestParam(value="beginDateStr") String beginDateStr, @ApiParam(name="endDateStr", value="POS\u6570\u636e\u4fee\u6539\u65f6\u95f4\u7ed3\u675f") @RequestParam(value="endDateStr", required=false) String endDateStr) {
        try {
            Date beginDate = DateUtil.parseDate((String)beginDateStr, (String)"yyyy-MM-dd");
            Assert.notNull((Object)beginDate, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u5408\u6cd5,\u683c\u5f0f\u987b\u4e3a[yyyy-MM-dd]!");
            Date endDate = null;
            if (StringUtil.isNotEmpty((CharSequence)endDateStr)) {
                endDate = DateUtil.parseDate((String)endDateStr, (String)"yyyy-MM-dd");
                Assert.notNull((Object)endDate, (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u5408\u6cd5,\u683c\u5f0f\u987b\u4e3a[yyyy-MM-dd]!");
            }
            String yearMonthDay = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
            String lockKey = "audit_fee:update_kms_pos:lock:" + yearMonthDay;
            boolean hasKey = this.redisService.hasKey(lockKey);
            Assert.isTrue((!hasKey ? 1 : 0) != 0, (String)("\u4e0a\u6b21\u64cd\u4f5c[" + yearMonthDay + "]\u8fd8\u672a\u5b8c\u6210,\u672c\u6b21\u4e0d\u6267\u884c!"));
            AbstractCrmUserIdentity userIdentity = this.loginUserService.getAbstractLoginUser();
            this.auditFeeCheckPosPullKmsDataService.pullKmsDataAsync(userIdentity, beginDateStr, endDateStr);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

