/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.controller.dispose;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeCorrelationDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeProcessDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeVo;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6838\u9500\u5dee\u5f02\u8d39\u7528\u5904\u7406"})
@RestController
@RequestMapping(value={"/v1/auditFeeDiffDispose/auditFeeDiffDispose"})
public class AuditFeeDiffDisposeController {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffDisposeController.class);
    @Autowired(required=false)
    private AuditFeeDiffDisposeVoService auditFeeDiffDisposeVoService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<AuditFeeDiffDisposeVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, AuditFeeDiffDisposeDto paginationDto) {
        try {
            Page result = this.auditFeeDiffDisposeVoService.findByConditions(pageable, paginationDto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<AuditFeeDiffDisposeVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            AuditFeeDiffDisposeVo auditFeeDiffDisposeVo = this.auditFeeDiffDisposeVoService.findDetailById(id);
            return Result.ok((Object)auditFeeDiffDisposeVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<?> create(@RequestParam(value="cacheKey") String cacheKey, @RequestBody AuditFeeDiffDisposeDto dto) {
        try {
            this.auditFeeDiffDisposeVoService.create(cacheKey, dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<?> update(@RequestParam(value="cacheKey") String cacheKey, @RequestBody AuditFeeDiffDisposeDto dto) {
        try {
            this.auditFeeDiffDisposeVoService.update(cacheKey, dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.auditFeeDiffDisposeVoService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.auditFeeDiffDisposeVoService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.auditFeeDiffDisposeVoService.updateDelFlagByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6279\u91cf\u63d0\u4ea4\u5ba1\u6279\u6d41")
    @PatchMapping(value={"/submitBatchProcess"})
    public Result<?> submitBatchProcess(@RequestBody AuditFeeDiffDisposeProcessDto dto) {
        ArrayList lockSuccessKeyList = Lists.newArrayList();
        try {
            if (CollectionUtils.isEmpty((Collection)dto.getIds())) {
                throw new RuntimeException("\u8bf7\u9009\u62e9\u6570\u636e\uff01");
            }
            for (String id : dto.getIds()) {
                String lockKey = "audit_fee_diff_dispose:lock:approve:" + id;
                boolean lockSuccess = this.redisMutexService.tryLock(lockKey, TimeUnit.HOURS, 1);
                if (!lockSuccess) continue;
                lockSuccessKeyList.add(lockKey);
            }
            this.auditFeeDiffDisposeVoService.submitBatchProcess(dto);
            Result result = Result.ok((String)"\u63d0\u4ea4\u6210\u529f");
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (!CollectionUtils.isEmpty((Collection)lockSuccessKeyList)) {
                for (String lockSuccessKey : lockSuccessKeyList) {
                    this.redisMutexService.unlock(lockSuccessKey);
                }
            }
        }
    }

    @ApiOperation(value="\u5173\u8054\u5dee\u5f02\u8d39\u7528")
    @PatchMapping(value={"/correlation"})
    public Result<?> correlation(@RequestBody AuditFeeDiffDisposeCorrelationDto correlationDto) {
        try {
            this.auditFeeDiffDisposeVoService.correlation(correlationDto);
            return Result.ok((String)"\u63d0\u4ea4\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

