/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.controller.track;

import cn.hutool.core.lang.Snowflake;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigDto;
import com.biz.crm.tpm.business.audit.fee.local.service.imports.AuditFeeDiffTrackDetailImportProcess;
import com.biz.crm.tpm.business.audit.fee.local.service.imports.vo.AuditFeeDiffTrackDetailImportVo;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackApproveSubmitDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackSummaryVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.track.AuditFeeDiffTrackVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5dee\u5f02\u8d39\u7528\u8ffd\u8e2a\u63a7\u5236\u5c42"})
@RestController
@RequestMapping(value={"/v1/auditFeeTrack/auditFeeTrack"})
public class AuditFeeDiffTrackController {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffTrackController.class);
    @Resource
    private AuditFeeDiffTrackVoService auditFeeDiffTrackVoService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private AuditFeeDiffLedgerLockService auditFeeDiffLedgerLockService;
    @Autowired(required=false)
    private AuditFeeDiffTrackDetailImportProcess auditFeeDiffTrackDetailImportProcess;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<AuditFeeDiffTrackVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, AuditFeeDiffTrackDto paginationDto) {
        try {
            Page result = this.auditFeeDiffTrackVoService.findByConditions(pageable, paginationDto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<AuditFeeDiffTrackVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            AuditFeeDiffTrackVo AuditFeeDiffTrackVo2 = this.auditFeeDiffTrackVoService.findById(id);
            return Result.ok((Object)AuditFeeDiffTrackVo2);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u6d41\u7a0b\u8868\u5355")
    @GetMapping(value={"/findDetailByProcessNo"})
    public Result<AuditFeeDiffTrackVo> findDetailByProcessNo(@RequestParam(value="processNo") String processNo) {
        try {
            AuditFeeDiffTrackVo AuditFeeDiffTrackVo2 = this.auditFeeDiffTrackVoService.findDetailByProcessNo(processNo);
            return Result.ok((Object)AuditFeeDiffTrackVo2);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/create"})
    public Result<?> create(@RequestBody AuditFeeDiffTrackDto dto) {
        try {
            this.auditFeeDiffTrackVoService.create(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PatchMapping(value={"/edit"})
    public Result<?> edit(@RequestBody AuditFeeDiffTrackDto dto) {
        try {
            this.auditFeeDiffTrackVoService.edit(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @PatchMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.auditFeeDiffTrackVoService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6d3b\u52a8\u65b9\u6848\u53ef\u4ee5\u9009\u62e9\u7684\u6a21\u677f")
    @PostMapping(value={"findItemColumnConfigSelect"})
    public Result<List<CommonSelectVo>> findItemColumnConfigSelect(@ApiParam(value="\u6a21\u677f\u7f16\u7801") ActivitiesTemplateConfigDto configDto, @ApiParam(value="\u6d3b\u52a8\u7c7b\u578bdto") @RequestBody CommonSelectDto dto) {
        try {
            return Result.ok((Object)this.auditFeeDiffTrackVoService.findActivitiesTemplateConfigSelectList(configDto, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u63d0\u4ea4\u6d41\u7a0b,\u591a\u9009\u6279\u91cf\u63d0\u4ea4")
    @PostMapping(value={"submitApproval"})
    public Result submitApproval(@ApiParam(value="\u63d0\u4ea4\u6d41\u7a0b,\u591a\u9009\u6279\u91cf\u63d0\u4ea4") @RequestBody AuditFeeDiffTrackApproveSubmitDto dto) {
        String key;
        Result result;
        String operateId;
        block10: {
            List ids = dto.getIds();
            boolean lockSuccess = false;
            operateId = new Snowflake().nextIdStr();
            try {
                if (CollectionUtils.isEmpty((Collection)ids)) {
                    throw new RuntimeException("\u8bf7\u9009\u62e9\u6570\u636e\uff01");
                }
                lockSuccess = this.redisLockService.batchLock("audit_fee_diff_track:lock:approve:", ids, TimeUnit.HOURS, 1);
                if (!lockSuccess) {
                    throw new RuntimeException("\u6570\u636e\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e");
                }
                dto.setOperateId(operateId);
                this.auditFeeDiffTrackVoService.submitApproval(dto.getIds(), dto);
                result = Result.ok();
                if (!lockSuccess) break block10;
            }
            catch (Exception e) {
                String key2;
                Result result2;
                block11: {
                    try {
                        log.error(e.getMessage(), (Throwable)e);
                        result2 = Result.error((String)e.getMessage());
                        if (!lockSuccess) break block11;
                    }
                    catch (Throwable throwable) {
                        String key3;
                        if (lockSuccess) {
                            this.redisLockService.batchUnLock("audit_fee_diff_track:lock:approve:", ids);
                        }
                        if (this.redisService.hasKey(key3 = String.format("audit_fee_diff_track_operate:%s", operateId)).booleanValue()) {
                            this.auditFeeDiffLedgerLockService.unlock((List)this.redisService.get(key3));
                            this.redisService.del(key3);
                        }
                        throw throwable;
                    }
                    this.redisLockService.batchUnLock("audit_fee_diff_track:lock:approve:", ids);
                }
                if (this.redisService.hasKey(key2 = String.format("audit_fee_diff_track_operate:%s", operateId)).booleanValue()) {
                    this.auditFeeDiffLedgerLockService.unlock((List)this.redisService.get(key2));
                    this.redisService.del(key2);
                }
                return result2;
            }
            this.redisLockService.batchUnLock("audit_fee_diff_track:lock:approve:", ids);
        }
        if (this.redisService.hasKey(key = String.format("audit_fee_diff_track_operate:%s", operateId)).booleanValue()) {
            this.auditFeeDiffLedgerLockService.unlock((List)this.redisService.get(key));
            this.redisService.del(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5173\u95ed\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6")
    @PostMapping(value={"closeItem"})
    public Result<?> closeItem(@ApiParam(name="ids", value="\u8981\u5220\u9664\u7684\u6570\u636e") @RequestBody List<String> ids) {
        String key;
        Result result;
        String operateId;
        block8: {
            boolean lockSuccess = false;
            operateId = new Snowflake().nextIdStr();
            try {
                lockSuccess = this.redisLockService.batchLock("audit_fee_diff_track:lock:close:", ids, TimeUnit.HOURS, 1);
                Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
                this.auditFeeDiffTrackVoService.close(ids, operateId);
                result = Result.ok();
                if (!lockSuccess) break block8;
            }
            catch (Exception e) {
                String key2;
                Result result2;
                block9: {
                    try {
                        log.error(e.getMessage(), (Throwable)e);
                        result2 = Result.error((String)e.getMessage());
                        if (!lockSuccess) break block9;
                    }
                    catch (Throwable throwable) {
                        String key3;
                        if (lockSuccess) {
                            this.redisLockService.batchUnLock("audit_fee_diff_track:lock:close:", ids);
                        }
                        if (this.redisService.hasKey(key3 = String.format("audit_fee_diff_track_operate:%s", operateId)).booleanValue()) {
                            this.auditFeeDiffLedgerLockService.unlock((List)this.redisService.get(key3));
                            this.redisService.del(key3);
                        }
                        throw throwable;
                    }
                    this.redisLockService.batchUnLock("audit_fee_diff_track:lock:close:", ids);
                }
                if (this.redisService.hasKey(key2 = String.format("audit_fee_diff_track_operate:%s", operateId)).booleanValue()) {
                    this.auditFeeDiffLedgerLockService.unlock((List)this.redisService.get(key2));
                    this.redisService.del(key2);
                }
                return result2;
            }
            this.redisLockService.batchUnLock("audit_fee_diff_track:lock:close:", ids);
        }
        if (this.redisService.hasKey(key = String.format("audit_fee_diff_track_operate:%s", operateId)).booleanValue()) {
            this.auditFeeDiffLedgerLockService.unlock((List)this.redisService.get(key));
            this.redisService.del(key);
        }
        return result;
    }

    @ApiOperation(value="\u6c47\u603b\u5dee\u5f02\u8d39\u7528\u4fe1\u606f")
    @PostMapping(value={"collectDiffAmount"})
    public Result<List<AuditFeeDiffTrackSummaryVo>> collectDiffAmount(@ApiParam(value="id+\u6a21\u677f\u7f16\u7801+\u7f13\u5b58key") @RequestBody AuditFeeDiffTrackDto dto) {
        try {
            List auditFeeDiffTrackSummaryVo = this.auditFeeDiffTrackVoService.collectDiffAmount(dto);
            return Result.ok((Object)auditFeeDiffTrackSummaryVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7533\u8bf7\u91d1\u989d\u6c47\u603b")
    @PostMapping(value={"collectFeeAmount"})
    public Result<?> collectFeeAmount(@ApiParam(value="\u7f13\u5b58key \u53ea\u8981planCode") @RequestBody AuditFeeDiffTrackDto dto) {
        try {
            BigDecimal salesAmount = this.auditFeeDiffTrackVoService.collectFeeAmount(dto);
            return Result.ok((Object)salesAmount);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="testImport")
    @PostMapping(value={"testImport"})
    public Result<?> testImport(@RequestBody LinkedHashMap<Integer, AuditFeeDiffTrackDetailImportVo> data, Map<String, Object> params) {
        try {
            return Result.ok(this.auditFeeDiffTrackDetailImportProcess.execute(data, null, params));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u63a8\u9001\u725b\u4eba\u7ba1\u5bb6\uff0c\u63a8\u9001\u5ba1\u6279\u901a\u8fc7\uff0c\u4f46\u662f\u6ca1\u6709\u725b\u4eba\u7ba1\u5bb6\u63a8\u9001\u6210\u529f\u6807\u8bb0\u7684\u660e\u7ec6\u6570\u636e")
    @PostMapping(value={"pushCowManagerManual"})
    public Result<?> pushCowManagerManual() {
        try {
            this.auditFeeDiffTrackVoService.pushCowManagerManual();
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

