/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.helper;

import cn.hutool.core.date.DateUtil;
import com.alibaba.excel.util.Validate;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeLedgerItemDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeDetailVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeTemplateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class AuditFeeDiffDisposeHelper {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffDisposeHelper.class);
    @Autowired
    private AuditFeeDiffDisposeDetailVoService auditFeeDiffDisposeDetailVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public void verifyEmpty(AuditFeeDiffDisposeDto dto) {
        Assert.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getFeeDiffDisposeName(), (String)"\u5904\u7406\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)dto.getDisposeFeeAmount(), (String)"\u6c47\u603b\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)dto.getTemplates(), (String)"\u6a21\u7248\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void buildDetails(String cacheKey, AuditFeeDiffDisposeDto dto) {
        if (StringUtils.hasText((String)cacheKey)) {
            ArrayList detailDtos = Lists.newArrayList();
            ArrayList ledgerItemDtos = Lists.newArrayList();
            for (AuditFeeDiffDisposeTemplateVo template : dto.getTemplates()) {
                String redisKey = cacheKey + ":" + template.getTemplateConfigCode();
                List cacheDetailDtos = this.auditFeeDiffDisposeDetailVoService.findCacheList(redisKey);
                if (CollectionUtils.isEmpty((Collection)cacheDetailDtos)) continue;
                List noItemCodes = cacheDetailDtos.stream().filter(o -> !StringUtils.hasText((String)o.getDetailPlanItemCode())).collect(Collectors.toList());
                List<String> codes = this.generateDetailCodes(noItemCodes.size());
                AtomicReference<Integer> i = new AtomicReference<Integer>(0);
                cacheDetailDtos.forEach(o -> {
                    BigDecimal thisUseAmount = Optional.ofNullable(o.getThisUseAmount()).orElse(BigDecimal.ZERO);
                    BigDecimal totalFeeAmount = BigDecimal.ZERO;
                    if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)o.getTotalFeeAmountStr())) {
                        try {
                            totalFeeAmount = new BigDecimal(o.getTotalFeeAmountStr().trim());
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u8d39\u7528\u5408\u8ba1[" + o.getTotalFeeAmountStr() + "]");
                        }
                    }
                    Validate.isTrue((thisUseAmount.compareTo(totalFeeAmount) == 0 ? 1 : 0) != 0, (String)"'\u8d39\u7528\u5408\u8ba1' \u4e0e '\u5dee\u5f02\u8d39\u7528\u6c47\u603b\uff08\u5143\uff09'\u5fc5\u987b\u76f8\u540c", (Object[])new Object[0]);
                    o.setFeeDiffDisposeCode(dto.getFeeDiffDisposeCode());
                    o.setFeeDiffDisposeName(dto.getFeeDiffDisposeName());
                    o.setTemplateConfigCode(template.getTemplateConfigCode());
                    o.setTemplateConfigName(template.getTemplateConfigName());
                    if (!StringUtils.hasText((String)o.getDetailPlanItemCode())) {
                        o.setDetailPlanItemCode((String)codes.get((Integer)i.get()));
                        i.set((Integer)i.get() + 1);
                    }
                    List ledgerItems = o.getLedgerItems();
                    Assert.notEmpty((Collection)ledgerItems, (String)"\u5dee\u5f02\u8d39\u7528\u53f0\u5e10\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                    ledgerItems.forEach(ledgerItem -> {
                        AuditFeeDiffDisposeLedgerItemDto itemDto = (AuditFeeDiffDisposeLedgerItemDto)this.nebulaToolkitService.copyObjectByBlankList(ledgerItem, AuditFeeDiffDisposeLedgerItemDto.class, HashSet.class, ArrayList.class, new String[0]);
                        itemDto.setDetailPlanItemCode(o.getDetailPlanItemCode());
                        itemDto.setFeeDiffDisposeCode(o.getFeeDiffDisposeCode());
                        itemDto.setFeeYearMonth(DateUtil.format((Date)o.getFeeYearMonth(), (String)"yyyy-MM"));
                        ledgerItemDtos.add(itemDto);
                    });
                });
                detailDtos.addAll(cacheDetailDtos);
            }
            dto.setDetails((List)detailDtos);
            dto.setLedgerItems((List)ledgerItemDtos);
            this.auditFeeDiffDisposeDetailVoService.clearCache(cacheKey);
        } else {
            List<String> codes = this.generateDetailCodes(dto.getDetails().size());
            AtomicReference<Integer> i = new AtomicReference<Integer>(0);
            dto.getDetails().forEach(o -> {
                o.setFeeDiffDisposeCode(dto.getFeeDiffDisposeCode());
                o.setFeeDiffDisposeName(dto.getFeeDiffDisposeName());
                Assert.hasText((String)o.getTemplateConfigCode(), (String)"\u6a21\u7248\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.hasText((String)o.getTemplateConfigCode(), (String)"\u6a21\u7248\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                o.setDetailPlanItemCode((String)codes.get((Integer)i.get()));
                i.set((Integer)i.get() + 1);
            });
        }
    }

    private List<String> generateDetailCodes(Integer number) {
        return this.generateCodeService.generateCode("FYDL", number.intValue());
    }

    public String generateCode() {
        return (String)this.generateCodeService.generateCode("FYCL", 1).get(0);
    }
}

