/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.helper;

import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDto;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFeeDiffLedgerHelper {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDiffLedgerHelper.class);
    @Autowired(required=false)
    private RedisLockService redisLockService;
    private static final String LOCK_PREFIX = "audit_fee_diff_ledger:lock_code:";

    public void verifyEmpty(AuditFeeDiffLedgerDto dto) {
        Assert.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getAuditFeeCheckCode(), (String)"\u6838\u9500\u8d39\u7528\u6838\u5bf9\u8868\u6263\u8d39\u5339\u914d\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getYear(), (String)"\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getMonth(), (String)"\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)dto.getFeeYearMonth(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)dto.getDiffAmount(), (String)"\u5dee\u5f02\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean batchTryLock(List<String> codes, TimeUnit timeUnit, int time) {
        Assert.notEmpty(codes, (String)"\u52a0\u9501\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (ObjectUtils.isEmpty((Object)((Object)timeUnit))) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        if (time <= 0) {
            time = 1200;
        }
        boolean isLock = true;
        ArrayList<String> successKeys = new ArrayList<String>();
        try {
            for (String code : codes) {
                isLock = this.redisLockService.tryLock(LOCK_PREFIX + code, timeUnit, (long)time);
                if (!isLock) {
                    boolean bl = false;
                    return bl;
                }
                successKeys.add(code);
            }
        }
        finally {
            if (!isLock && !CollectionUtils.isEmpty(successKeys)) {
                successKeys.forEach(key -> this.redisLockService.unlock(LOCK_PREFIX + key));
            }
        }
        return true;
    }

    public void batchUnLock(List<String> codes) {
        Assert.notEmpty(codes, (String)"\u52a0\u9501\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        codes.forEach(code -> this.redisLockService.unlock(LOCK_PREFIX + code));
    }
}

