/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.helper;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckDetailPlanRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckDetailPlanVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFeeSettlementCheckDetailPlanHelper
extends MnPageCacheHelper<AuditFeeSettlementCheckDetailPlanVo, AuditFeeSettlementCheckDetailPlanDto> {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeSettlementCheckDetailPlanHelper.class);
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private AuditFeeSettlementCheckDetailPlanRepository detailPlanRepository;

    public String getCacheKeyPrefix() {
        return "CACHE_PREFIX_DETAIL_PLAN:";
    }

    public Class<AuditFeeSettlementCheckDetailPlanDto> getDtoClass() {
        return AuditFeeSettlementCheckDetailPlanDto.class;
    }

    public Class<AuditFeeSettlementCheckDetailPlanVo> getVoClass() {
        return AuditFeeSettlementCheckDetailPlanVo.class;
    }

    public List<AuditFeeSettlementCheckDetailPlanDto> findDtoListFromRepository(AuditFeeSettlementCheckDetailPlanDto dto, String cacheKey) {
        log.info("\u7f13\u5b58\u67e5\u8be2\u7ec6\u6848\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        if (Objects.isNull(dto) || StringUtils.isEmpty((CharSequence)dto.getCode())) {
            return Lists.newArrayList();
        }
        return this.detailPlanRepository.findDtoByCode(dto.getCode());
    }

    public List<AuditFeeSettlementCheckDetailPlanDto> newItem(String cacheKey, List<AuditFeeSettlementCheckDetailPlanDto> itemList) {
        return itemList;
    }

    public List<AuditFeeSettlementCheckDetailPlanDto> copyItem(String cacheKey, List<AuditFeeSettlementCheckDetailPlanDto> itemList) {
        return itemList;
    }

    public Object getDtoKey(AuditFeeSettlementCheckDetailPlanDto dto) {
        return dto.getDetailPlanItemCode();
    }

    public String getCheckedStatus(AuditFeeSettlementCheckDetailPlanDto dto) {
        return dto.getChecked();
    }

    public void filterSaveItem(String cacheKey, List<Object> idList, List<AuditFeeSettlementCheckDetailPlanDto> itemList, List<AuditFeeSettlementCheckDetailPlanDto> updateList) {
        if (CollectionUtils.isEmpty(idList) || CollectionUtils.isEmpty(itemList)) {
            return;
        }
        itemList.removeIf(e -> idList.contains(this.getDtoKey((AuditFeeSettlementCheckDetailPlanDto)e)));
    }

    public void doSaveNewKey(String cacheKey, Object[] newIdArr) {
        if (newIdArr.length == 0) {
            return;
        }
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        ArrayList<String> idStrList = new ArrayList<String>();
        List idList = this.redisService.lRange(redisCacheIdKey, 0L, -1L);
        for (Object id : idList) {
            this.redisService.lRemove(redisCacheIdKey, 0L, id);
            idStrList.add((String)id);
        }
        for (Object o : newIdArr) {
            idStrList.add((String)o);
        }
        log.info("\u6d3b\u52a8\u6392\u5e8f\u524d:{}", (Object)Arrays.toString(idStrList.toArray()));
        Collections.sort(idStrList);
        log.info("\u6d3b\u52a8\u6392\u5e8f\u540e:{}", (Object)Arrays.toString(idStrList.toArray()));
        this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), idStrList.toArray());
    }
}

