/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.helper;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.kms.business.audit.fee.sdk.service.statement.AuditFeeStatementService;
import com.biz.crm.kms.business.audit.fee.sdk.vo.AuditFeeRespVo;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckSettlementRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckSettlementDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckSettlementVo;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFeeSettlementCheckSettlementHelper
extends MnPageCacheHelper<AuditFeeSettlementCheckSettlementVo, AuditFeeSettlementCheckSettlementDto> {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeSettlementCheckSettlementHelper.class);
    @Autowired
    private AuditFeeSettlementCheckSettlementRepository settlementRepository;
    @Autowired
    private AuditFeeStatementService auditFeeStatementService;

    public String getCacheKeyPrefix() {
        return "CACHE_PREFIX_SETTLEMENT:";
    }

    public Class<AuditFeeSettlementCheckSettlementDto> getDtoClass() {
        return AuditFeeSettlementCheckSettlementDto.class;
    }

    public Class<AuditFeeSettlementCheckSettlementVo> getVoClass() {
        return AuditFeeSettlementCheckSettlementVo.class;
    }

    public List<AuditFeeSettlementCheckSettlementDto> findDtoListFromRepository(AuditFeeSettlementCheckSettlementDto dto, String cacheKey) {
        log.info("\u7f13\u5b58\uff0c\u6570\u636e\u5e93\u67e5\u8be2\u5199\u5165\u7f13\u5b58\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        if (Objects.isNull(dto) || StringUtils.isEmpty((CharSequence)dto.getCode())) {
            return Lists.newArrayList();
        }
        List<AuditFeeSettlementCheckSettlementDto> list = this.settlementRepository.findAllByCode(dto.getCode());
        return list;
    }

    private void kmsToTpm(AuditFeeSettlementCheckSettlementDto e, AuditFeeRespVo kmsSettlement) {
        e.setBusinessArea(kmsSettlement.getBusinessArea());
        e.setDirectCode(kmsSettlement.getCustomerRetailerCode());
        e.setSupermarketName(kmsSettlement.getCustomerRetailerName());
        e.setProvinceCode(kmsSettlement.getProvinceCode());
        e.setProvinceName(kmsSettlement.getProvinceName());
        e.setDeliveryPartyCode(kmsSettlement.getDeliveryPartyCode());
        e.setDeliveryPartyName(kmsSettlement.getDeliveryPartyName());
        e.setProductCode(kmsSettlement.getProductCode());
        e.setProductName(kmsSettlement.getProductName());
        e.setSlotDateName(kmsSettlement.getSlotDateName());
        e.setOrderDate(kmsSettlement.getOrderDate());
        e.setOrderYearMonth(kmsSettlement.getOrderYearMonth());
        e.setDeductionName(kmsSettlement.getDeductionName());
        e.setAuditWay(kmsSettlement.getAuditWay());
        e.setAmount(kmsSettlement.getAmount());
    }

    public List<AuditFeeSettlementCheckSettlementDto> newItem(String cacheKey, List<AuditFeeSettlementCheckSettlementDto> itemList) {
        return itemList;
    }

    public List<AuditFeeSettlementCheckSettlementDto> copyItem(String cacheKey, List<AuditFeeSettlementCheckSettlementDto> itemList) {
        return itemList;
    }

    public Object getDtoKey(AuditFeeSettlementCheckSettlementDto dto) {
        return dto.getId();
    }

    public String getCheckedStatus(AuditFeeSettlementCheckSettlementDto dto) {
        return dto.getChecked();
    }

    public void filterSaveItem(String cacheKey, List<Object> idList, List<AuditFeeSettlementCheckSettlementDto> itemList, List<AuditFeeSettlementCheckSettlementDto> updateList) {
        if (CollectionUtils.isEmpty(idList) || CollectionUtils.isEmpty(itemList)) {
            return;
        }
        itemList.removeIf(e -> idList.contains(this.getDtoKey((AuditFeeSettlementCheckSettlementDto)e)));
        for (AuditFeeSettlementCheckSettlementDto dto : itemList) {
            if (dto.getTpmDeductionCode() == null) continue;
            dto.setSettlementDetailCode(dto.getTpmDeductionCode());
        }
    }
}

