/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.job;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.audit.fee.local.service.AuditFeeCheckPosPullKmsDataService;
import com.biz.crm.tpm.business.audit.fee.local.service.internal.check.async.AuditFeeCheckPosMatchActivityServiceImpl;
import com.biz.crm.tpm.business.audit.fee.sdk.constants.AuditFeeCheckPosConstants;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckPosVoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AuditFeeCheckPosJob {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeCheckPosJob.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private AuditFeeCheckPosVoService auditFeeCheckPosVoService;
    @Autowired(required=false)
    private AuditFeeCheckPosPullKmsDataService auditFeeCheckPosPullKmsDataService;
    @Autowired(required=false)
    private AuditFeeCheckPosMatchActivityServiceImpl auditFeeCheckPosMatchActivityServiceImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DynamicTaskService(cornExpression="0 10 0 * * ?", taskDesc="\u6bcf\u65e50:10 \u6267\u884c\u4e00\u6b21\u66f4\u65b0POS\u6d3b\u52a8\u6838\u5bf9\u7684KMS\u6570\u636e")
    public void updateKmsDataJob() {
        this.loginUserService.refreshAuthentication(null);
        String yearMonthDay = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        String lockKey = "audit_fee:update_kms_pos:lock:" + yearMonthDay;
        boolean lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 4L);
        Assert.isTrue((boolean)lockSuccess, (String)("\u4e0a\u6b21\u64cd\u4f5c[" + yearMonthDay + "]\u8fd8\u672a\u5b8c\u6210,\u672c\u6b21\u4e0d\u6267\u884c!"));
        try {
            this.auditFeeCheckPosPullKmsDataService.pullKmsData(null, null);
        }
        catch (Exception e) {
            log.error("\u62c9\u53d6KMS\u7684POS\u6570\u636e\u65f6\u5f02\u5e38");
            log.error("", (Throwable)e);
        }
        finally {
            this.redisLockService.unlock(lockKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DynamicTaskService(cornExpression="0 0 6 * * ?", taskDesc="\u6bcf\u65e506:00 \u6267\u884c\u4e00\u6b21TPM-POS\u5339\u914d\u6d3b\u52a8")
    public void posMatchActivityJob() {
        this.loginUserService.refreshAuthentication(null);
        Date dateNow = new Date();
        String yearMonthDay = DateUtil.format((Date)dateNow, (String)"yyyy-MM-dd");
        String lockKey = "audit_fee:update_kms_pos:lock:" + yearMonthDay;
        boolean lockSuccess = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 4L);
        Assert.isTrue((boolean)lockSuccess, (String)("\u4e0a\u6b21\u64cd\u4f5c[" + yearMonthDay + "]\u8fd8\u672a\u5b8c\u6210,\u672c\u6b21\u4e0d\u6267\u884c!"));
        PageRequest pageable = PageRequest.of((int)1, (int)600);
        AuditFeeCheckPosDto selectDto = new AuditFeeCheckPosDto();
        selectDto.setIsMatchActivity(BooleanEnum.FALSE.getCapital());
        selectDto.setModifyTimeBegin(DateUtil.formatDate((Date)DateUtil.dateAddDay((Date)new Date(), (Integer)AuditFeeCheckPosConstants.AUDIT_FEE_KMS_POS_DAY), (String)"yyyy-MM-dd"));
        selectDto.setTenantCode(TenantUtils.getTenantCode());
        try {
            Page page = null;
            do {
                try {
                    page = this.auditFeeCheckPosVoService.findByConditions((Pageable)pageable, selectDto);
                    log.info("POS\u5339\u914d\u6d3b\u52a8\u5b9a\u65f6\u4efb\u52a1 start [{}/{}]", (Object)page.getCurrent(), (Object)page.getPages());
                    this.auditFeeCheckPosMatchActivityServiceImpl.posMatchActivity(null, page.getRecords());
                    pageable = pageable.next();
                }
                catch (Exception e) {
                    if (Objects.isNull(page)) {
                        page = new Page();
                    }
                    log.info("POS\u5339\u914d\u6d3b\u52a8\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38,\u5f53\u524d\u5904\u7406\u9875:[{}/{}]", (Object)page.getCurrent(), (Object)page.getPages());
                    log.error("", (Throwable)e);
                }
                log.info("POS\u5339\u914d\u6d3b\u52a8\u5b9a\u65f6\u4efb\u52a1 end [{}/{}]", (Object)page.getCurrent(), (Object)page.getPages());
            } while (page.hasNext());
        }
        catch (Exception e) {
            log.error("POS\u5339\u914d\u6d3b\u52a8\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25{}", (Object)e.getMessage());
            log.error("", (Throwable)e);
        }
        finally {
            this.redisLockService.unlock(lockKey);
        }
    }
}

