/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.listener;

import cn.hutool.core.lang.Snowflake;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.rocketmq.event.RocketMqProducerEvent;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditFeeDiffTrackPassMqTagEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerLockService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.track.AuditFeeDiffTrackVoService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFeeDIffTrackProcessCompleteListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(AuditFeeDIffTrackProcessCompleteListener.class);
    @Autowired(required=false)
    private AuditFeeDiffTrackVoService auditFeeDiffTrackVoService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Resource
    private ApplicationEventPublisher eventPublisher;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private AuditFeeDiffLedgerLockService auditFeeDiffLedgerLockService;

    public String getBusinessCode() {
        return "audit_fee_diff_track";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProcessComplete(ProcessStatusDto dto) {
        String key;
        String operateId;
        block6: {
            log.info("\u5dee\u5f02\u8d39\u7528\u8ffd\u8e2a\u5ba1\u6279\u7ed3\u675f,{}", (Object)JSON.toJSONString((Object)dto));
            if (StringUtils.isEmpty((CharSequence)dto.getBusinessNo())) {
                return;
            }
            operateId = new Snowflake().nextIdStr();
            try {
                String processStatus = dto.getProcessStatus();
                Validate.notEmpty((CharSequence)dto.getProcessNo(), (String)"\u6d41\u7a0b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
                    this.auditFeeDiffTrackVoService.processPass(dto);
                    this.passPushMq(dto.getProcessNo(), dto.getBusinessNoList());
                }
                if (!ProcessStatusEnum.REJECT.getDictCode().equals(processStatus) && !ProcessStatusEnum.RECOVER.getDictCode().equals(processStatus)) break block6;
                log.info("\u8ffd\u8e2a\u9a73\u56de\u5566\uff5e\uff5e");
                this.auditFeeDiffTrackVoService.processRejectAndRecover(dto, operateId);
            }
            catch (Throwable throwable) {
                String key2 = String.format("audit_fee_diff_track_operate:%s", operateId);
                if (this.redisService.hasKey(key2).booleanValue()) {
                    this.auditFeeDiffLedgerLockService.unlock((List)this.redisService.get(key2));
                    this.redisService.del(key2);
                }
                throw throwable;
            }
        }
        if (this.redisService.hasKey(key = String.format("audit_fee_diff_track_operate:%s", operateId)).booleanValue()) {
            this.auditFeeDiffLedgerLockService.unlock((List)this.redisService.get(key));
            this.redisService.del(key);
        }
    }

    private void passPushMq(String processNo, List<String> businessNoList) {
        log.info("\u5dee\u5f02\u8d39\u7528\u8ffd\u8e2a\u5ba1\u6279\u901a\u8fc7\u63a8\u9001MQ{}", (Object)JSON.toJSONString(businessNoList));
        if (CollectionUtils.isEmpty(businessNoList)) {
            return;
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String accountJson = "";
        String currentAccount = "";
        if (this.loginUserService != null) {
            currentAccount = this.loginUserService.getLoginAccountName();
            AbstractCrmUserIdentity userIdentity = this.loginUserService.getAbstractLoginUser();
            accountJson = Objects.isNull(userIdentity) ? null : JSON.toJSONString((Object)userIdentity);
        }
        for (AuditFeeDiffTrackPassMqTagEnum mqTagEnum : AuditFeeDiffTrackPassMqTagEnum.values()) {
            RocketMqProducerEvent rocketMqProducerEvent = new RocketMqProducerEvent((Object)this, currentAccount, accountJson, false, uuid, "TPM_AUDIT_FEE_DIFF_TRACK_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment(), mqTagEnum.getCode(), JSON.toJSONString(businessNoList));
            this.eventPublisher.publishEvent((ApplicationEvent)rocketMqProducerEvent);
        }
    }
}

