/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.notifier.log;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.log.AuditFeeCheckLogEventDto;
import com.biz.crm.tpm.business.audit.fee.sdk.event.check.AuditFeeCheckLogEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditFeeCheckLogEventListenerImpl
implements AuditFeeCheckLogEventListener {
    @Autowired(required=false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    public void onCreate(AuditFeeCheckLogEventDto dto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, dto);
    }

    public void onDelete(AuditFeeCheckLogEventDto dto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, dto);
    }

    public void onUpdate(AuditFeeCheckLogEventDto dto) {
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        this.buildCrmBusinessLog(crmBusinessLogDto, dto);
    }

    public void onEnable(AuditFeeCheckLogEventDto eventDto) {
    }

    public void onDisable(AuditFeeCheckLogEventDto eventDto) {
    }

    private void buildCrmBusinessLog(CrmBusinessLogDto crmBusinessLogDto, AuditFeeCheckLogEventDto eventDto) {
        crmBusinessLogDto.setOnlyKey(eventDto.getNewest().getId());
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject((Object)eventDto.getOriginal());
        crmBusinessLogDto.setNewObject((Object)eventDto.getNewest());
        this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}

