/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.repository.check;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckCost;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckCostMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckCostDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckCostVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class AuditFeeCheckCostRepository
extends ServiceImpl<AuditFeeCheckCostMapper, AuditFeeCheckCost> {
    public Page<AuditFeeCheckCostVo> findByConditions(Page<AuditFeeCheckCostVo> page, AuditFeeCheckCostDto dto) {
        return ((AuditFeeCheckCostMapper)this.baseMapper).findByConditions(page, dto);
    }

    public AuditFeeCheckCost findById(String id) {
        return (AuditFeeCheckCost)((Object)((AuditFeeCheckCostMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public List<AuditFeeCheckCost> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<AuditFeeCheckCost> findDetailByMatchCode(String matchCode) {
        if (StringUtils.isEmpty((CharSequence)matchCode)) {
            return new ArrayList<AuditFeeCheckCost>(0);
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditFeeCheckCost::getAuditFeeCheckCode, (Object)matchCode)).list();
    }

    public List<AuditFeeCheckCost> findByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheckCost::getAuditFeeCheckCode, matchCodes)).list();
    }

    public List<String> findCompanyCostCodeByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return new ArrayList<String>(0);
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().select(new SFunction[]{AuditFeeCheckCost::getCompanyCostCode}).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheckCost::getAuditFeeCheckCode, matchCodes)).list();
        if (CollectionUtils.isEmpty(matchCodes)) {
            return new ArrayList<String>(0);
        }
        return list.stream().map(AuditFeeCheckCost::getCompanyCostCode).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void updateDelFlagByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isNotEmpty(matchCodes)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheckCost::getAuditFeeCheckCode, matchCodes)).update();
        }
    }

    public void updateDelFlagByMatchCodes(List<String> companyCostCodes, String matchCode) {
        if (CollectionUtils.isNotEmpty(companyCostCodes) && matchCode != null) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditFeeCheckCost::getAuditFeeCheckCode, (Object)matchCode)).in(AuditFeeCheckCost::getCompanyCostCode, companyCostCodes)).update();
        }
    }

    public void cleanPosMatchRemarkByMatchCodes(List<String> matchCodes) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(AuditFeeCheckCost::getPosRemark, (Object)"")).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheckCost::getAuditFeeCheckCode, matchCodes)).update();
    }

    public void deleteUsedCosts(List<String> md5UniqueKeyList) {
        if (CollectionUtils.isEmpty(md5UniqueKeyList)) {
            return;
        }
        ((AuditFeeCheckCostMapper)this.baseMapper).deleteUsedCosts(md5UniqueKeyList);
    }

    public AuditFeeCheckCost findOneByMd5UniqueKey(String md5UniqueKey) {
        if (md5UniqueKey == null) {
            return null;
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        query.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        query.eq(AuditFeeCheckCost::getAuditFeeCheckCode, (Object)"");
        query.eq(AuditFeeCheckCost::getMd5UniqueKey, (Object)md5UniqueKey);
        query.last("limit 1");
        return (AuditFeeCheckCost)((Object)this.getOne((Wrapper)query));
    }

    public List<String> findCompanyCostCodesByMd5UniqueKey(String md5UniqueKey) {
        if (md5UniqueKey == null) {
            return Collections.emptyList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().select(new SFunction[]{AuditFeeCheckCost::getCompanyCostCode}).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditFeeCheckCost::getMd5UniqueKey, (Object)md5UniqueKey)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        return list.stream().map(AuditFeeCheckCost::getCompanyCostCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public AuditFeeCheckCost findSumAmountByMd5UniqueKey(String md5UniqueKey) {
        if (md5UniqueKey == null) {
            return null;
        }
        return ((AuditFeeCheckCostMapper)this.baseMapper).findSumAmountByMd5UniqueKey(md5UniqueKey, TenantUtils.getTenantCode());
    }

    public void updateMatchedByMd5UniqueKey(String md5UniqueKey, String matchCode) {
        if (md5UniqueKey == null || matchCode == null) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(AuditFeeCheckCost::getAuditFeeCheckCode, (Object)matchCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditFeeCheckCost::getAuditFeeCheckCode, (Object)"")).eq(AuditFeeCheckCost::getMd5UniqueKey, (Object)md5UniqueKey)).update();
    }

    public boolean updatePosRemarkByMatchCodeList(List<String> matchCodeList, String posRemark) {
        if (CollectionUtils.isEmpty(matchCodeList)) {
            return true;
        }
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(AuditFeeCheckCost::getPosRemark, (Object)posRemark)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheckCost::getAuditFeeCheckCode, matchCodeList)).update();
    }

    public List<String> findMatchCodesByCostCode(List<String> deductionCodeList) {
        if (CollectionUtils.isEmpty(deductionCodeList)) {
            return new ArrayList<String>(0);
        }
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.select(new String[]{"DISTINCT audit_fee_check_code"}).lambda().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheckCost::getCompanyCostCode, deductionCodeList);
        List list = this.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<String>(0);
        }
        return list.stream().map(AuditFeeCheckCost::getAuditFeeCheckCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public AuditFeeCheckCost findByCompanyCode(String companyCode) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        query.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        query.eq(AuditFeeCheckCost::getCompanyCostCode, (Object)companyCode);
        query.last("limit 1");
        return (AuditFeeCheckCost)((Object)this.getOne((Wrapper)query));
    }

    public List<String> findExistByCompanyCodes(List<String> companyCodes) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.select(new String[]{"DISTINCT company_cost_code"}).lambda().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheckCost::getCompanyCostCode, companyCodes);
        List list = this.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<String>(0);
        }
        return list.stream().map(AuditFeeCheckCost::getCompanyCostCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    public AuditFeeCheckCost initOne() {
        AuditFeeCheckCost cost = new AuditFeeCheckCost();
        cost.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        cost.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        cost.setTenantCode(TenantUtils.getTenantCode());
        return cost;
    }
}

