/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.repository.check;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDetailPlan;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckDetailPlanShare;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckDetailPlanMapper;
import com.biz.crm.tpm.business.audit.fee.local.repository.check.AuditFeeCheckDetailPlanShareRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditFeeCheckDetailPlanRepository
extends ServiceImpl<AuditFeeCheckDetailPlanMapper, AuditFeeCheckDetailPlan> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditFeeCheckDetailPlanShareRepository auditFeeCheckDetailPlanShareRepository;

    public Page<AuditFeeCheckDetailPlanVo> findByConditions(Page<AuditFeeCheckDetailPlanVo> page, AuditFeeCheckDetailPlanDto dto) {
        return ((AuditFeeCheckDetailPlanMapper)this.baseMapper).findByConditions(page, dto);
    }

    public AuditFeeCheckDetailPlan findById(String id) {
        return (AuditFeeCheckDetailPlan)((Object)((AuditFeeCheckDetailPlanMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public List<AuditFeeCheckDetailPlan> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<AuditFeeCheckDetailPlan> findDetailByMatchCode(String matchCode) {
        if (StringUtils.isEmpty((CharSequence)matchCode)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditFeeCheckDetailPlan::getAuditFeeCheckCode, (Object)matchCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<AuditFeeCheckDetailPlanVo> findDetailPlanByMatchCode(String matchCode) {
        if (StringUtils.isEmpty((CharSequence)matchCode)) {
            return Lists.newArrayList();
        }
        return ((AuditFeeCheckDetailPlanMapper)this.baseMapper).findDetailPlanByMatchCode(matchCode, TenantUtils.getTenantCode());
    }

    public List<AuditFeeCheckDetailPlan> findDetailByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(AuditFeeCheckDetailPlan::getAuditFeeCheckCode, matchCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<AuditFeeCheckDetailPlan> findByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheckDetailPlan::getAuditFeeCheckCode, matchCodes)).list();
    }

    public List<String> findDetailPlanItemCodeByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return new ArrayList<String>(0);
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().select(new SFunction[]{AuditFeeCheckDetailPlan::getDetailPlanItemCode}).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheckDetailPlan::getAuditFeeCheckCode, matchCodes)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<String>(0);
        }
        return list.stream().map(AuditFeeCheckDetailPlan::getDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<AuditFeeCheckDetailPlan> findByDetailPlanItemCodeList(List<String> detailPlanItemCodeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(AuditFeeCheckDetailPlan::getDetailPlanItemCode, detailPlanItemCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public int getCountByAuditCode(List<String> auditCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheckDetailPlan::getAuditCode, auditCodes)).count();
    }

    public void updateStatusByAuditCodes(List<String> auditCodes) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheckDetailPlan::getAuditCode, auditCodes)).set(AuditFeeCheckDetailPlan::getIsCreatedByFee, (Object)BooleanEnum.FALSE.getCapital())).set(AuditFeeCheckDetailPlan::getAuditDetailCode, (Object)"")).set(AuditFeeCheckDetailPlan::getAuditCode, (Object)"")).update();
    }

    public void updateDelFlagByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheckDetailPlan::getAuditFeeCheckCode, matchCodes)).update();
        this.auditFeeCheckDetailPlanShareRepository.deleteByMatchCodes(matchCodes);
    }

    public List<String> findNoConfirmByDetailPlanItemCodeList(List<String> detailPlanItemCodes) {
        return ((AuditFeeCheckDetailPlanMapper)this.baseMapper).findNoConfirmByDetailPlanItemCodeList(detailPlanItemCodes, TenantUtils.getTenantCode());
    }

    public void updateMatchCodeByMatchCostAndPos(String matchCode, List<String> posIds) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(AuditFeeCheckDetailPlan::getAuditFeeCheckCode, (Object)matchCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheckDetailPlan::getPosId, posIds)).update();
    }

    public void removeByMatchCodeList(List<String> matchCodeList) {
        if (CollectionUtils.isEmpty(matchCodeList)) {
            return;
        }
        LambdaUpdateWrapper logicRemoveDetailPlan = new LambdaUpdateWrapper();
        logicRemoveDetailPlan.in(AuditFeeCheckDetailPlan::getAuditFeeCheckCode, matchCodeList);
        logicRemoveDetailPlan.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        logicRemoveDetailPlan.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        this.update((Wrapper)logicRemoveDetailPlan);
        AuditFeeCheckDetailPlanShare auditFeeCheckDetailPlanShare = new AuditFeeCheckDetailPlanShare();
        auditFeeCheckDetailPlanShare.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        LambdaUpdateWrapper logicRemoveDetailPlanShare = new LambdaUpdateWrapper();
        logicRemoveDetailPlanShare.in(AuditFeeCheckDetailPlanShare::getAuditFeeCheckCode, matchCodeList);
        logicRemoveDetailPlanShare.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        logicRemoveDetailPlanShare.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        this.auditFeeCheckDetailPlanShareRepository.update((Wrapper)logicRemoveDetailPlanShare);
    }

    public void save(List<AuditFeeCheckDetailPlanVo> detailPlanVos) {
        if (CollectionUtils.isEmpty(detailPlanVos)) {
            return;
        }
        Collection auditFeeCheckDetailPlans = this.nebulaToolkitService.copyCollectionByWhiteList(detailPlanVos, AuditFeeCheckDetailPlanVo.class, AuditFeeCheckDetailPlan.class, HashSet.class, ArrayList.class, new String[0]);
        this.saveBatch(auditFeeCheckDetailPlans);
    }

    public void saveWithShare(List<AuditFeeCheckDetailPlanVo> detailPlanVos) {
        if (CollectionUtils.isEmpty(detailPlanVos)) {
            return;
        }
        this.save(detailPlanVos);
        List shareList = detailPlanVos.stream().map(e -> {
            AuditFeeCheckDetailPlanShare detailPlanShare = new AuditFeeCheckDetailPlanShare();
            detailPlanShare.setAuditFeeCheckCode(e.getAuditFeeCheckCode());
            detailPlanShare.setDetailPlanItemCode(e.getDetailPlanItemCode());
            detailPlanShare.setAuditFeeCheckShareAmount(e.getAuditFeeCheckShareAmount());
            detailPlanShare.setToBeSupplementedAmount(e.getToBeSupplementedAmount());
            detailPlanShare.setThisAuditAmount(e.getThisAuditAmount());
            detailPlanShare.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            detailPlanShare.setTenantCode(TenantUtils.getTenantCode());
            detailPlanShare.setId(null);
            return detailPlanShare;
        }).collect(Collectors.toList());
        this.auditFeeCheckDetailPlanShareRepository.saveBatch(shareList);
    }

    public AuditFeeCheckDetailPlan initOne() {
        AuditFeeCheckDetailPlan detailPlan = new AuditFeeCheckDetailPlan();
        detailPlan.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        detailPlan.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        detailPlan.setTenantCode(TenantUtils.getTenantCode());
        return detailPlan;
    }

    public List<AuditFeeCheckDetailPlanVo> findActivityAndShareByActivityItemCodes(List<String> activityItemCodes) {
        if (CollectionUtils.isEmpty(activityItemCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeCheckDetailPlanVo> list = ((AuditFeeCheckDetailPlanMapper)this.baseMapper).findActivityAndShareByActivityItemCodes(activityItemCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }
}

