/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.repository.check;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheckPos;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckPosMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckPosDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckPosVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditFeeCheckPosRepository
extends ServiceImpl<AuditFeeCheckPosMapper, AuditFeeCheckPos> {
    public Page<AuditFeeCheckPosVo> findByConditions(Pageable pageable, AuditFeeCheckPosDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (StringUtils.isEmpty((CharSequence)(dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckPosDto())).getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return ((AuditFeeCheckPosMapper)this.baseMapper).findByConditions((Page<AuditFeeCheckPosVo>)page, dto);
    }

    public List<AuditFeeCheckPos> findByPosId(List<String> posIds) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, posIds)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<AuditFeeCheckPos> findByMatchCode(String matchCode) {
        if (StringUtils.isEmpty((CharSequence)matchCode)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditFeeCheckPos::getMatchCode, (Object)matchCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<AuditFeeCheckPos> findByMatchCodeList(List<String> matchCodeList) {
        if (CollectionUtil.isEmpty(matchCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(AuditFeeCheckPos::getMatchCode, matchCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void updateStatusByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).set(AuditFeeCheckPos::getIsMatchCost, (Object)BooleanEnum.FALSE.getCapital())).set(AuditFeeCheckPos::getIsMatchActivity, (Object)BooleanEnum.FALSE.getCapital())).set(AuditFeeCheckPos::getCompanyCostCode, null)).set(AuditFeeCheckPos::getItemIndex, null)).set(AuditFeeCheckPos::getMatchCode, null)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheckPos::getMatchCode, matchCodes)).update();
    }

    public void updateRemark(List<String> ids, String remark) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(UuidFlagOpEntity::getRemark, (Object)remark)).in(UuidEntity::getId, ids)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public void updateFeeCheckPos(AuditFeeCheckPosDto dto) {
        if (Objects.isNull(dto)) {
            return;
        }
        if (CollectionUtil.isEmpty((Collection)dto.getIds())) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, (Collection)dto.getIds())).set(AuditFeeCheckPos::getMatchHeadCode, (Object)dto.getMatchHeadCode())).set(AuditFeeCheckPos::getMatchStatus, (Object)dto.getMatchStatus())).set(AuditFeeCheckPos::getTotalDiffFinalAmount, (Object)dto.getTotalDiffFinalAmount())).set(AuditFeeCheckPos::getDiffUse, (Object)dto.getDiffUse())).set(AuditFeeCheckPos::getMatchTime, (Object)new Date())).set(UuidFlagOpEntity::getRemark, (Object)dto.getRemark())).update();
    }

    public AuditFeeCheckPos findByIdOrCode(String id, String matchCode) {
        if (StringUtils.isEmpty((CharSequence)id) && StringUtils.isEmpty((CharSequence)matchCode)) {
            return null;
        }
        return (AuditFeeCheckPos)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)id), UuidEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((CharSequence)matchCode), AuditFeeCheckPos::getMatchCode, (Object)matchCode)).one());
    }

    public List<AuditFeeCheckPos> listIdsByIds(List<String> idList) {
        if (CollectionUtil.isEmpty(idList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, idList)).list();
    }

    public void updateAmountById(AuditFeeCheckPos entity) {
        if (Objects.isNull((Object)entity) || StringUtils.isEmpty((CharSequence)entity.getId())) {
            return;
        }
        ((AuditFeeCheckPosMapper)this.baseMapper).updateAmountById(entity);
    }

    public List<AuditFeeCheckPos> findByFeeCheckMatchCodes(List<String> feeCheckMatchCodes) {
        if (CollectionUtils.isEmpty(feeCheckMatchCodes)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(AuditFeeCheckPos::getFeeCheckMatchCode, feeCheckMatchCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public void computeTotalDiffAmount(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        ((AuditFeeCheckPosMapper)this.baseMapper).computeTotalDiffAmount(idList);
    }
}

