/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.repository.check;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.check.AuditFeeCheck;
import com.biz.crm.tpm.business.audit.fee.local.mapper.check.AuditFeeCheckMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckSelectDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchStatusEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditFeeCheckRepository
extends ServiceImpl<AuditFeeCheckMapper, AuditFeeCheck> {
    public Page<AuditFeeCheckVo> findByConditions(Page<AuditFeeCheckVo> page, AuditFeeCheckDto dto) {
        return ((AuditFeeCheckMapper)this.baseMapper).findByConditions(page, dto);
    }

    public AuditFeeCheck findById(String id) {
        return (AuditFeeCheck)((Object)((AuditFeeCheckMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public List<AuditFeeCheck> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updateDelFlagByMatchCodes(List<String> matchCodeList) {
        if (CollectionUtils.isEmpty(matchCodeList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(AuditFeeCheck::getMatchCode, matchCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<AuditFeeCheck> getPlanCheckAccountData(AuditFeeCheckDto dto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditFeeCheck::getMatchStatus, (Object)MatchStatusEnum.MATCHED.getCode())).and(e -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)e.ne(AuditFeeCheck::getIsConfirm, (Object)BooleanEnum.TRUE.getCapital())).or()).isNull(AuditFeeCheck::getIsConfirm);
        })).list();
    }

    public List<AuditFeeCheck> findByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return new ArrayList<AuditFeeCheck>(0);
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheck::getMatchCode, matchCodes)).list();
    }

    public List<String> findConfirmedByMatchCodes(List<String> matchCodes) {
        if (CollectionUtils.isEmpty(matchCodes)) {
            return new ArrayList<String>(0);
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().select(new SFunction[]{AuditFeeCheck::getMatchCode}).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(AuditFeeCheck::getIsConfirm, (Object)BooleanEnum.TRUE.getCapital())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheck::getMatchCode, matchCodes)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<String>(0);
        }
        return list.stream().map(AuditFeeCheck::getMatchCode).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String findMappingCode(String matchCode) {
        return ((AuditFeeCheckMapper)this.baseMapper).findMappingCode(matchCode);
    }

    public void diffDisposeDeletedUpdateStatus(List<String> matchCodes) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFeeCheck::getMatchCode, matchCodes)).set(AuditFeeCheck::getIsAlreadyDiff, (Object)BooleanEnum.FALSE.getCapital())).update();
    }

    public Page<AuditFeeCheckVo> findByConditionsForEct(Page<AuditFeeCheckVo> page, AuditFeeCheckSelectDto dto) {
        return ((AuditFeeCheckMapper)this.baseMapper).findByConditionsForEct(page, dto);
    }

    public AuditFeeCheck findByMatchCode(String matchCode) {
        return (AuditFeeCheck)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditFeeCheck::getMatchCode, (Object)matchCode)).one());
    }

    public List<AuditFeeCheck> findNotConfirmedDiff(String templateCode) {
        if (StringUtil.isEmpty((CharSequence)templateCode)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditFeeCheck::getIsConfirmDiff, (Object)BooleanEnum.FALSE.getCapital())).eq(AuditFeeCheck::getIsConfirm, (Object)BooleanEnum.FALSE.getCapital())).eq(AuditFeeCheck::getMatchTemplateCode, (Object)templateCode)).list();
    }

    public AuditFeeCheck initOne() {
        AuditFeeCheck feeCheck = new AuditFeeCheck();
        feeCheck.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        feeCheck.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        feeCheck.setTenantCode(TenantUtils.getTenantCode());
        return feeCheck;
    }

    public Page<String> findNotConfirmedDiffPage(Pageable pageable, AuditFeeCheckDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditFeeCheckDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (StringUtil.isEmpty((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return ((AuditFeeCheckMapper)this.baseMapper).findNotConfirmedDiffPage((Page<String>)page, dto);
    }
}

