/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.repository.prediction;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.local.entity.prediction.AuditFeePrediction;
import com.biz.crm.tpm.business.audit.fee.local.mapper.prediction.AuditFeePredictionMapper;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.prediction.AuditFeePredictionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.prediction.AuditFeePredictionVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Optional;
import jodd.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFeePredictionRepository
extends ServiceImpl<AuditFeePredictionMapper, AuditFeePrediction> {
    public List<AuditFeePrediction> findAll(String wholeAudit) {
        if (StringUtils.isEmpty((CharSequence)wholeAudit)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditFeePrediction::getWholeAudit, (Object)wholeAudit)).list();
    }

    public List<AuditFeePrediction> findByActivityDetailPlanItemCodes(List<String> activityDetailPlanItemCodes) {
        if (CollectionUtils.isEmpty(activityDetailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(AuditFeePrediction::getDetailPlanItemCode, activityDetailPlanItemCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).orderByAsc(AuditFeePrediction::getDetailPlanItemCode)).list();
    }

    public Page<AuditFeePredictionVo> findByConditions(Pageable pageable, AuditFeePredictionDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (StringUtil.isEmpty((CharSequence)(dto = Optional.ofNullable(dto).orElse(new AuditFeePredictionDto())).getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return ((AuditFeePredictionMapper)this.baseMapper).findByConditions((Page<AuditFeePredictionVo>)page, dto);
    }

    public Page<String> findDetailPlanCodes(Pageable pageable) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((AuditFeePredictionMapper)this.baseMapper).findDetailPlanCodes((Page<String>)page);
    }

    public List<String> findExistItemCode(List<String> itemCodeList) {
        return ((AuditFeePredictionMapper)this.baseMapper).findExistItemCode(itemCodeList);
    }
}

