/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckDetailPlan;
import com.biz.crm.tpm.business.audit.fee.local.entity.settlement.check.AuditFeeSettlementCheckDetailPlanShare;
import com.biz.crm.tpm.business.audit.fee.local.mapper.settlement.check.AuditFeeSettlementCheckDetailPlanMapper;
import com.biz.crm.tpm.business.audit.fee.local.repository.settlement.check.AuditFeeSettlementCheckDetailPlanShareRepository;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.settlement.check.AuditFeeSettlementCheckDetailPlanDto;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.settlement.check.AuditFeeSettlementCheckDetailPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFeeSettlementCheckDetailPlanRepository
extends ServiceImpl<AuditFeeSettlementCheckDetailPlanMapper, AuditFeeSettlementCheckDetailPlan> {
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AuditFeeSettlementCheckDetailPlanShareRepository auditFeeSettlementCheckDetailPlanShareRepository;

    public List<AuditFeeSettlementCheckDetailPlan> findByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditFeeSettlementCheckDetailPlan::getCode, (Object)code)).list();
    }

    public List<AuditFeeSettlementCheckDetailPlanVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        return ((AuditFeeSettlementCheckDetailPlanMapper)this.baseMapper).findWithShare(ids, TenantUtils.getTenantCode());
    }

    public Page<AuditFeeSettlementCheckDetailPlanVo> findByConditions(Page<AuditFeeSettlementCheckDetailPlanVo> page, AuditFeeSettlementCheckDetailPlanDto dto) {
        return ((AuditFeeSettlementCheckDetailPlanMapper)this.baseMapper).findByConditions(page, dto);
    }

    public void removeByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(AuditFeeSettlementCheckDetailPlan::getCode, codes)).remove();
        LambdaQueryWrapper deleteShareWrapper = new LambdaQueryWrapper();
        deleteShareWrapper.in(AuditFeeSettlementCheckDetailPlanShare::getCode, codes);
        this.auditFeeSettlementCheckDetailPlanShareRepository.remove((Wrapper)deleteShareWrapper);
    }

    public void removeByCodeAndFeeDetailCode(String code, List<String> feeDetailCodes) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(AuditFeeSettlementCheckDetailPlan::getCode, (Object)code)).remove();
    }

    public List<AuditFeeSettlementCheckDetailPlanDto> findDtoByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return Lists.newArrayList();
        }
        List<AuditFeeSettlementCheckDetailPlanVo> list = ((AuditFeeSettlementCheckDetailPlanMapper)this.baseMapper).findWithShareByCodes(Lists.newArrayList((Object[])new String[]{code}), TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, AuditFeeSettlementCheckDetailPlanVo.class, AuditFeeSettlementCheckDetailPlanDto.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public void saveWithShare(List<AuditFeeSettlementCheckDetailPlan> detailPlanList) {
        if (CollectionUtils.isEmpty(detailPlanList)) {
            return;
        }
        ArrayList shares = new ArrayList(detailPlanList.size());
        detailPlanList.forEach(e -> {
            e.setId(null);
            AuditFeeSettlementCheckDetailPlanShare share = new AuditFeeSettlementCheckDetailPlanShare();
            share.setCode(e.getCode());
            share.setDetailPlanItemCode(e.getDetailPlanItemCode());
            share.setAuditFeeCheckShareAmount(e.getAuditFeeCheckShareAmount());
            share.setToBeSupplementedAmount(e.getToBeSupplementedAmount());
            share.setThisAuditAmount(e.getThisAuditAmount());
            shares.add(share);
        });
        this.saveBatch(detailPlanList);
        this.auditFeeSettlementCheckDetailPlanShareRepository.saveBatch(shares);
    }

    public List<AuditFeeSettlementCheckDetailPlanVo> findActivityAndShareByActivityItemCodes(List<String> activityItemCodes) {
        if (CollectionUtils.isEmpty(activityItemCodes)) {
            return Lists.newArrayList();
        }
        List<AuditFeeSettlementCheckDetailPlanVo> list = ((AuditFeeSettlementCheckDetailPlanMapper)this.baseMapper).findActivityAndShareByActivityItemCodes(activityItemCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public List<String> findNoConfirmByDetailPlanItemCodeList(List<String> detailPlanItemCodes) {
        return ((AuditFeeSettlementCheckDetailPlanMapper)this.baseMapper).findNoConfirmByDetailPlanItemCodeList(detailPlanItemCodes, TenantUtils.getTenantCode());
    }
}

